#include "pt.h"
#include "string.h"

#ifdef OVERLAYS
void cdecl
/* XTAG:overlayDriver */
overlayDriver(ax, bx, cx, dx, si, di)
	unsigned int ax, bx, cx, dx, si, di;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern unsigned char *screenMap;
	extern struct SREGS segRegs;
	extern int scrRows, scrCols;
	extern struct window *windowList;
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern int debug;
	extern struct window *activeWindow;
	extern struct openFile *files;
	extern struct event events[];
	extern int addHandle;
	extern unsigned char charTable[];
	extern int quitExecuted;

	struct window *w, *wId;
	unsigned char ch, *cp;
	unsigned char far *fp;
	unsigned int i, n, iBuffer, *p;
	long l, offset, block;
	struct diskBuffer *buf;

	switch( ax ) {
	default:
		break;

	case 1:		/* read one character */
		fp = makeFarPointer(cx, dx);
		ax = (unsigned int)readChar(activeWindow->fileId, (long)fp);
		break;

	case 2:		/* get span in disk cache buffer */
		l = (long)makeFarPointer(cx, dx);
		ax = getSpan(activeWindow->fileId, l,
			(unsigned char far **)&cx, (unsigned char far **)&si,
			0);
		break;

	case 3:		/* top the active window */
		doTopWindow(activeWindow, bx);
		break;

	case 4:		/* scroll the active window up or down */
		setMap(activeWindow->row1, activeWindow->col1,
			activeWindow->row2, activeWindow->col2, 1, 0x07);
		maskTop(activeWindow);
		if( bx == 0 )
			downScroll(activeWindow, cx);
		else
			upScroll(activeWindow, cx);
		break;

	case 5:		/* change the active window */
		cx = (unsigned int)activeWindow;
		if( validWindowIdentifier(bx) ) {
			activeWindow = (struct window *)bx;
			ax = 0;
		} else
			ax = 1;
		break;

	case 6:		/* set the selection */
		/* convert to segment/offset (=long) form */
		selBegin = (((long)(unsigned)dx) << 16) + ((unsigned)cx);
		selEnd = (((long)(unsigned)di) << 16) + ((unsigned)si);
		/* Do some checking to be safe. We don't want some other */
		/* program to be able to crash Point*/
		l = fileSize(selWindow->fileId) - 1;
		if( selBegin < 0 )
			selBegin = 0;
		if( selBegin > l )
			selBegin = l;
		if( selEnd < selBegin )
			selEnd = selBegin;
		if( selEnd > l )
			selEnd = l;
		if( bx == 1 ) {
			doGoSel(selWindow);
			goto deleteChars;
		}
		break;

	case 7:		/* redraw the screen */
	redrawScreen:
		redrawBox(0, 0, scrRows-1, scrCols-1);
		updateScreen(0, scrRows-1);
		break;

	case 8:		/* insert character at insertion point */
		insertChar((unsigned char)bx);
		break;

	case 9:		/* delete characters */
	deleteChars:
		deleteChars(selWindow->fileId, 0, 1);
		break;

	case 10:	/* display message */
		movedata(dx, cx, segRegs.ds, (unsigned int)&msgBuffer[0], 78);
		msgBuffer[78] = '\0';
		msg(msgBuffer, bx);
		break;

	case 11:	/* insert string at insertion point */
		fp = makeFarPointer(cx, dx);
		if( si == 1 ) {		/* hide the inserted piece */
			l = selBegin;	/* save the beginning of the insert */
		}
		for(i = 0; i < bx; ++i)
			insertChar(*fp++);
		if( si == 1 ) {
			insertChar(0);	/* mark the end */
			hidePiece(l);
		}
		break;

	case 12:	/* return selection information */
		ax = selMode;
		bx = (unsigned int)selWindow;
		p = (unsigned int *)&selBegin;
		cx = *p++;
		dx = *p;
		p = (unsigned int *)&selEnd;
		si = *p++;
		di = *p;
		break;

	case 13:	/* set selection information */
		if( validWindowIdentifier(bx) ) {
			ax = 0;
			selWindow = (struct window *)bx;
			if( 0 <= cx && cx <= 2 )
				selMode = cx;
			else
				ax = 2;
		} else
			ax = 1;
		break;

	case 14:        /* get input from user */
		movedata(dx, cx, segRegs.ds, (int)&msgBuffer[0], 80);
		msgBuffer[79] = '\0';
		movedata(di, si, segRegs.ds, (int)&msgBuffer[80], 80);
		msgBuffer[159] = '\0';
		cp = getInput(&msgBuffer[0], &msgBuffer[80], bx);
		if( cp != NULL ) {
			n = 1 + strlen(&cp[0]);    /* +1 for the newline */
			movedata(segRegs.ds, (int)cp, dx, cx, n);
			ax = 0;
		} else	/* user pressed ESCape */
			ax = 1;
		break;

	case 15:	/* get window location */
		if( validWindowIdentifier(bx) ) {
			si = 0;
			w = (struct window *)bx;
			ax = w->row1;
			bx = w->col1;
			cx = w->row2;
			dx = w->col2;
		} else
			si = 1;
		break;

	case 16:	/* get window information */
		if( validWindowIdentifier(bx) ) {
			w = (struct window *)bx;
			n = strlen(files[w->fileId].origName);
			movedata(segRegs.ds,
				(unsigned int)files[w->fileId].origName,
				dx, cx, n + 1);
			ax = w->numTopline;
			bx = w->numBotline;
			p = (unsigned int *)&w->posTopline;
			cx = *p++;
			dx = *p;
			p = (unsigned int *)&w->posBotline;
			si = *p++;
			di = *p;
		} else
			ax = (unsigned int)-1;
		break;

	case 17:	/* move window to line number */
		doGoto(activeWindow, bx);
		break;

	case 18:	/* move the active window */
		/* make sure the values are vaild */
		if( cx < 0 )
			cx = 0;
		else if( cx > scrRows - 4 )
			cx = scrRows - 4;
		if( si < cx + 3 )
			si = cx + 3;
		else if( si >= scrRows )
			si = scrRows - 1;

		if( dx < 0 )
			dx = 0;
		else if( dx > scrCols - 11 )
			dx = scrCols - 11;
		if( di < dx + 10 )
			di = dx + 10;
		else if( dx >= scrCols )
			dx = scrCols - 1;

		activeWindow->row1 = cx;
		activeWindow->col1 = dx;
		activeWindow->row2 = si;
		activeWindow->col2 = di;
		break;

	case 19:	/* create a new window */
		if( bx != 0 ) {		/* temporary window */
			cp = NULL;
		} else {
			cp = &msgBuffer[150];
			movedata(di, si, segRegs.ds, (unsigned int)cp, 80);
		}
		w = createWindow(cp, cx&0xFF, (cx>>8)&0xFF, dx&0xFF,
			(dx>>8)&0xFF, 0, bx);
		if( w == NULL )
			ax = 1;
		else {
			activeWindow = w;
			ax = 0;
			if( bx != 0 ) {
				/* save the selection state so we can */
				/* insert characters into the new window */
				wId = selWindow;
				selWindow = w;
				block = selBegin;
				offset = selEnd;
				selBegin = selEnd = 0L;
				fp = makeFarPointer(si, di);
				while( 1 ) {
					ch = *fp++;
					if( ch == '\0' )
						break;
					insertChar(ch);
				}
				/* restore the selection state */
				selWindow = wId;
				selBegin = block;
				selEnd = offset;
				/* return the windowId */
				bx = (unsigned int)w;
				goto redrawScreen;
			}
		}
		bx = (unsigned int)w;	/* return the windowId */
		break;

	case 20:	/* close the active window */
		closeWindow(activeWindow, bx, 1);
		activeWindow = windowList;
		break;

	case 21:	/* save the file in the active window */
		saveFile(activeWindow);
		break;

	case 22:	/* get identifier of the next window */
		ax = 0;
		if( bx == 0 ) {
			bx = (unsigned int)windowList;
			break;
		}
		if( validWindowIdentifier(bx) ) {
			w = (struct window *)bx;
			bx = (unsigned int)(w->nextWindow);
		} else
			ax = 1;
		break;

	case 23:	/* convert from line numbers and offsets */
		--bx;	/* user line numbers start with 1, so line */
			/* number 5 (for instance) starts by going 4 */
			/* lines down from the beginning of the file */
		l = nextLine(activeWindow->fileId, 0L, &bx);
		p = (unsigned int *)&l;
		cx = *p++;
		dx = *p;
		break;

	case 24:	/* search for a string */
		movedata(dx, cx, segRegs.ds, (unsigned int)&msgBuffer[0], 80);
		l = searchExternal(msgBuffer, selWindow, (bx>>8)&0xFF,
			bx&0xFF);
		p = (unsigned int *)&l;
		cx = *p++;
		dx = *p;
		break;

	case 25:	/* execute a Point command */
		if( validWindowIdentifier(bx) ) {
			ax = 0;
			command(cx, '\0', (struct window*)bx);
		} else
			ax = 1;
		break;

	case 26:	/* get input event */
		/* are there any typed characters? */
		if( isKeystroke() != 0 ) {
			cx = getKeystroke((unsigned char *)&dx);
			bx = 1;		/* keystroke found */
			break;
		}
		/* is there a mouse event? */
		if( isMouseEvent(0) ) {
			bx = 2;		/* mouse event found */
			ax = getMouseEvent();
			cx = events[ax].vertical>>3;
			dx = events[ax].horizontal>>3;
			si = events[ax].buttons;
			di = events[ax].mask;
			break;
		}
		bx = 0;		/* no event pending */
		break;

	case 27:	/* handle input event */
		if( bx == 1 ) {		/* keyboard event */
			interp((unsigned char)cx, (unsigned char)dx);
			break;
		} else if( bx == 2 ) {	/* mouse event */
			(void)mouseButton(cx);
		} else {	/* error -- invalid event type */
			msg("Invalid event on interface call", 3);
		}
		break;

	case 28:	/* find next file mark */
		if( !validWindowIdentifier(bx) ) {
			ax = 1;
			break;
		}
		ax = 0;		/* no errors yet! */
		l = (((long)(unsigned)di) << 16) + ((unsigned)si);
		l = findHiddenPiece((struct window *)bx, l, &offset);
		if( l != -1L ) {
			i = 0;	/* index into screenMap buffer */
			/* use screenMap as a scratch buffer since it */
			/* will not be in user here */
			iBuffer = BUFFERSIZE;
			while( 1 ) {
				if( iBuffer >= BUFFERSIZE ) {
					block = offset>>BUFFERSHIFT;
					iBuffer = (unsigned int)
							offset % BUFFERSIZE;
					buf = getBuffer(addHandle, block);
					fp = buf->bufferAddress;
				}
				ch = *(fp + (iBuffer++));
				++offset;
				/* check for scratch buffer overflow */
				if( i >= MAXROWS*MAXCOLS-1) {
					/* simuate the end of the string */
					ch = '\0';
					ax = 2;
				}
				screenMap[i++] = ch;
				/* check for the end of the string */
				if( ch == '\0' )
					break;
			}
			movedata(segRegs.ds, (unsigned int)&screenMap[0], dx,
				cx, i);
		}
		p = (unsigned int *)&l;
		cx = *p++;
		dx = *p;
		break;

	case 29:	/* delete all file marks in file in window bx */
		if( !validWindowIdentifier(bx) ) {
			ax = 1;
			break;
		}
		ax = deleteHiddenText((struct window *)bx);
		break;

	case 30:	/* display a menu */
		fp = makeFarPointer(si, di);
		bx = menu((struct menuBlock far *)fp, cx, dx);
		break;

	case 31:	/* set up Anasazi */
#ifdef ANASAZI
		anasazi = bx;
		if( bx == 1 ) {
			charTable[cx] = 5;
			charTable[dx] = 5;
		}
#endif
		break;

	case 32:	/* overlay suspend */
		mainLoop();
		/* pass on the new argument string */
		if( quitExecuted )
			strcpy(textBuffer, "0" );
		cx = (unsigned int)&textBuffer[0];
		dx = segRegs.ds;
		/* return to the overlay */
		break;
	}
}

int pascal
/* XTAG:validWindowIdentifier */
validWindowIdentifier(n)
	unsigned int n;
{
	extern struct window *windowList;

	register struct window *w;
	struct window *wId;

	wId = (struct window *)n;
	w = windowList;
	while( w != NULL && w != wId )
		w = w->nextWindow;
	return (w != NULL);
}
#endif

unsigned char far * pascal
/* XTAG:makeFarPointer */
makeFarPointer(offset, segment)
	unsigned int offset, segment;
{
	register unsigned int *p;
	unsigned char far *fp;

	p = (unsigned int *)&fp;
	*p++ = offset;
	*p = segment;
	return fp;
}
