#define LINT_ARGS
#include "funcdecl.h"
#include "stdio.h"
#include "dos.h"
#include "ctype.h"
#include "signal.h"
#include "setjmp.h"
#include "conio.h"

#define max(a,b)	(((a) > (b)) ? (a) : (b))
#define min(a,b)	(((a) < (b)) ? (a) : (b))

/******* parameters -- can be changed *****/
#define	NBUFFERS      300  /* buffers for file blocks (in address space) */
#define	NHISTORY      100  /* history kept in memory */
#define	NBUFHASH       16  /* buffer hash chains */
#define	MSGBUFFERSIZE 256  /* size of two generally used buffers */
#define	STRINGSIZE     50  /* size of input strings for search */
#define	NEVENTS	       30  /* number of mouse button events to queue */
#define	MAXMENUITEMS   24  /* maximum number of items on a menu */
#define	MENUSPACE    4500  /* size of the buffer for user menu items */
#define	NMENUS	       17  /* number of pop-up menus */
#define SPACELOW     1024  /* low memory message threshold */
#define NCOLORCYCLES   10  /* number of color combinations */

/****** constants that are rarely changed */
#define	BUFFERSIZE	1024	/* size of a buffer in bytes */
#define	BUFFERSHIFT	10	/* shift to convert: bytes<-->buffers */
#ifdef GENIUS66
#define	MAXROWS		66	/* max number of rows on the display */
#else
#define	MAXROWS		43	/* max number of rows on the display */
#endif
#define	MAXCOLS		80	/* max number of columns on the display */
#define FILENAMESIZE	68	/* includes drive identifier */

/* string names */
#define HANDLEMSG		1
#define FULLMSG			2
#define MENUSPMSG		3
#define NOSPACEMSG		4
#define LOWSPACEMSG		5
#define OUTOFWINDOWS		6
#define NOBUFFERMEMORY		7
#define OUTOFFILESTRUCT		8
#define CANNOTOPEN		9
#define READONLYFILE		10
#define WRITINGFILE		11
#define CLOSEFAILED		12
#define RENAMEFAILED		13
#define DELETEFAILED		14
#define RENAMEFAILED2		15
#define WRITECANCELLED		16
#define FILEEXISTS		17
#define XXXXXXXX		18
#define FILEWRITTEN		19
#define WRITEFAILED		20
#define CREATEFAILED		21
#define WRITEPROGRESS		22
#define WASREADONLY		23
#define YTOSAVE			24
#define CLOSECANCELLED		25
#define NOTOPEN			26
#define CLOSEFAILED2		27
#define REANMEFAILED2		28
#define DELETEFAILED2		29
#define RENAMEFAILED3		30

/* Define the functions to be mapped to keys */
#define FNOTMAPPED	0
#define FCHARACTER	1
#define FCOPY		2
#define FMOVE		3
#define FDELETE		4
#define FQUITASK	5
#define FDEBUG		6
#define FNEWWINDOW	7
#define FTOPFILE	8
#define FBOTFILE	9
#define FREDRAW		10
#define FZOOM		11
#define FTOP		12
#define FRESIZE		13
#define FPGUP		14
#define FPGDN		15
#define FGOTO		16
#define FCLOSEWINDOW	17
#define FWRITEFILE	18
#define FSEARCH		19
#define FREPLACE	20
#define FINFORM		21
#define FCANCEL		22
#define FASCII		23
#define FREDO		24
#define FUNDO		25
#define FSELECT		26
#define FREPSEARCH	27
#define FTOPBOTTOM	28
#define FBOTTOM		29
#define FEXECCMD	30
#define FDONOTHING	31
#define FEXECSHELL	32
#define FLOADFILE	33
#define FCURUP		34
#define FCURDOWN	35
#define FCURLEFT	36
#define FCURRIGHT	37
#define FHIDE		38
#define FEXTEND		39
#define FUNDOBACK	40
#define FBEGINLINE	41
#define FENDLINE	42
#define FLEFTMBUTTON	43
#define FRIGHTMBUTTON	44
#define FMOUSECOM1	45
#define FMOUSECOM2	46
#define FSAVEALL	47
#define FQUITSAVE	48
#define FQUITNOSAVE	49
#define FMENU1		50
#define FMENU2		51
#define FMENU3		52
#define FCONTEXTMENU	53
#define FSAVEFILE	54
#define FINSKEY		55
#define FGOBACKTO	56
#define FCOPYSCRAP	57
#define FGOTOSELECTION	58
#define FCTAG		59
#define FMENU4		60
#define FDELNOSCRAP	61
#define FEXCHSCRAP	62
#define FCTAGSEL	63
#define FHELP		64
#define FMENU5		65
#define FBACKSEARCH	66
#define FMENU6		67
#define FTOPLINE	68
#define FCOPYTO		69
#define FMOVETO		70
#define FCHANGEMENU	71
#define FCLOSESAVE	72
#define FLOADSEL	73
#define FWORDLEFT	74
#define FWORDRIGHT	75
#define FRECORDMACRO	76
#define FPLAYMACRO	77
#define FTOPSELFILE	78
#define FMENU7		79
#define FMENU8		80
#define FRECAPITALIZE	81
#define FNEWSEL		82
#define FMATCHCHAR	83
#define FSELGOTO	84
#define FJUSTIFY	85
#define FREADONLY	86
#define FCYCLECOLORS	87
#define FSWAPTOP	88
#define FOVERLAY	89
#define FREPLACECMD	90
#define FTAG		91
#define FTAGSEL		92
#define FKEYWORD	93
#define FKEYWORDSEL	94
#define F66LINES	95
#define FMENU9		96
#define FMENU10		97
#define FMENU11		98
#define FMENU12		99
#define FMENU13		100
#define FMENU14		101
#define FMENU15		102
#define FMENU16		103

/* option setting commands */
#define FFIRSTOPTION	104
#define FUNUSED1	104
#define FAUTOSAVEINTERVAL 105
#define FAUTOSCROLLRATE	106
#define FAUTOINDENT	107
#define FBORDERCOLORS	108
#define FCENTERMENUS	109
#define FDOUBLECLICKDELAY 110
#define FFILEPATTERN	111
#define FFILESORT	112
#define FFINDWHOLEWORDS	113
#define FFSDIRS		114
#define FFSMENU		115
#define FFSPATTERNS	116
#define FHELPMODE	117
#define FI43LINES	118
#define FIGNORECASE	119
#define FUNUSED2	120
#define FLINESOVERFIND	121
#define FUNUSED11	122
#define FUNUSED3	123
#define FMSGCOLORS	124
#define FUNUSED4	125
#define FUNUSED14	126
#define FUNUSED12	127
#define FPATHNAMES	128
#define FOVERTYPE	129
#define FOREADONLY	130
#define FREDEFINE	131
#define FRESEARCH	132
#define FRIGHTMARGIN	133
#define FSCROLLDELAY	134
#define FSCROLLRATE	135
#define FSEARCHMODE	136
#define FSMOOTHSCROLL	137
#define FTABWIDTH	138
#define FUNUSED15	139
#define FTOPONFIND	140
#define FTAGPATTERN	141
#define FTAGMARKER	142
#define FTEXTCOLORS	143
#define FUNUSED5	144
#define FUNIXMODE	145
#define FVIDEOMODE	146
#define FUNUSED6	147
/* room for more options */
#define FLASTOPTION	169

/* mouse positions -- returned by xyToPos */
#define	OUTSIDEWINDOW	0
#define	UPPERLEFT	1
#define	UPPERRIGHT	2
#define	UPPERBORDER	3
#define	LOWERLEFT	4
#define	LOWERRIGHT	5
#define	LOWERBORDER	6
#define	RIGHTBORDER	7
#define	LEFTBORDER	8
#define	INSIDEWINDOW	9
#define	TOPLINE		10

/* buttons pressed -- used in mouse.c */
#define LEFTBUTTON		0
#define RIGHTBUTTON		11
#define BOTHBUTTONS		22

/* used in the piece table -- original or new characters file */
#define	ORIGFILE	0
#define	ADDFILE		1

/* deleteSelection update type */
#define NOUPDATE	0
#define UPDATEWINDOWS	1

/* copyMove modes */
#define	COPY		0
#define	MOVE		1
#define	REDO		2

/* create modes */
#define	CRTOP		0
#define	CRBOTTOM	1

/* shift, control, and alt keys masks */
#define	RIGHTSHIFT	0x1
#define	LEFTSHIFT	0x2
#define	SHIFTKEYS	6x3
#define	CONTROLKEY	0x4
#define	SFTCONKEYS	0x7
#define	ALTKEY		0x8


/* selection modes */
#define	SELCHAR	0
#define	SELWORD	1
#define	SELLINE	2
#define	SELALL	3

/* color cycle stucture */
/* XTAG:colorCycle */
struct colorCycle {
	unsigned char textColor, selColor;
	unsigned char bannerColor, borderColor, elevColor;
};


/* long pointer structure */
/* XTAG:longPointer */
struct longPointer {
	char *offset;
	char *segment;
};

/* XTAG:menuBlock */
struct menuBlock {
	int nItems;
	unsigned char far *cmdName[MAXMENUITEMS];
	int cmdNumber[MAXMENUITEMS];
};

/* mouse button event */
/* XTAG:event */
struct event {
	int mask, buttons;
	int horizontal, vertical;
};

/* change history */
/* XTAG:changeItem */
struct changeItem {
	int type;
	int fileId;
	long position;
	long length;
	struct piece *firstPiece;
};

/* change types */
#define CNULL		0
#define CINSERT		1
#define CDELETE		2
#define CMOVE		3
#define CCOPY		4

/* option items */
/* XTAG:optionItem */
struct optionItem {
	unsigned char *name;
	int index;
	int *variable;
	int type;
	int commandNumber;
};

/* option type values */
#define OBOOLEAN	0
#define OINTEGER	1
#define OOTHERS		2
#define UBOOLEAN	3
#define UINTEGER	4
#define UOTHERS		5
#define OSTRING		6
#define USTRING		7

/* option index values */
#define OFILESORT	0
#define OMSGCOLORS	1
#define ONBUFFERS	2
#define OTEXTCOLORS	3
#define OBORDERCOLORS	4
#define OFSDIRS		5
#define OUNDOSIZE	6
#define O43LINES	7
#define OFSPATTERNS	8
#define OUNUSED2	9
#define OREDEFINE	10
#define OLASTITEM	-1

/* the window structure */

/* XTAG:window */
struct window {
	/* linked list of active windows */
	struct window *nextWindow;
	struct window *prevWindow;

	/* boundries of the window*/
	int row1, row2, col1, col2;

	/* saved (after zoom) window boundries */
	int saveRow1, saveRow2, saveCol1, saveCol2;

	/* cursor position and line number */
	/* of the top and bottom lines in the window */
	long posTopline, posBotline;
	int numTopline, numBotline;

	/* remember the line we last jumped from */
	int rowLastline;
	
	/* remember the last line the found the mouse cursor on */
	int rowCurLast;
	long posCurLast, lastPosTop;

	/* indent of the first character in each line visible */
	int indent;
	
	/* state of the window */
	/* Meaning of the bits in the window state: */
	/* bit 0 : 0 => free window; 1 => used window */
	/* bit 1 : 0 => DOS window; 1 => UNIX window */
	/* bit 2 : 0 => regular window; 1 => temporary window */
	/* bit 3 : 0 => no banner; 1 => filename only on banner */
		/* bit 3 meaningful only if bit 2 == 1 */
	int state;

	/* name and internal (to this program) identifier */
	/* of the file the window is displaying */
	int fileId;	/* of the file in the window */
	int nameOffset;	/* into the file name in the backing file */

	/* colors */
	unsigned char textColor;
	unsigned char selColor;
	unsigned char bannerColor;
	unsigned char borderColor;
	unsigned char elevColor;
	unsigned char textCycle, borderCycle;
};

/* a PIECE is a sequence of characters that is contiguous in the logical */
/* and physical files.  Originally the file is one (big) piece.  As edits */
/* are made it is divided into more pieces.  The characters in a piece */
/* are either in the original (unchanged) file or in the add file (which) */
/* contains all characters that have been added to the file in this editing */
/* session */

/* XTAG:piece */
struct piece {
	int  file;	/* DOS file handle */
	long position;	/* start of the piece */
	long length;	/* length of the piece */
	struct piece *nextPiece;	/* next piece in the list */
	struct piece *prevPiece;	/* previous piece in the list */
};

/* An open file consists of the original file (which is not changed during */
/* an editing session) and an add file (where all new characters go). */
/* The logical file is described in the pieces table which shows where */
/* the logically contiguous characters in the file are physically located */

/* XTAG:openFile */
struct openFile {

	/* the original file size */
	long origFileSize;

	/* the current logical file size -- changed as the file is edited */
	/* NOT the same as the size of origfile or addfile or their sum */
	long fileSize;

	/* the file being edited -- this is read only */
	unsigned char origName[FILENAMESIZE];
	int origHandle;

	/* the piece list */
	struct piece *pieceList;

	/* optimization fields */
	/* loLogPiece and hiLogPiece are the low and high logical addresses */
	/* that are mapped by piece number logPiece which is the last piece */
	/* where a byte was found and is initialized to the one big piece */
	/* that is the whole file when you start editing. */
	/* The idea is that once you map a logical byte to a piece, it is */
	/* likely that the next mapping is in the same piece. */
	/* loLogBuffer and hiLogBuffer are the logical character limits of */
	/* some valid characters in a buffer pointed to by logBuffer. */
	long loLogPiece, hiLogPiece, loLogBuffer, hiLogBuffer;
	struct piece *logPiece;
	unsigned char *logBufSegment;
	unsigned char *logBufOffset;

	/* some file status flags */
	unsigned char useCount;	/* the number of windows using the file */

	unsigned char bakMade;	/* .bak file has been made */

	unsigned char readOnly;	/* file cannot be changed */

	unsigned char isChanged;	/* file has been edited */
};

/* a disk buffer (both in and out of the address space) */
/* XTAG:diskBuffer */
struct diskBuffer {
	int handle;	/* DOS file handle */
	/* double linked hash chain links */
	struct diskBuffer *forwardHash, *backwardHash;
	long blockNumber;
	unsigned char far *bufferAddress;
	unsigned char written;	/* =1 if an add file block */
};
