#define VERSION "1.01"

/***********************************************8

    QFIX.C v 1.01  by Shaun Case  Feb 21 1991
    Released to the public domain Feb 21 1991

    Platform: PC clones under MS DOS 2.10 or higher (?)
    Supports  CGA/EGA/VGA/MCGA.
              Untested on Hercules -- probably won't work.
              MDA may not work either.

    Compiler: Turbo C++ 2.0  (should work under TC 2.0)

    Purpose:  Qfix gets around Qedit's annoying habit of
              not restoring the screen when it terminates
              if it detects that it is unregistered.  To
              combat this annoyance, Qfix will save the current
              screen to a disk file, and later restore it.

              This program will also function perfectly with other
              software that does not restore the screen, but should.

    Instructions:

              To use Qfix, you should rename Qedit from Q.EXE to
              QEDIT.EXE, and create the following batchfile,
              called Q.BAT:


              @echo off
              qfix save f:\tmp\q.sav
              qedit %1 %2 %3 %4 %5 %6 %7 %8 %9
              qfix restore f:\tmp\q.sav


              Replace f:\tmp\ above to any path that contains
              at least 15k free space.  The size of the save
              file varies, depending on the mode you are in.
              You can count on something between 2k (for 40X25
              mode) and ~12k for 132X43 (the mode I use.)

              Make sure that the above batch file is in your path.

              I put QCONFIG.DAT, Q.BAT, QEDIT.EXE, and QFIX.EXE all
              in a ramdisk (which is what f:\tmp is on my system.)
              This makes everything run really, really fast, and
              you won't notice the screen being restored at all
              after you have used it for a while.  If you use it
              on a floppy system, well, it's going to be pretty
              darn slow.

              If you are using a version of DOS older than 3.30,
              you should replace the first line of the batch file
              above with just "echo off", with no '@' in front.
              The '@' just keeps the "echo off" message from being
              displayed, and looks a little nicer.

    Moralizing:

              Incidentally, I do sort of believe in registering shareware,
              if you get the urge, but what I really believe in is
              donating both your executables AND YOUR SOURCE to anything
              useful you write into the public domain.  If more people
              would share code, the world would be a better place.  For
              instance, this code should save and restore most text
              video modes correctly.  It is my sincere hope that someone
              uses this code (or at least some of it) when writing
              screen savers. I currently use one called EXPLOSIV, which
              only restores HALF my screen when I am in 132X43 mode.  It
              is quite annoying.  Anyhow, here it is, and happy
              Qediting!  ($55 is a bit pricey, don't you think?)

    PS:       If my code looks formatted strangely, it is partly because
              I wrote it in 132 column mode.  If you can, you should try
              coding in this mode -- it is fantastic to be able to see
              two or three times as much code on the screen at once.

**************/


#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <dos.h>
#include <mem.h>


typedef struct v7 {
    int mode;
    int screenheight;
    int screenwidth;
    int curx;
    int cury;
    int attribute;
};

main(int argc, char **argv)
{
        void v7_getmode(struct v7 *info); /* prototype, get video info       */
        void goxy(int x, int y);          /* prototype, gotoxy() replacement */

        struct v7 video_info;           /* my custom routine to get info  */
        int buffsize;                   /* size of screen buffer required */
        FILE *fp;                       /* file pointer for save file     */
        void *textbuff;                 /* buffer to save screen in       */
        char *fname;
        char errmsg[]="QFIX Ver " VERSION " by Shaun Case 1991  PUBLIC DOMAIN\n"
                      "\nusage:\n\n"
                      "Make a batch file that looks something like this:\n\n"
                      "qfix s<ave> c:\saved.scr\n"
                      "qedit %1\n"
                      "qfix r<estore> c:\saved.scr\n"
                      "\n"
                      "then rename Q.EXE to QEDIT.EXE";

        char firstletter;               /* first letter of first CL arg   */
        int hatsize;                    /* filler, unused, reserved, etc. */


        firstletter=tolower(argv[1][0]);

        /* if invoked incorrectly... */
        if ((argc!=3) || ((firstletter !='s') && (firstletter !='r')) ) 
        {
            puts(errmsg);     /* print an error message */
            return 1;         /* and jump ship          */
        }

        fname = argv[2];    /* get filename from command line arguments */

        switch(firstletter) /* do stuff, either save or restore screen  */
        {

        case 's':   v7_getmode(&video_info);                      /* get screen mode info  */
                    buffsize = 2 * video_info.screenwidth *       /* calculate space req.  */
                        video_info.screenheight * sizeof(char);   /*   to save the screen  */
                    textbuff = calloc(buffsize, sizeof(char));    /* allocate buffer space */
                    if ((fp  = fopen(fname,"wb"))==NULL)          /* open save file        */
                    {
                        puts("Unable to save screen to hard disk.  How sad.");
                        return 1;
                    }
                    movedata(0xb800, 0x0000, FP_SEG(textbuff),    /* get the screen from    */
                       FP_OFF(textbuff), buffsize);               /*   video mem to buffer  */
                    fwrite(&video_info, sizeof(struct v7), 1, fp);/* save screen inf 2 disk */
                    fwrite(textbuff, buffsize, 1, fp);            /* save buffer - fwrite() */
                    fclose(fp);                                   /*   won't take far ptrs  */
                                                                  /*   as an argument       */
                    break;

        case 'r':   if ((fp = fopen(fname,"rb"))==NULL)
                    {
                        puts("Unable to restore screen from hard disk.  How sad.");
                        return 1;
                    }
                    fread(&video_info, sizeof(struct v7), 1, fp);  /* get screen mode info   */
                    buffsize = 2 * video_info.screenwidth *        /* calculate buffer size  */
                       video_info.screenheight * sizeof(char);
                    textbuff = calloc(buffsize, sizeof(char));     /* allocate buffer space  */
                    fread(textbuff, buffsize, 1, fp);              /* get buffer from disk   */
                    fclose(fp);
                    movedata(FP_SEG(textbuff), FP_OFF(textbuff),   /* restore screen to      */
                       0xb800, 0x0000, buffsize);                  /*   video memory, fread  */
                                                                   /*   won't take far ptr   */
                                                                   /*   an arg either. ptui. */
                    textattr(video_info.attribute);                /* restore current colors */
                    goxy(video_info.curx, video_info.cury);        /* restore cursor postn   */
                    unlink(fname);                                 /* delete screen from dsk */
                    break;

        default:    puts("Oh shit, hide the kids.");               /* Hide the women, too.   */
                    return 1;
        }
        return 0;
}

/**********
 *
 * int v7_getmode( struct v7 *info )
 *
 * gets mode, screenwidth, and screenheight for Video 7 VGA card,
 *    maybe others as well.
 *
 * gotta try that someday...
 *
 * patched to work with normal video cards 2/21/91 STC
 *
 * structure definition:
 *
 * typedef struct v7 {
 *   int mode;
 *   int screenheight;
 *   int screenwidth;
 *   int curx;
 *   int cury;
 *   int attribute;
 * };
 *
 *  be sure to #include <dos.h> and <conio.h> !!
 *
 ***********/

void v7_getmode(struct v7 *info)
{
     static union REGS inregs, outregs;
     struct text_info info_tmode;    /* info about current text mode */
                                     /* for regular video cards      */

     inregs.h.ah=0x6f;               /* setup for Video 7 getmode    */
     inregs.h.al=0x04;
     int86(0x10, &inregs, &outregs);

     info->mode=(int)outregs.h.al;
     info->screenheight=outregs.x.cx;
     info->screenwidth=outregs.x.bx;

     gettextinfo(&info_tmode);             /* get curs pos & colors  */
     info->attribute=info_tmode.attribute;
     info->curx=info_tmode.curx;
     info->cury=info_tmode.cury;

     /* patch for anything that isn't my video card: */
     /* At least Jason's EGA card returns 0 X 0 for  */
     /* screen size when using int 10, function 6F   */

     if (
         (info->screenheight < 24  ) ||
         (info->screenheight > 60  ) ||
         (info->screenwidth  < 40  ) ||
         (info->screenwidth  > 132 )
        )
     /* Assume worst case. */
     {
        info->screenheight = 60;
        info->screenwidth  = 132;
     }
}

/*************
 *
 * void goxy(int x, int y)
 *
 * will place cursor at x,y on screen, even
 * outside the normal 80 X 25 window, which
 * gotoxy() won't do.  Another broken Borland function! :-(
 *
 * x min is 1, y min is 1, although no checking is done.
 *
 *************/

void goxy(int x, int y)
{
     static union REGS inregs, outregs;

     inregs.h.ah=0x02;       /* function : set cursor             */
     inregs.h.bl=0x04;       /* page 0 (hopefully the current one */
     inregs.h.dh=(char)--y;  /* 1st y pos is really 0             */
     inregs.h.dl=(char)--x;  /* 1st x pos is really 0             */
     int86(0x10, &inregs, &outregs);
}
