/* ---------------------------------------------------------------------- */
/*   Mickiano.c (C) Copyright Bill Buckels 1990-1999                      */
/*   All Rights Reserved.                                                 */
/*                                                                        */
/*   Licence Agreement                                                    */
/*   -----------------                                                    */
/*                                                                        */
/*   Mickiano is distributed as ShareWare.                                */
/*   Suggested Registration is $10.00 per family.                         */
/*                                                                        */
/*   You are expected to register with the Author if you use Mickiano     */
/*   beyond a 30-day evaluation period. Send registration in the form of  */
/*   cheque, or money order to:                                           */
/*                                                                        */
/*   Bill Buckels                                                         */
/*   589 Oxford Street                                                    */
/*   Winnipeg, Manitoba, Canada R3M 3J2                                   */
/*                                                                        */
/*   Email: bbuckels@escape.ca                                            */
/*   WebSite: http://www.escape.ca/~bbuckels                              */
/*                                                                        */
/*   Registered users of Mickiano have a royalty-free right to use,       */
/*   reproduce and distribute this source code (and/or any modified       */
/*   version) in any way you find useful, provided you do not compete     */
/*   with Bill Buckels or his agents, and that you agree that Bill        */
/*   Buckels has no warranty obligations or liability whatsoever          */
/*   resulting from any associated loss or damage.                        */
/*                                                                        */
/*   If you do not agree with these terms, remove this source and         */
/*   all associated files from your computer now.                         */
/*                                                                        */
/*   Description                                                          */
/*   -----------                                                          */
/*                                                                        */
/*   Mickiano is a Mouse Piano program which uses the PC speaker to play  */
/*   sound files. Mickiano uses 4-color CGA Graphics Display Mode.        */
/*                                                                        */
/*   Mickiano is written in Large Model Microsoft C Version 6.00a         */
/* ---------------------------------------------------------------------- */


/* ---------------------------------------------------------------------- */
/* opening song */
/* musical array created from file ENTERTAN.SND */
/* array structure is frequency,duration */
int ENTERTAN[]={
  587,  2,32767,  1,  623,  2,32767,  1,  659,  2,32767,  1,
 1046,  5,32767,  1,  659,  2,32767,  1, 1046,  5,32767,  1,
  659,  2,32767,  1, 1046,  8,32767,  1,32767,  5,32767,  1,
32767,  2,32767,  1, 1046,  2,32767,  1, 1175,  2,32767,  1,
 1247,  2,32767,  1, 1318,  2,32767,  1, 1046,  2,32767,  1,
 1175,  2,32767,  1, 1318,  5,32767,  1,  988,  2,32767,  1,
 1175,  5,32767,  1, 1046,  5,32767,  1,32767,  5,32767,  1,
32767,  5,32767,  1,  587,  2,32767,  1,  623,  2,32767,  1,
  659,  2,32767,  1, 1046,  5,32767,  1,  659,  2,32767,  1,
 1046,  5,32767,  1,  659,  2,32767,  1, 1046,  8,32767,  1,
32767,  5,32767,  1,32767,  5,32767,  1,  880,  2,32767,  1,
  784,  2,32767,  1,  741,  2,32767,  1,  880,  2,32767,  1,
 1046,  2,32767,  1, 1318,  5,32767,  1, 1175,  2,32767,  1,
 1046,  2,32767,  1,  880,  2,32767,  1, 1175,  5,32767,  1,
32767,  5,32767,  1,32767,  5,32767,  1,  587,  2,32767,  1,
  623,  2,32767,  1,  659,  2,32767,  1, 1046,  5,32767,  1,
  659,  2,32767,  1, 1046,  5,32767,  1,  659,  2,32767,  1,
 1046,  8,32767,  1,32767,  5,32767,  1,32767,  5,32767,  1,
 1046,  2,32767,  1, 1175,  2,32767,  1, 1247,  2,32767,  1,
 1318,  2,32767,  1, 1046,  2,32767,  1, 1175,  2,32767,  1,
 1318,  5,32767,  1,  988,  2,32767,  1, 1175,  5,32767,  1,
 1046,  5,32767,  1,32767,  5,32767,  1,32767,  5,32767,  1,
 1046,  2,32767,  1, 1175,  2,32767,  1, 1318,  2,32767,  1,
 1046,  2,32767,  1, 1175,  2,32767,  1, 1318,  5,32767,  1,
 1046,  2,32767,  1, 1175,  2,32767,  1, 1046,  2,32767,  1,
 1318,  2,32767,  1, 1046,  2,32767,  1, 1175,  2,32767,  1,
 1318,  5,32767,  1, 1046,  2,32767,  1, 1175,  2,32767,  1,
 1046,  2,32767,  1, 1318,  2,32767,  1, 1046,  2,32767,  1,
 1175,  2,32767,  1, 1318,  5,32767,  1,  988,  2,32767,  1,
 1318,  5,32767,  1, 1046,  5,32767,  1,-1,-1};


/* closing song */
/* musical array created from file MAPLE.SND */
/* array structure is frequency,duration */
int MAPLE[]={
  392,  1,32767,  1,  467,  1,32767,  1,  312,  1,32767,  1,
  392,  1,32767,  1,  467,  3,32767,  1,  294,  1,32767,  1,
  467,  1,32767,  1,  294,  1,32767,  1,  349,  1,32767,  1,
  467,  1,32767,  1,  467,  8,32767,  1,32767,  1,32767,  1,
  392,  1,32767,  1,  467,  1,32767,  1,  312,  1,32767,  1,
  392,  1,32767,  1,  467,  3,32767,  1,  294,  1,32767,  1,
  467,  1,32767,  1,  294,  1,32767,  1,  349,  1,32767,  1,
  467,  2,  467,  4,  467,  4,  494,  4,  467,  4,  467,  4,
  467,  4,  494,  9,  467,  4,  467,  4,32767,  4,  312,  4,
  371,  4,  467,  4,  371,  4,  312,  4,  371,  4,  467,  4,
  623,  4,  623,  4,  623,  4,  623,  2,  623,  4,  467,  2,
  523,  2,  392,  2,  467,  2,  523,  4,  312,  4,  349,  2,
  371,  2,  312,  2,  349,  2,  392,  4,  312,  2,  392,  2,
  312,  2,  349,  4,  312,  4,  623,  2,  623,  4,  623,  4,
  623,  4,  623,  2,  623,  4,  467,  2,  523,  2,  392,  2,
  467,  2,  523,  4,  312,  2,  312,  2,  349,  2,  371,  2,
  312,  2,  349,  2,  392,  4,  312,  2,  392,  2,  312,  2,
  349,  4,  312,  4,-1,-1};

/* some embedded musical data if no external files */

int danube[]=
{
294,4,371,4,441,4,441,4,32767,4,882,2,32767,2,882,2,
32767,6,742,2,32767,2,742,2,32767,6,294,4,294,4,371,4,
441,4,441,4,32767,4,882,2,32767,2,882,2,32767,6,786,2,
32767,2,786,2,32767,6,278,4,278,4,330,4,495,4,495,4,
32767,4,990,2,32767,2,990,2,32767,6,786,2,32767,2,786,2,
32767,6,278,4,278,4,330,4,495,4,495,4,32767,4,990,2,
32767,2,990,2,32767,6,742,2,32767,2,742,2,32767,6,294,4,
294,4,371,4,441,4,589,4,32767,4,1178,2,32767,2,1178,2,
32767,6,882,2,32767,2,882,2,32767,6,294,4,294,4,371,4,
441,4,589,4,32767,4,1178,2,32767,2,1178,2,32767,6,990,2,
32767,2,990,2,32767,6,330,4,330,4,393,4,495,2,32767,2,
495,14,32767,2,416,4,441,4,742,16,589,4,371,4,371,8,
330,4,495,8,441,4,294,4,32767,2,294,2,294,4,32767,8,
441,2,32767,2,393,2,32767,6,441,2,32767,2,393,2,32767,6,
441,4,742,16,661,4,441,2,32767,2,371,2,32767,6,441,2,
32767,2,371,2,32767,6,441,4,661,16,589,4,441,2,32767,2,
393,2,32767,6,441,2,32767,2,393,2,32767,6,441,4,742,16,
661,4,441,4,589,4,661,4,742,4,882,8,786,4,742,2,
742,2,742,4,661,2,32767,2,589,4,32767,8,-1,-1
/* the blue danube walz -strauss */
};

int dvorak[]=
{
393,3,32767,2,441,1,393,3,32767,2,441,1,495,3,32767,2,
589,1,661,3,32767,2,589,1,786,3,32767,2,742,1,882,3,
32767,2,786,1,742,3,32767,2,882,1,786,3,32767,2,661,1,
589,3,32767,2,589,1,661,3,32767,2,589,1,786,3,32767,2,
661,1,589,3,32767,2,495,1,441,24,393,3,32767,2,441,1,
393,3,32767,2,441,1,495,3,32767,2,589,1,661,3,32767,2,
589,1,661,3,32767,2,742,1,882,3,32767,2,786,1,742,3,
32767,2,882,1,786,3,32767,2,661,1,589,3,32767,2,589,1,
786,3,32767,2,393,1,441,6,589,6,393,18,-1,-1
/* humoresque by dvorak */
};

int guonod[]=
{
221,1,32767,2,147,1,32767,5,294,3,294,3,278,3,248,3,
278,3,32767,3,294,3,330,3,32767,3,221,1,32767,2,147,1,
32767,5,294,3,294,3,278,3,248,3,278,3,32767,3,294,3,
330,3,32767,3,221,3,294,3,32767,3,350,3,441,6,393,3,
350,3,32767,3,441,3,525,6,467,3,441,3,32767,3,556,3,
661,6,589,3,556,3,467,3,441,3,393,3,350,3,330,3,
147,1,32767,5,294,3,294,3,278,3,248,3,278,3,32767,3,
294,3,330,3,32767,3,221,1,32767,2,147,1,32767,5,294,3,
294,3,278,3,248,3,278,3,32767,3,294,3,330,3,32767,3,
221,3,350,3,32767,3,441,3,525,6,467,3,441,3,393,3,
350,3,312,3,393,3,467,3,294,3,278,3,294,3,330,3,
32767,3,350,1,32767,2,330,9,294,1,-1,-1
/* funeral march of a marionette by guonod */
};

int mexico[]=
{
525,2,700,2,32767,2,525,2,700,2,32767,2,525,2,700,6,
32767,4,525,2,700,2,786,2,700,2,661,4,700,2,786,2,
32767,8,525,2,661,2,32767,2,525,2,661,2,32767,2,525,2,
661,6,32767,4,525,2,661,2,700,2,661,2,589,4,661,2,
700,2,32767,6,1049,2,990,2,1049,2,882,2,833,2,882,2,
700,2,661,2,700,2,525,2,32767,4,441,2,467,2,525,2,
589,2,661,2,700,2,786,2,882,2,935,2,786,2,32767,4,
935,2,882,2,935,2,786,2,742,2,786,2,661,2,624,2,
661,2,525,2,32767,4,1049,2,990,2,1049,2,1178,2,1049,2,
935,2,882,2,786,2,700,2,-1,-1
/* mexican hat dance */
};

int mozart[]=
{
624,2,589,2,589,4,624,2,589,2,589,4,624,2,589,2,
589,4,935,4,32767,4,935,2,882,2,786,4,786,2,700,2,
624,4,624,2,589,2,525,4,525,4,32767,4,589,2,525,2,
525,4,589,2,525,2,525,4,589,2,525,2,525,4,882,4,
32767,4,882,2,786,2,742,4,742,2,624,2,589,4,589,2,
525,2,467,4,467,4,32767,4,935,2,882,2,882,4,1049,4,
742,4,882,4,786,4,589,4,32767,4,935,2,882,2,882,4,
1049,4,742,4,882,4,786,4,935,4,882,2,786,2,700,2,
624,2,589,4,371,4,393,4,441,4,467,4,525,2,467,2,
441,4,393,4,589,4,32767,4,1112,8,1178,2,32767,6,1112,8,
1178,2,32767,6,1112,8,1178,4,1112,4,1178,4,1112,4,1178,4,-1,-1
/* symphony #40 by wolfgang mozart */
};

int sam[]=
{
523,3,32767,1,523,3,32767,1,587,3,32767,1,659,3,32767,1,
523,3,32767,1,659,3,32767,1,587,3,32767,1,392,3,32767,1,
523,3,32767,1,523,3,32767,1,587,3,32767,1,659,3,32767,1,
523,6,32767,1,392,6,32767,2,523,3,32767,1,523,3,32767,1,
587,3,32767,1,659,3,32767,1,698,3,32767,1,659,3,32767,1,
587,3,32767,1,523,3,32767,1,493,3,32767,1,493,3,32767,1,
440,3,32767,1,493,3,32767,1,523,6,32767,1,523,6,32767,3,-1,-1
/* yankee doodle */
};

int stars[]=
{
589,6,589,6,525,3,495,3,495,6,467,3,495,3,495,16,32767,2,
467,3,495,3,495,6,467,3,495,3,589,6,495,3,589,3,525,12,
441,6,32767,3,441,3,441,6,416,3,441,3,441,6,416,3,441,3,
525,16,32767,2,495,3,441,3,495,3,589,9,661,9,661,3,441,16,
32767,2,589,6,589,6,525,3,495,3,495,6,467,3,495,3,495,16,
32767,2,467,3,495,3,495,6,467,3,495,3,525,3,495,3,441,5,
371,1,441,12,393,6,32767,3,393,3,393,6,371,3,393,3,467,6,
441,3,393,3,786,15,32767,3,393,3,441,3,495,3,589,1,32767,2,
393,3,441,3,495,3,589,1,32767,2,294,3,330,5,495,1,441,12,393,1,
-1,-1
/* the stars and stripes forever
   john p. sousa  */
};

int bug[]=
{
294,1,32767,1,294,1,32767,1,294,1,32767,1,393,1,32767,5,
495,1,32767,3,294,1,32767,1,294,1,32767,1,294,1,32767,1,
393,1,32767,5,495,1,32767,5,147,1,32767,1,147,1,32767,1,
196,1,32767,3,393,1,32767,1,393,1,32767,1,371,1,32767,1,
371,1,32767,1,330,1,32767,1,330,1,32767,1,294,8,32767,2,
294,1,32767,1,294,1,32767,1,294,1,32767,1,371,1,32767,5,
441,1,32767,3,294,1,32767,1,294,1,32767,1,294,1,32767,1,
371,1,32767,5,441,1,32767,5,221,1,32767,1,221,1,32767,1,
147,1,32767,3,589,2,661,2,589,2,525,2,495,2,441,2,393,8,-1,-1
/* archie and mehitabel's lovesong */
};

int weasel[]=
{
393,2,32767,2,393,2,441,2,32767,2,441,2,495,2,589,2,
495,2,393,2,32767,2,294,2,393,2,32767,2,393,2,441,2,
32767,2,441,2,495,6,393,2,32767,2,294,2,393,2,32767,2,
393,2,441,2,32767,2,441,2,495,2,589,2,495,2,393,2,
32767,4,661,2,32767,4,441,2,32767,2,525,2,495,6,393,2,
32767,4,786,2,32767,2,786,2,661,2,32767,2,786,2,742,2,
882,2,742,2,589,2,32767,4,786,2,32767,2,786,2,661,2,
32767,2,786,2,742,6,589,2,32767,2,495,2,525,2,32767,2,
495,2,525,2,32767,2,589,2,661,2,32767,2,742,2,786,2,
32767,4,661,2,32767,4,441,2,32767,2,525,2,495,6,393,2,-1,-1
/* popgoestheweasel */
};

char *internal_tunes[]={
      "DANUBE",
      "DVORAK",
      "GUONOD",
      "MEXICO",
      "MOZART",
      "STARS",
      "SAM",
      "BUG",
      "WEASEL"};

#include <stdio.h>
#include <dos.h>
#include <graph.h>
#include <conio.h>
#include <string.h>
#include <malloc.h>

/* CGA palettes */
#define GRY     0
#define CMW     1

#define BLACK     0       /* standard IBM PC bios color indexes */
#define BLUE      1
#define GREEN     2
#define CYAN      3
#define RED       4
#define MAGENTA   5
#define BROWN     6
#define WHITE     7
#define GRAY      8
#define LBLUE     9
#define LGREEN    10
#define LCYAN     11
#define LRED      12
#define LMAGENTA  13
#define YELLOW    14
#define BWHITE    15
#define INTENSE   16      /* add to standard color to bump the intensity   */

/* note frequency data */

int notefrequency[7][12]={

/* C           D           E     F           G           A           B  */
/* 0     1     2     3     4     5     6     7    8      9     10    11 */
/* W     B     W     B     W     W     B     W    B      W     B     W  */
   65,   69,   73,   78,   82,   87,   93,   98,  104,  110,  117,  123,
  131,  139,  147,  156,  165,  175,  185,  196,  208,  220,  233,  247,
  262,  278,  294,  312,  330,  349,  371,  392,  416,  440,  467,  494,
  523,  555,  587,  623,  659,  698,  741,  784,  832,  880,  934,  988,
 1046, 1111, 1175, 1247, 1318, 1397, 1482, 1568, 1664, 1760, 1868, 1976,
 2093, 2221, 2349, 2493, 2637, 2794, 2965, 3136, 3328, 3520, 3736, 3951,
 4186, 4442, 4699, 4986, 5274, 5588, 5930, 6272, 6656, 7040, 7471, 7902};


int WHITES[21][6]={

/*    x1  y1  x2 y2   octave note*/
      2,  60, 17,140, 1,  0,
      18, 60, 32,140, 1,  2,
      33, 60, 47,140, 1,  4,
      48, 60, 62,140, 1,  5,
      63, 60, 77,140, 1,  7,
      78, 60, 92,140, 1,  9,
      93, 60,107,140, 1,  11,
      108,60,122,140, 2,  0,
      123,60,137,140, 2,  2,
      138,60,152,140, 2,  4,
      153,60,167,140, 2,  5,
      168,60,182,140, 2,  7,
      183,60,197,140, 2,  9,
      198,60,212,140, 2,  11,
      213,60,227,140, 3,  0,
      228,60,242,140, 3,  2,
      243,60,257,140, 3,  4,
      258,60,272,140, 3,  5,
      273,60,287,140, 3,  7,
      288,60,302,140, 3,  9,
      303,60,317,140, 3,  11};

int BLACKS[15][6]={
      13, 60,23, 105, 1,  1,
      28, 60,38, 105, 1,  3,

      58, 60,68, 105, 1,  6,
      73, 60,83, 105, 1,  8,
      88, 60,98, 105, 1,  10,

      118,60,128,105, 2,  1,
      133,60,143,105, 2,  3,

      163,60,173,105, 2,  6,
      178,60,188,105, 2,  8,
      193,60,203,105, 2,  10,

      223,60,233,105, 3,  1,
      238,60,248,105, 3,  3,

      268,60,278,105, 3,  6,
      283,60,293,105, 3,  8,
      298,60,308,105, 3,  10 };

int QUITBOX[]={ 272,176,319,199};
int FLIPBOX[]={ 0,  141,159,199};

#define TRUE  1
#define FALSE 0
int whitekey=TRUE;


/* ---------------------------------------------------------------------- */
/* SetCrtMode                                                             */
/* Sets the video mode using the standard bios int10h call.               */
/* ---------------------------------------------------------------------- */
void SetCrtMode(int m)
{
    union REGS rin,rout;
    rin.h.ah = 0;
    rin.h.al = m;
    int86(0x10,&rin,&rout);

}



/* ---------------------------------------------------------------------- */
/* SetScreenColor                                                         */
/* Sets the CGA Color and Palette using the standard bios int10h call.    */
/* ---------------------------------------------------------------------- */
int SetScreenColor(unsigned background, unsigned palette)
{
    union REGS rin,rout;

    rin.h.ah = 11;
    rin.h.bh = 0;
    rin.h.bl = (unsigned char)background;
    int86(0x10,&rin,&rout);
    rin.h.bh = 1;
    rin.h.bl = (unsigned char)palette;
    int86(0x10,&rin,&rout);
    return 0;
}


int EatKeys()
{
  int c = 0;
  if (kbhit()) {
    c = getch();
    if (c == 0)
      getch();
    while(kbhit())
      if (getch()==0)
        getch();
  }
  return c;
}


int keyplay(int i)
{
    /* input is note frequency       */
    /* returns position on the piano */

  whitekey = TRUE;

  /* note is not in range */
  if(i<64) return -1;
  if(i>4096)return -1;

  /* octave 0 */
  if(i<127)
  {
  if(i<67 ) return  14;
  if(i<71 ) { whitekey = FALSE;return  10;}
  if(i<76 ) return  15;
  if(i<80 ) { whitekey = FALSE;return  11;}
  if(i<85 ) return  16;
  if(i<90 ) return  17;
  if(i<96 ) { whitekey = FALSE;return  12;}
  if(i<101) return  18;
  if(i<107) { whitekey = FALSE;return  13;}
  if(i<114) return  19;
  if(i<120) { whitekey = FALSE;return  14;}
            return  20;
  }

  /* first octave */
  if(i<255)
  {
  if(i<136) return  0;
  if(i<143) { whitekey = FALSE;return  0;}
  if(i<152) return  1;
  if(i<160) { whitekey = FALSE;return  1;}
  if(i<170) return  2;
  if(i<180) return  3;
  if(i<190) { whitekey = FALSE;return  2;}
  if(i<202) return  4;
  if(i<215) { whitekey = FALSE;return  3;}
  if(i<227) return  5;
  if(i<240) { whitekey = FALSE;return  4;}
            return  6;
  }

  /* second octave */
  if(i<512)
  {
   if(i<270)return 7;
   if(i<286){ whitekey = FALSE;return 5;}
   if(i<304)return 8;
   if(i<322){ whitekey = FALSE;return 6;}
   if(i<340)return 9;
   if(i<360)return 10;
   if(i<382){ whitekey = FALSE;return 7;}
   if(i<406)return 11;
   if(i<428){ whitekey = FALSE;return 8;}
   if(i<454)return 12;
   if(i<480){ whitekey = FALSE;return 9;}
       return 13;
   }

   /* third octave */

  if(i<1024)
  {
  if(i<540)return 14;
  if(i<572){ whitekey = FALSE;return 10;}
  if(i<605)return 15;
  if(i<643){ whitekey = FALSE;return 11;}
  if(i<680)return 16;
  if(i<720)return 17;
  if(i<765){ whitekey = FALSE;return 12;}
  if(i<810)return 18;
  if(i<855){ whitekey = FALSE;return 13;}
  if(i<910)return 19;
  if(i<965){ whitekey = FALSE;return 14;}
  return 20;
  }

  /* fourth octave */

  if(i<2048)
  {
  if(i<1080) return  0;
  if(i<1144) { whitekey = FALSE;return  0;}
  if(i<1210) return  1;
  if(i<1286) { whitekey = FALSE;return  1;}
  if(i<1340) return  2;
  if(i<1440) return  3;
  if(i<1530) { whitekey = FALSE;return  2;}
  if(i<1620) return  4;
  if(i<1710) { whitekey = FALSE;return  3;}
  if(i<1820) return  5;
  if(i<1930) { whitekey = FALSE;return  4;}
            return  6;
  }

  /* fifth octave */
  /* sixth octave ignored */
   if(i<2160)return 7;
   if(i<2288){ whitekey = FALSE;return 5;}
   if(i<2420)return 8;
   if(i<2572){ whitekey = FALSE;return 6;}
   if(i<2680)return 9;
   if(i<2880)return 10;
   if(i<3060){ whitekey = FALSE;return 7;}
   if(i<3240)return 11;
   if(i<3420){ whitekey = FALSE;return 8;}
   if(i<3640)return 12;
   if(i<3860){ whitekey = FALSE;return 9;}

   return 13;

}



#define SILENCE 32767
#define QUIT  0
#define FLIP -1
int getfrequency(int x, int y)
{

    /* this function checks each of the hot zones on the piano    */
    /* returns the note frequency associated with that area       */
    /* if no hot area is active then the function returns SILENCE */

    int frequency = SILENCE;
    int i;

    /* check the quit box and return 0 if we're in range */
        if(x >= QUITBOX[0] && y >= QUITBOX[1] &&
           x <= QUITBOX[2] && y <= QUITBOX[3]) return QUIT;

   /* check to see if we're being asked to flip the page */
        if(x >= FLIPBOX[0] && y >= FLIPBOX[1] &&
           x <= FLIPBOX[2] && y <= FLIPBOX[3]) return FLIP;

    /* check the black keys */
    for(i=0;i!=15;i++)
    {
        /* if its in range return the frequency */
        if(x >= BLACKS[i][0] && y >= BLACKS[i][1] &&
           x <= BLACKS[i][2] && y <= BLACKS[i][3])
                   return notefrequency [BLACKS[i][4]] [BLACKS[i][5]];
     }

    /* check the white keys */
    for(i=0;i!=22;i++)
    {
        /* if its in range return the frequency */
        if(x >= WHITES[i][0] && y >= WHITES[i][1] &&
           x <= WHITES[i][2] && y <= WHITES[i][3])
                  return notefrequency [WHITES[i][4]] [WHITES[i][5]];
     }



   /* if we haven't hit a hot spot yet then we're not in range */
   return frequency;
}


/*                                                           */
/*  a sound function in microsoft C                          */
/*                                                           */

#define TIMEOUT 0x2c00

int sound(freq,tlen)
int freq;         /* freq of sound in Hertz                  */
int tlen;         /* duration of sound 18.2 ticks per second */
{
    union REGS inregs,outregs;
    unsigned frdiv = 1331000L/freq;   /* timer divisor */
    int seed,hiseed,hold=0,setting;


    if (freq != 32767) {
      outp(0x43,0xB6) ;           /* write timer mode register */
      outp(0x42,frdiv & 0x00FF);  /* write divisor LSB */
      outp(0x42,frdiv >> 8);      /* write divisor MSB */

      setting= inp(0x61);          /* get current port B setting */
      outp(0x61,setting | 0x03);   /* turn speaker on */
    }

    if(tlen>0){
       tlen=((tlen*1000)/182); /* convert from 18.2 ticks to 100ths */
       inregs.x.ax= TIMEOUT;
       int86(0x21,&inregs,&outregs);
       seed=(outregs.x.dx)&0xff;

    while(hold<tlen)
     {
       inregs.x.ax = TIMEOUT;
       int86(0x21,&inregs,&outregs);
       if(seed!=(outregs.x.dx&0xff))
        {
          hiseed= (outregs.x.dx)&0xff;
          if(hiseed<seed)hiseed+=100;
          hold+=(hiseed-seed);
          seed =(outregs.x.dx)&0xff;
          }
          }
          }

    if (freq != 32767)
      outp(0x61,setting);
    /* restore port B setting */
    return 0;
}

/* note: the arrow array corresponds to the pixel map and the number   */
/* corresponds to the desired pixel attribute. we use the 2-d array to */
/* construct a visual map of the cursor and call makemickey() to       */
/* produce the binary values. we can visually design any cursor mask   */
/* by overtyping this example.                                         */

short arrow[16][8]={   /* the cursor template */
0,1,1,1,1,1,1,1,
0,1,0,0,0,0,0,1,
0,1,0,1,1,1,0,1,
0,1,0,0,0,0,0,1,
0,1,0,1,1,1,0,1,       /* this type of array is usually referred     */
0,1,0,1,0,1,0,1,       /* to as a sprite                             */
0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,
0,1,0,1,1,1,0,1,
1,1,0,1,1,0,0,1,
1,0,0,1,1,0,0,1,
1,0,0,1,1,0,0,1,
1,0,0,1,1,1,1,1,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0};

short zorro[16][8]={   /* the screen mask */
3,0,0,0,0,0,0,0,
3,0,0,0,0,0,0,0,       /* the outline of the shape defined by arrow    */
3,0,0,0,0,0,0,0,       /* is made invisible by anding with 3.          */
3,0,0,0,0,0,0,0,       /* the shape is anded with 0 to remain visible. */
3,0,0,0,0,0,0,0,
3,0,0,0,3,0,0,0,
3,0,0,0,3,0,0,0,
3,0,0,0,3,0,0,0,
3,0,0,0,3,0,0,0,
3,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,3,3,3,3,
3,3,3,3,3,3,3,3};

/* icons for the player piano sequence */
char bptr[]={
        '\x18','\x00','\x14','\x00',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\x95','\x55','\xab',
        '\x90','\x01','\xab',
        '\x91','\x51','\xab',
        '\x90','\x01','\xab',
        '\x91','\x51','\xab',
        '\x91','\x91','\xab',
        '\x91','\x91','\xab',
        '\x91','\x91','\xab',
        '\x91','\x91','\xab',
        '\x91','\x51','\xab',
        '\x51','\x41','\xab',
        '\x41','\x41','\xab',
        '\x41','\x41','\xab',
        '\x41','\x55','\xab',
        '\x55','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab'};

char bspot[]={
        '\x18','\x00','\x14','\x00',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab',
        '\xaa','\xaa','\xab'};

char wptr[]={
       '\x18','\x00','\x14','\x00',
       '\x3f','\xff','\xff',
       '\x3d','\x55','\x5f',
       '\x3d','\x00','\x1f',
       '\x3d','\x15','\x1f',
       '\x3d','\x00','\x1f',
       '\x3d','\x15','\x1f',
       '\x3d','\x1d','\x1f',
       '\x3d','\x1d','\x1f',
       '\x3d','\x1d','\x1f',
       '\x3d','\x1d','\x1f',
       '\x3d','\x15','\x1f',
       '\x35','\x14','\x1f',
       '\x34','\x14','\x1f',
       '\x34','\x14','\x1f',
       '\x34','\x15','\x5f',
       '\x35','\x5f','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff'};

char wspot[]={
       '\x18','\x00','\x14','\x00',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff',
       '\x3f','\xff','\xff'};

int cursor[32]    ;
char far *cptr=(char far *)cursor   ;

void makemickey(int cursortype)
{
    /* usage:  load a new cursor into the cursor buffer        */
    /* or   :  switch between different cursor shapes          */
    /* accumulate color value and position to cursor array     */
    /* each pixel value in the CGA MED RES is stored in 2 bits */
    /* and the mouse cursor mask is stored in a word value     */
    /* the pixel map is defined by a left shift of the pixel   */
    /* attribute to the appropriate position in the mask.      */


    int shifter,i,j,k=16;

               for(i=0;i<16;i++){
                   for(j=0;j<8;j++){
                       switch(j){
                           case 0: shifter=14;break;
                           case 1: shifter=12;break;
                           case 2: shifter=10;break;
                           case 3: shifter= 8;break;
                           case 4: shifter= 6;break;
                           case 5: shifter= 4;break;
                           case 6: shifter= 2;break;
                           case 7: shifter= 0;break;
                        }
                    /* reference to additional sprites can be added here */
                       switch(cursortype)
                       {
                        default:

                     cursor[k]=(cursor[k] | arrow[i][j]<<shifter);
                     cursor[i]=(cursor[i] | zorro[i][j]<<shifter);
                       }
                    }
                    k++;
                }

}

#undef WHITE
#undef RED
#undef CYAN
#undef BLACK

#define WHITE 3
#define RED   2
#define CYAN  1
#define BLACK 0

int soundbox[22][7]=
    {

/*  x1   y1  x2   y2   row  col  record # */
    0,   0,  79,  23,  2,   2,   0,
    80,  0,  159, 23,  2,   12,  0,
    160, 0,  239, 23,  2,   22,  0,
    240, 0,  319, 23,  2,   32,  0,

    0,   24, 79,  47,  5,   2,   0,
    80,  24, 159, 47,  5,   12,  0,
    160, 24, 239, 47,  5,   22,  0,
    240, 24, 319, 47,  5,   32,  0,

    0,   48, 79,  71,  8,   2,   0,
    80,  48, 159, 71,  8,   12,  0,
    160, 48, 239, 71,  8,   22,  0,
    240, 48, 319, 71,  8,   32,  0,

    0,   72, 79,  95,  11,  2,   0,
    80,  72, 159, 95,  11,  12,  0,
    160, 72, 239, 95,  11,  22,  0,
    240, 72, 319, 95,  11,  32,  0,

    0,   96, 79,  119, 14,  2,   0,
    80,  96, 159, 119, 14,  12,  0,
    160, 96, 239, 119, 14,  22,  0,
    240, 96, 319, 119, 14,  32,  0,

    0,  120, 159, 199, 17,  2,   0, /* turn the page             */
    160,120, 319, 199, 17,  22,  0  /* return to previous screen */

};



/* get a series of files of a certain type.. in this case, type .SND */
int wildcounter=9;
char wildfiles[200][15];
int soundindex =0;

int getfiles(char *filetype)
{

    int i;
    char buffer[15];
    struct find_t wild_card;

    memset(wildfiles,0,sizeof(wildfiles));

    wildcounter =9;

    for(i=0;i!=wildcounter;i++)
        strcpy(wildfiles[i],internal_tunes[i]);

    sprintf(buffer,"*.%s",filetype);

    if(_dos_findfirst(buffer,_A_NORMAL,&wild_card)==0)
    {

        strcpy(wildfiles[wildcounter],wild_card.name);
        wildcounter++;

    while(_dos_findnext(&wild_card)==0){
           strcpy(wildfiles[wildcounter],wild_card.name);
           wildcounter++;
           }
        }

return wildcounter;
}


int mousex, mousey;

int internal_play(int *musical_script)
{
  int frequency=0, duration=1, done=0,true=1;
  char c;
  union REGS inregs, outregs;

  int temp,status=-1;
  whitekey=TRUE;

  /* pause while a button is released */

  do{
      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      }
      while(outregs.x.bx!=0);

  while(done !=true)
     {
      /* quit if a mouse button is pressed but   */
      /* first replace the divot if we got one   */

      if(status!=-1)
      {
            if(whitekey==FALSE)
            {
            mousex = BLACKS[status][0];
            mousey = BLACKS[0][1]+16  ;
            _putimage(mousex,mousey,bspot,_GPSET);
            }
            else
            {
            mousex = WHITES[status][0];
            mousey = BLACKS[0][3]+14  ;
            _putimage(mousex,mousey,wspot,_GPSET);
            }
         }

      if(EatKeys() == 27)
        return -1;

      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      if(outregs.x.bx!=0)
      {
        /* pause until a button is released */

                   do{
                      inregs.x.ax=3;
                      int86(0x33,&inregs,&outregs);
                      }
                    while(outregs.x.bx!=0);
        return -1;
        }
      temp=musical_script[frequency];

      status=keyplay(temp);

      if(status!=-1)
      {
          if(whitekey==FALSE)
            {
            mousex = BLACKS[status][0];
            mousey = BLACKS[0][1]+16  ;
            _putimage(mousex,mousey,bptr,_GPSET);
            }
            else
            {
            mousex = WHITES[status][0];
            mousey = BLACKS[0][3]+14  ;
            _putimage(mousex,mousey,wptr,_GPSET);
            }
       }
      sound(temp,musical_script[duration]);
      frequency+=2;duration+=2;
      if (musical_script[frequency] == -1)done=true;
      }
      if(status!=-1)
      {
          if(whitekey==FALSE)
            {
            mousex = BLACKS[status][0];
            mousey = BLACKS[0][1]+16  ;
            _putimage(mousex,mousey,bspot,_GPSET);
            }
            else
            {
            mousex = WHITES[status][0];
            mousey = BLACKS[0][3]+14  ;
            _putimage(mousex,mousey,wspot,_GPSET);
            }
         }
      return 0;
}

int playit_straight(int *musical_script)
{
  int frequency=0, duration=1, done=0,true=1;
  union REGS inregs, outregs;

  /* pause while a button is released */

  do{
      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      }
      while(outregs.x.bx!=0);

  while(done !=true)
     {
      /* quit if a mouse button is pressed but   */

      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      if(outregs.x.bx!=0)
      {
        /* pause until a button is released */

                   do{
                      inregs.x.ax=3;
                      int86(0x33,&inregs,&outregs);
                      }
                    while(outregs.x.bx!=0);
        return -1;
        }
      if (EatKeys())
        break;
      sound(musical_script[frequency],musical_script[duration]);
      frequency+=2;duration+=2;
      if (musical_script[frequency] == -1)done=true;
      }
      return 0;
}




int external_play(char *sndfile)
{

  union REGS inregs, outregs;

  FILE *fp;
  int frequency, duration;

  int status=-1;
  whitekey=TRUE;

  /* pause while a button is released */

  do{
      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      }
      while(outregs.x.bx!=0);

  if((fp=fopen(sndfile,"rb"))==NULL)return -2;

  while((frequency=getw(fp))!=-1)
     {
      /* first replace the divot if we got one   */

      if(status!=-1)
      {
          if(whitekey==FALSE)
            {
            mousex = BLACKS[status][0];
            mousey = BLACKS[0][1]+16  ;
            _putimage(mousex,mousey,bspot,_GPSET);
            }
            else
            {
            mousex = WHITES[status][0];
            mousey = BLACKS[0][3]+14  ;
            _putimage(mousex,mousey,wspot,_GPSET);
            }
         }

      if(EatKeys() == 27) {
            fclose(fp);
            return -1;
       }

      /* quit if a mouse button is pressed */
      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      if(outregs.x.bx!=0)
                  {

                  /* pause until a button is released */

                   do{
                      inregs.x.ax=3;
                      int86(0x33,&inregs,&outregs);
                      }
                    while(outregs.x.bx!=0);

                    fclose(fp);
                    return -1;
                    }
      status=keyplay(frequency);

      if(status!=-1)
      {
          if(whitekey==FALSE)
            {
            mousex = BLACKS[status][0];
            mousey = BLACKS[0][1]+16  ;
            _putimage(mousex,mousey,bptr,_GPSET);
            }
            else
            {
            mousex = WHITES[status][0];
            mousey = BLACKS[0][3]+14  ;
            _putimage(mousex,mousey,wptr,_GPSET);
            }
       }

      duration=fgetc(fp);
      sound(frequency,duration);
      }
      fclose(fp);
      if(status!=-1)
      {
          if(whitekey==FALSE)
            {
            mousex = BLACKS[status][0];
            mousey = BLACKS[0][1]+16  ;
            _putimage(mousex,mousey,bspot,_GPSET);
            }
            else
            {
            mousex = WHITES[status][0];
            mousey = BLACKS[0][3]+14  ;
            _putimage(mousex,mousey,wspot,_GPSET);
            }
         }
      return 0;
}

int play(int selection)
{

    switch(selection)
    {
        case 0:  internal_play(danube);break;
        case 1:  internal_play(dvorak);break;
        case 2:  internal_play(guonod);break;
        case 3:  internal_play(mexico);break;
        case 4:  internal_play(mozart);break;
        case 5:  internal_play(stars); break;
        case 6:  internal_play(sam);   break;
        case 7:  internal_play(bug);   break;
        case 8:  internal_play(weasel);break;

        default : external_play(wildfiles[selection]);
    }

}



int getsoundfile(int x, int y)
{

    /* this function checks each of the hot zones in the files    */
    /* listing and returns the number of the current choice       */

    int currentchoice = -1;
    int i;

         /* check the flip zone and the quit without selection zone */
        if(x >= soundbox[20][0] && y >= soundbox[20][1] &&
           x <= soundbox[20][2] && y <= soundbox[20][3])
                   return 20;
        if(x >= soundbox[21][0] && y >= soundbox[21][1] &&
           x <= soundbox[21][2] && y <= soundbox[21][3])
                   return 21;

    for(i=0;i!=20;i++)
    {
        /* if its in range return the hot box number */
        if(x >= soundbox[i][0] && y >= soundbox[i][1] &&
           x <= soundbox[i][2] && y <= soundbox[i][3])return i;
     }

   /* if we haven't hit a hot spot yet then we're not in range */
   return currentchoice;
}


/* Character Arrays of .PCX format Run Length Full Screen CGA Graphics */
/* BYTE COUNT Descriptor Integers precede the Character Arrays.*/

/* .PCX Input File Name was MICKTIT.PCX */
extern int MICKTIT_SIZE;
extern unsigned char far MICKTIT[];

/* .PCX Input File Name was KEYBOARD.PCX */
extern int KEYBOARD_SIZE;
unsigned char far KEYBOARD[];

/* .PCX Input File Name was DIRECTOR.PCX */
extern int DIRECTOR_SIZE;
extern unsigned char far DIRECTOR[];

extern int WORDS_SIZE;
extern unsigned char far WORDS[];

#define SCREENSIZE 16385
unsigned char far *crt    =(unsigned char *) 0xB8000000l;
unsigned char far *inleaf =(unsigned char *)0xB8000000l+0x2000;
unsigned char far *micktitlebuffer;
unsigned char far *keyboardbuffer;
unsigned char far *directorbuffer;
unsigned char far *wordsbuffer;
unsigned char far *imagebuf;

#define   CGALINE    80

int memoryload(unsigned char far *in, unsigned char far *out, int sz)
{
    unsigned int byteoff=0,packet,width=0;
    unsigned char byte,bytecount;
    int wordcount=0;

    do{ bytecount=1;                          /* start with a seed count */
        byte=in[wordcount];
        wordcount++;
                                              /* check to see if its raw */
        if(0xC0 == (0xC0 &byte)){             /* if its not, run encoded */
                    bytecount= 0x3f &byte;
                    byte=in[wordcount];
                    wordcount++;
                    }
        for(packet=0;packet<bytecount;packet++){
                     out[byteoff]=byte;
                     byteoff++;
                     }
        }while(wordcount<sz);
        return(0);
}

int cload(unsigned char far *array)
{
 unsigned int y,inset=0, offset=0;

    for(y=0;y<200;){
        memcpy(crt+inset,array+offset,CGALINE);
        offset+=CGALINE;
        y++;
        memcpy(inleaf+inset,array+offset,CGALINE);
        offset+=CGALINE;
        inset+=CGALINE;
        y++;
        }
     return(0);

}

void initraw()
{
    micktitlebuffer = _fmalloc(SCREENSIZE);
    keyboardbuffer = _fmalloc(SCREENSIZE);
    directorbuffer = _fmalloc(SCREENSIZE);
    wordsbuffer    = _fmalloc(SCREENSIZE);
    imagebuf       = _fmalloc(2048);
    /* arbitrary*/

    memoryload(MICKTIT,micktitlebuffer,MICKTIT_SIZE);
    memoryload(KEYBOARD,keyboardbuffer,KEYBOARD_SIZE);
    memoryload(DIRECTOR,directorbuffer,DIRECTOR_SIZE);
    memoryload(WORDS,wordsbuffer,WORDS_SIZE);
}

void freeraw()
{
    _ffree(keyboardbuffer);
    _ffree(micktitlebuffer);
    _ffree(directorbuffer);
    _ffree(wordsbuffer);
    _ffree(imagebuf);
}

void drawscreen(int screentype)
{

 int x;
 char scratchbuf[15];
 char *wordptr;
 union REGS inregs,outregs;


 switch(screentype)
 {
    /* falls through here the first time */
    case 0:    initraw();
               getfiles("SND");
               cload(micktitlebuffer);
               playit_straight(ENTERTAN);

    case 1:    cload(keyboardbuffer);
               break;


    case 2:    /* load the screen */
               cload(directorbuffer);
    case 3:

    _setcolor(BLACK);

 for(x=0;x!=20;x++)
 {
   soundbox[x][6]=soundindex;   /* set the index pointer to the wildfiles */

   if(screentype == 3);
   _rectangle(_GFILLINTERIOR,soundbox[x][0]+1,soundbox[x][1]+1,
                             soundbox[x][2]-1,soundbox[x][3]-1);
   
   _settextposition(soundbox[x][4],soundbox[x][5]);
   strcpy(scratchbuf,wildfiles[soundindex]);
   if(soundindex>8)
      {
      wordptr=strtok(scratchbuf,".");
      printf("%s",wordptr);
      }
   else
      printf("%s",scratchbuf);
      soundindex++;
      /* wrap around if we are at the end */
      if(soundindex==wildcounter)soundindex=0;
      }

    /* pause while a button is released */

  do{
      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      }
      while(outregs.x.bx!=0);

   }


}


void cursoron(void)
{
         union REGS inregs, outregs;
         /*                                                 */
         /*  set mouse cursor location, then turn on cursor */
         /*                                                 */
         inregs.x.ax=4;
         inregs.x.cx=mousex*2;
         inregs.x.dx=mousey;
         int86(0x33,&inregs,&outregs);

         inregs.x.ax=1;
         int86(0x33,&inregs,&outregs);
}

void cursoroff(void)
{
        union REGS inregs, outregs;
        inregs.x.ax=2;
        int86(0x33,&inregs,&outregs);

}

main(int argc, char **argv)
{

  int x,y,m2;
  char c;

  int frequency,duration = 2,songchoice;
  int newchoice, oldchoice;
  int iBackGround=BLUE+INTENSE,
      iPalette=GRY;

  union REGS inregs, outregs;
  struct SREGS segregs;
  long address;
  unsigned char first_byte;

/*                                                               */
/*  check for CGA compatible video adapter on initial video mode.*/
/*                                                               */


    int86(0x11,&inregs,&outregs); /* get equipment list from the bios */
    /* get display type (bits 4 and 5 of ax) */

    if ((outregs.x.ax & 0x30) == 0x30)
    {
        printf("Sorry... CGA or Compatible Video Adapter Required.\n");
        exit(0);
     }


/*                                                             */
/*  check for microsoft compatible mouse driver                */
/*                                                             */

    inregs.x.ax = 0x3533                                       ;
    intdosx ( &inregs, &outregs, &segregs )                    ;
    address = (((long) segregs.es) << 16) + (long) outregs.x.bx;
    first_byte = * (long far *) address                        ;
    if ((address == 0) || (first_byte == 0xcf))
    {
      printf("Sorry... Microsoft Compatible mouse Driver not found!\n");
      exit(0);
      }
/*                                                             */
/*  initilize and check to see if the mouse is responding      */
/*                                                             */

    inregs.x.ax=0               ;
    int86(0x33,&inregs,&outregs);
    if(outregs.x.ax==0)
    {
       printf("Sorry... Microsoft Compatible Mouse not responding!\n");
       exit(0);
       }

/*                                                      */
/* set the video mode                                   */
/*                                                      */
   // microsoft's - required to use getimage, putimage, etc.
   _setvideomode(_MRESNOCOLOR);

   // my own - for some reason microsoft's were not working
   // with palettes.
   SetCrtMode(5);

   SetScreenColor(iBackGround,iPalette);

 /*                                                      */
 /*  set mouse sensitivity                               */
 /*                                                      */
 inregs.x.ax = 15;
 inregs.x.bx = 15;
 inregs.x.cx = 4 ;
 inregs.x.dx = 8 ;
 int86(0x33,&inregs,&outregs);


/*                                                             */
/*  load the cursor                                            */
/*                                                             */

    makemickey(1);

    segregs.es=FP_SEG(cptr);
    inregs.x.ax=9                         ;
    inregs.x.bx=6                         ;
    inregs.x.cx=0                         ;
    inregs.x.dx=FP_OFF(cptr);
    int86x(0x33,&inregs,&outregs,&segregs);

    drawscreen(0);

 /*                                                 */
 /*  set mouse cursor location, then turn on cursor */
 /*                                                 */
 mousex = 160;
 mousey = 160;
 cursoron();

 /*                      */
 /*  m a i n    l o o p  */
 /*                      */

     do
     {

     m2=0;
     /* wait here for any button press */
     /* or allowable keypresses        */

     while(!(m2))
     {

      inregs.x.ax=3;
      int86(0x33,&inregs,&outregs);
      m2 = outregs.x.bx   ;
      x  = outregs.x.cx/2 ;
      y  = outregs.x.dx   ; /* get mouse location and button status */

      c = toupper(EatKeys());
     if(c)
     {
        mousex = x;
        mousey = y;

        switch(c)
        {

             case '2': mousex = BLACKS[0][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case '3': mousex = BLACKS[1][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case '5': mousex = BLACKS[2][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case '6': mousex = BLACKS[3][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case '7': mousex = BLACKS[4][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;

             case '9':
             case 'S': mousex = BLACKS[5][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case '0':
             case 'D': mousex = BLACKS[6][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case '=':
             case '+':
             case 'G': mousex = BLACKS[7][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case 'H': mousex = BLACKS[8][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;
             case 'J': mousex = BLACKS[9][0]+5 ;
                       mousey = BLACKS[0][1]+16; m2=1; break;

            /* 2 octaves available on keys */

            case 'Q': mousex = WHITES[0][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'W': mousex = WHITES[1][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'E': mousex = WHITES[2][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'R': mousex = WHITES[3][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'T': mousex = WHITES[4][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'Y': mousex = WHITES[5][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'U': mousex = WHITES[6][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;

            case 'I':
            case 'Z': /* c */
                      mousex = WHITES[7][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'O':
            case 'X': mousex = WHITES[8][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'P':
            case 'C': mousex = WHITES[9][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case '{':
            case '[':
            case 'V': mousex = WHITES[10][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case '}':
            case ']':
            case 'B': mousex = WHITES[11][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'N': mousex = WHITES[12][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case 'M': mousex = WHITES[13][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
            case '<':
            case ',':
                      /* c */
                      mousex = WHITES[14][0]+8  ;
                      mousey = BLACKS[0][3]+14 ; m2=1;break;
        }
        x=mousex;
        y=mousey;
        cursoroff();
        cursoron();
        }

     }

      /* don't wait for a button release */
      /* get our menu status and note info based on location */
      frequency=getfrequency(x,y);

      /* if we are over the key board play the note */
      switch(frequency)
      {
        case FLIP   :
        case SILENCE:
        case QUIT   : break;
        default     : sound(frequency,duration);
        }

     if(frequency==FLIP)    /* song selection menu */
     {

        /* turn off cursor */
        inregs.x.ax=2;
        int86(0x33,&inregs,&outregs);

        /* draw the screen */
        drawscreen(2);
        oldchoice = -1;
        newchoice = -1;

      NEXTPAGE:;   /* short jump back to here if only a page flip */


        /* turn on the cursor */

        inregs.x.ax=1;
        int86(0x33,&inregs,&outregs);

        songchoice=-1;

        while(songchoice==-1)
         {
         m2=0;
         /* wait here for a button press */
         while(!(m2))
         {
         inregs.x.ax=3;
         int86(0x33,&inregs,&outregs);
         m2 = outregs.x.bx   ;
         x  = outregs.x.cx/2 ;
         y  = outregs.x.dx   ; /* get mouse location and button status */
         newchoice=getsoundfile(x,y);

         if(newchoice!=oldchoice)
         {
              /* turn off cursor */
                 inregs.x.ax=2;
                 int86(0x33,&inregs,&outregs);

              if(oldchoice > -1 && oldchoice <20)
              {
               _putimage(soundbox[oldchoice][0]+1,
                         soundbox[oldchoice][1]+1,imagebuf,_GPSET);
               }
               if(newchoice > -1 && newchoice < 20)
               {
               _getimage(soundbox[newchoice][0]+1,
                         soundbox[newchoice][1]+1,
                         soundbox[newchoice][2]-1,
                         soundbox[newchoice][3]-1,imagebuf);
               _putimage(soundbox[newchoice][0]+1,
                         soundbox[newchoice][1]+1,imagebuf,_GPRESET);

               }
              /* turn on the cursor */
              inregs.x.ax=1;
              int86(0x33,&inregs,&outregs);
          }
         oldchoice = newchoice;
         }

        songchoice=getsoundfile(x,y);
        }
        mousex=x;
        mousey=y;
        cursoroff();
        /* turn off cursor */
        /* draw the screen */

        if(songchoice!=20)
           drawscreen(1);
        else
            {
             drawscreen(3);
             goto NEXTPAGE; /* short jump to flip the page */
            }

        if(songchoice<20)play(soundbox[songchoice][6]);

         /*                                                 */
         /*  set mouse cursor location, then turn on cursor */
         /*                                                 */
         cursoron();
        }

    }while(frequency!=QUIT);


 /*  button down inside the quit box */
 inregs.x.ax =2;
 int86(0x33,&inregs,&outregs);      /* turn off mouse screen     */

 _setvideomode(6);
 cload(wordsbuffer);

  playit_straight(MAPLE);

 _setvideomode(3);                  /* reset video mode and exit */
 freeraw();
 exit(0);

}


