/****************************************************************************
 *
 *	Program Name : SORTING.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program sorts in ascending order, the minterms in a given array.
 *
 *	Returns pointer to the sorted array of minterms
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

unsigned char   *sorting(b)
unsigned char 	*b;

{
   unsigned short  mb, i;
   unsigned char   nspm, *hold1, *hold2, *temp, j;
	     int   test;


   nspm = *(b+3);                             /* no. of bytes/minterm */
   mb = *(b+2)<<8 | *(b+1);                   /* no. of minterms in b */

   hold1 = (unsigned char *)  malloc(nspm);   /* temporary storage */
   if (hold1 == 0)
      {
	 printf("Out of memory -- SORTING, *hold1\n");
	 printf("Program Terminated - 1");
	 exit(0);
      }

   hold2 = (unsigned char *)  malloc(nspm);   /* temporary storage */
   if (hold2 == 0)
      {
	 printf("Out of memory -- SORTING, *hold2\n");
	 printf("Program Terminated - 2");
	 exit(0);
      }

   temp = (unsigned char *)  malloc(nspm);   /* temporary storage */
   if (temp == 0)
      {
	 printf("Out of memory -- SORTING, *temp \n");
	 printf("Program Terminated - 3");
	 exit(0);
      }

   while (mb-- > 1)                      /* bubble sort algorithm */
      {
	 for (i=0; i<mb; i++)            /* do for decreasing order of mb */
	    {
	       for (j=nspm; j>0; j--)    /* rearrange for nspm>1 */
		  {
		     *(hold1+nspm-j) = *(b+4+nspm*i+j-1);
		     *(hold2+nspm-j) = *(b+4+nspm*(i+1)+j-1);
		  }

	       test = memcmp(hold1, hold2, nspm);
	       if (test > 0)                            /* hold1 > hold2 */
		  {                                     /* swap minterms */
		     memcpy(temp, (b+4+nspm*i), nspm);
		     memcpy((b+4+nspm*i), (b+4+nspm*(i+1)), nspm);
		     memcpy((b+4+nspm*(i+1)), temp, nspm);
		  }
	    }
      }
   free(hold1);                        /* free pointers */
   free(hold2);
   free(temp);

   return(b);                          /* return sorted array */
}


