#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <graphics.h>

extern void white(void);
extern void normal(void);
extern void read(char filename[]);
void run4(void);
extern void readdata(char ext[]);
extern void readinst(char filename[]);
extern int sort_function( const void *a, const void *b);


extern void stroop(void) {

 char choice;

 for(;;) {
  normal();
  _setcursortype(_NOCURSOR);
  window(18,6,62,19);
  textbackground(LIGHTGRAY);
  clrscr();
  window(20,7,60,18);
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
   gotoxy(15,2);
  cprintf(" STROOP MENU:");
  gotoxy(5,4);
  cprintf("1. Run the experiment");
  gotoxy(5,5);
  cprintf("2. Show individual results ");
  gotoxy(5,6);
  cprintf("3. Show SPSS ready file ");
  gotoxy(5,7);
  cprintf("4. Details of design");
  gotoxy(5,8);
  cprintf("5. References for further reading");
  gotoxy(5,9);
  cprintf("6. Return to main menu");
  gotoxy(2,12);
  cprintf("Enter choice (1-6)");

  Repeat:
  choice=getch();
  switch (choice) {

   case '1': run4();break;
   case '2': readdata(".str");break;
   case '3': read("Stroop.cat");break;
   case '4': read("STRDets.txt");break;
   case '5': read("STRrefs.txt");break;
   case '6': return;
   default: goto Repeat;
  }
 }
}





 /*RUN4 (): Runs the experiment */
 void run4(void)
 {
  int gdriver = DETECT, gmode, errorcode;
  clock_t start, end;
  char *strng;
  float value,temp;
  int dec, sign, finish;
  int ndig = 1;
  int b,correct;
  int size, set1, set2,count,a,i,sexno, x, y, comp,coord,type;
  int rnumber, rnum[50], rnume[300];
  int RT,rn;
  int cp, cn, wp, wn, col;
  float cprt, cnrt, wprt, wnrt, wpmrt, wnmrt, cpmrt, cnmrt;
  char init[5], sex;
  char sexstr[2];
  char filename[20],filetemp[20],fileinfo[20];
  char ch_ins, quit, cha, resp,let;
  char ch, string[80];
  char setstr[80], colnam[20];
  int concol[300][3], colnum;
  FILE *fpword,*fpins,*fpmaster,*fp,*fpset;
  struct find_t ffblk;

  normal();

  /* record personal data */
   textcolor(WHITE);
   for(;;) {

    do{
     clrscr();
     printf("\nPlease, enter up to four initials\n(press 'enter' when finished): ");
     gets(init);
    } while (strlen(init)>4);

    do {
     clrscr();
     printf("\nMale or female? (just press 'm' or 'f'): ");
     sex=getche();
     delay(300);
    } while (tolower(sex)!='m'&&tolower(sex)!='f');

    sexstr[0]=sex;
    sexstr[1]=0;



    do {
     clrscr();
     printf("\nInitials: %s\nSex: %c\n",init, sex);
     printf("\nAre these correct? (press 'y' or 'n')");
     resp=getche();
    } while (tolower(resp)!='y' && tolower(resp)!='n');

    if (tolower(resp)=='y') break;
    clrscr();
   }


   /*CHECK IF THE FILE EXISTS, ADD NUMBER AND SAVE*/

   value=0;
   ndig=1;
   strcpy(filename,init);
   strcat(filename,sexstr);

   for(;;){
    strcpy(filetemp,filename);
    if(value>9) ndig=2;
    strng = ecvt(value, ndig, &dec, &sign);
    strcat(filetemp,strng);
    strcpy(fileinfo,filetemp);
    strcat(filetemp,".STR");
    if(ch=='q') exit(0);
    if(!_dos_findfirst(filetemp,_A_NORMAL,&ffblk)) value++;
    else break;
   }


   if((fp=fopen(filetemp,"w"))==NULL) {
    printf("Error: Cannot open %s file",filename);
    exit(1);
   }

   fprintf(fp,"Initials: %s \nSex: %c\n",init,sex);
   fclose(fp);
   clrscr();


    /* instructions */

   readinst("strins.txt");
   textcolor(WHITE);
   clrscr();
   printf("\a");
   delay(1000);
   textcolor(WHITE);


   if((fpset=fopen("strsys.txt","r"))==NULL) {
    printf("Cannot open 'stroop' system file: strsys.txt file");
    exit(1);
   }

   for(i=0;;i++) {
    ch=fgetc(fpset);
    if(isdigit(ch)) setstr[i]=ch;
    if(ch=='\n') {
     setstr[i]=0;
     set1=atoi(setstr);
     break;
    }
   }
   for(i=0;;i++) {
    ch=fgetc(fpset);
    if(isdigit(ch)) setstr[i]=ch;
    else {
     setstr[i]=0;
     set2=atoi(setstr);
     fclose(fpset);
     break;
    }
   }



   /*get conditions and colors and put them to an array*/





   if((fpword=fopen("strword.txt","r"))==NULL) {
    printf("Cannot open strword.txt file");
    exit(1);
   }
   let=0;
   finish=1;
   for(a=0;finish&&a<=300;a++) {
    for(;;) {
     if(!feof(fpword)) {
      ch=fgetc(fpword);
      if(let==2) {
       concol[a][2]=0;
       if(ch!='\n') {
	do{
	 ch=fgetc(fpword);
	} while(ch!='\n');
       }
       let=0;
       break;
      }
      if(let==0&&!isdigit(ch)) {
       finish=0;
       break;
      }
      if(isdigit(ch)){
       concol[a][let]=ch-48;
       let++;
       if(concol[a][1]==3) concol[a][1]=14;
       if(concol[a][1]==0) concol[a][1]=15;
      }
     }
     else finish=0;
    }
   }
   fclose(fpword);



  /* PRACTICE TRIALS*/

   /*present Practice trials*/


   randomize();
   for(a=0;a<set1;) {
    comp=0;
    rnumber=random(set1);
    for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
    if(comp==0) {
     rnum[a]=rnumber;
     a++;
    }
   }





  /*presentations*/

    /* initialize graphics and local variables */
   initgraph(&gdriver, &gmode, "");

   /* read result of initialization */
   errorcode = graphresult();
   if (errorcode != grOk)   {
    printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:");
    getch();
    exit(1); /* terminate with an error code */
   }

   setbkcolor(LIGHTGRAY);

   randomize();

   for(count=0;count<set1;count++) {



     /*present stimuli*/

    if(concol[rnum[count]][0]) {

     do{
      colnum=random(6);
      if(colnum==0) colnum=15;
      if(colnum==3) colnum=14;
     } while(colnum==concol[rnum[count]][1]);

     switch (colnum) {
      case 1: strcpy(colnam,"BLUE");break;
      case 2: strcpy(colnam,"GREEN");break;
      case 4: strcpy(colnam,"RED");break;
      case 5: strcpy(colnam,"PURPLE");break;
      case 14: strcpy(colnam,"YELLOW"); break;
      case 15: strcpy(colnam,"WHITE");break;
     }

     setcolor(concol[rnum[count]][1]);
     settextstyle(DEFAULT_FONT,HORIZ_DIR,2);
     settextjustify(250,200);
     outtextxy(250, 210, colnam);


    }

    else {

     setfillstyle(SOLID_FILL, concol[rnum[count]][1]);
     bar(230, 200, 350, 250);



    }

    while(kbhit()) getch();


    do{
     ch = getch();
    } while (ch!='\r');
    sound(500);
    delay(20);
    nosound();

    setcolor(BLUE);
    settextstyle(DEFAULT_FONT,HORIZ_DIR,1);
    outtextxy(180,400,"ENTER SUBJECT'S RESPONSE (1-6).");


    do {
     ch=getch();
    } while(!isdigit(ch)||ch-48>6);

    sound(500);
    delay(20);
    nosound();

    if(ch=='3') col=14;
    if(ch=='6') col=15;
    if(ch!='3' && ch!='6') col=ch-48;

    if(concol[rnum[count]][1]==col) type=1;
    else type=0;


    if(!type) {

     sound(50);
     delay(400);
     nosound();
     setcolor(RED);
     settextstyle(DEFAULT_FONT,HORIZ_DIR,3);
     outtextxy(240,450,"ERROR!");
     getch();

    }

    cleardevice();
    delay(400);

   }

   closegraph();

     /* Pause between sessions*/
   gotoxy(1,25);
   textcolor(BLACK);
   cprintf("Press any key to go on to experimental trials...");
   window(1,1,80,24);
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   clrscr();

   if((fpins=fopen("strins2.txt","r"))==NULL) {
    printf("Cannot open 'STRINS2.TXT' file!");
    normal();
    exit(1);
   }

   while((ch_ins=fgetc(fpins))!=EOF) putchar(ch_ins);
   fclose(fpins);
   while(kbhit()) getch();
   getch();
   window(1,1,80,25);
   clrscr();
   printf("\a");
   delay(1000);





     /* EXPERIMENTAL TRIALS*/


  /* create random numbers */

   randomize();
   for(a=0;a<set2;) {
    comp=0;
    rnumber=random(set2);
    for(i=0;i<a;i++) if(rnumber==rnume[i]) comp++;
    if(comp==0) {
     rnume[a]=rnumber;
     a++;
    }
   }

   for (a=0;a<set2;a++)  rnume[a]=rnume[a]+set1;



   /*presentations*/

   cp=0;
   cprt=0;
   cn=0;
   cnrt=0;
   wp=0;
   wprt=0;
   wn=0;
   wnrt=0;



  /*presentations*/

    /* initialize graphics and local variables */
   initgraph(&gdriver, &gmode, "");

   /* read result of initialization */
   errorcode = graphresult();
   if (errorcode != grOk)   {
    printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:");
    getch();
    exit(1); /* terminate with an error code */
   }

   setbkcolor(LIGHTGRAY);

   randomize();

   for(count=0;count<set2;count++) {



     /*present stimuli*/

    if(concol[rnume[count]][0]) {

     do{
      colnum=random(6);
      if(colnum==0) colnum=15;
      if(colnum==3) colnum=14;
     } while(colnum==concol[rnume[count]][1]);

     switch (colnum) {
      case 1: strcpy(colnam,"BLUE");break;
      case 2: strcpy(colnam,"GREEN");break;
      case 4: strcpy(colnam,"RED");break;
      case 5: strcpy(colnam,"PURPLE");break;
      case 14: strcpy(colnam,"YELLOW"); break;
      case 15: strcpy(colnam,"WHITE");break;
     }

     setcolor(concol[rnume[count]][1]);
     settextstyle(DEFAULT_FONT,HORIZ_DIR,2);
     settextjustify(250,200);
     outtextxy(250, 210, colnam);


    }

    else {

     setfillstyle(SOLID_FILL, concol[rnume[count]][1]);
     bar(230, 200, 350, 250);



    }

    while(kbhit()) getch();


    start = clock();
    do {
     ch=getch();
    } while (ch!='\r');
    end = clock();
    RT=(end-start)/CLK_TCK*1000;

    sound(500);
    delay(20);
    nosound();

    if(RT>3000) RT=3000;


    setcolor(BLUE);
    settextstyle(DEFAULT_FONT,HORIZ_DIR,1);
    outtextxy(180,400,"ENTER SUBJECT'S RESPONSE (1-6).");


    do {
     ch=getch();
    } while(!isdigit(ch)||ch-48>6);

    sound(500);
    delay(20);
    nosound();

    col=ch-48;
    if(ch=='3') col=14;
    if(ch=='6') col=15;


    if(concol[rnume[count]][1]==col) type=1;
    else type=0;

    if(type) {
     if(concol[rnume[count]][0]) {
      wp++;
      wprt=wprt+RT;
     }
     else {
      cp++;
      cprt=cprt+RT;
     }

    }
    else {
     if(concol[rnume[count]][0]) {
      wn++;
      wnrt=wnrt+RT;
     }
     else {
      cn++;
      cnrt=cnrt+RT;
     }
    }

    /*pause 5 times*/
    if(count>10 && count%(set2/5)==0) {
     cleardevice();
     setcolor(1);
     settextstyle(DEFAULT_FONT,HORIZ_DIR,2);
     outtextxy(200, 200, "Have a short rest");
     settextstyle(DEFAULT_FONT,HORIZ_DIR,1);
     outtextxy(200, 450, "Experimenter: Press any key to continue...");
     getch();
     cleardevice();
     printf("\a");
     delay(1000);
    }

    cleardevice();
    delay(400);

   }

   closegraph();





   normal();
    /*calculate averages for all conditions*/

   if(wp) wpmrt=wprt/wp;
   else wpmrt=0;
   if(wn) wnmrt=wnrt/wn;
   else wnmrt=0;
   if(cp) cpmrt=cprt/cp;
   else cpmrt=0;
   if(cn) cnmrt=cnrt/cn;
   else cnmrt=0;
   if((fp=fopen(filetemp,"a"))==NULL) {
   printf("Cannot open '%s' file!",filetemp);
   exit(1);
  }
  fprintf(fp,"\nCOLOUR NAMES:");
  fprintf(fp,"\nNumber of hits: %d",wp);
  fprintf(fp,"\nMean RT for hits: %.0f ms. ", wpmrt);
  fprintf(fp,"\nNumber of misses: %d",wn);
  fprintf(fp,"\nMean RT for misses: %.0f ms.",wnmrt);
  fprintf(fp,"\n\nCOLOUR PATCHES:");
  fprintf(fp,"\nNumber of hits: %d",cp);
  fprintf(fp,"\nMean RT for hits: %.0f ms. ", cpmrt);
  fprintf(fp,"\nNumber of misses: %d",cn);
  fprintf(fp,"\nMean RT for misses: %.0f ms.",cnmrt);
  fclose(fp);

       /* Update master catalogue */
  if((fpmaster=fopen("stroop.cat","a"))==NULL) {
   printf("Error: Cannot open STROOP.CAT file\n");
   exit(1);
  }
  if (tolower(sex)=='m') sexno=1;
  else if(tolower(sex)=='f') sexno=2;

  fprintf(fpmaster,"\n%4s %d %3d %5.0f %3d %5.0f %3d %5.0f %3d %5.0f", init, sexno, wp, wpmrt, wn, wnmrt, cp, cpmrt, cn, cnmrt);
  fclose(fpmaster);

    /* END MESSAGE*/
  _setcursortype(_NOCURSOR);
  clrscr();
  window(9,8,71,17);
  textbackground(LIGHTGRAY);
  clrscr();
  window(10,9,70,16);
  textbackground(GREEN);
  textcolor(BLACK);
  clrscr();
  gotoxy(3,2);
  printf("THIS IS THE END OF THE EXPERIMENT");
  gotoxy(3,3);
  printf("Your results were saved in the '%s' file.",filetemp);
  getch();
  return;

}



