Program SDm;
(* SortDemo Version 2.4: 19 Mar 1995                                        *)

(* Copyright (C) 1995 Tapirsoft, Harald Selke                               *)
(* Based on a programme by K.L. Noell.                                      *)
(* Demonstration programme for sorting algorithms, command-line version     *)
(* See SortDemo.Doc for full documentation.                                 *)
(*                                                                          *)
(* This programme is free software; you can redistribute it and/or modify   *)
(* it under the terms of the GNU General Public License (version 1) as      *)
(* published by the Free Software Foundation.                               *)
(*                                                                          *)
(* This programme is distributed in the hope that it will be useful,        *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of           *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *)
(* GNU General Public License for more details.                             *)
(*                                                                          *)
(* You should have received a copy of the GNU General Public License        *)
(* along with this programme; if not, write to the Free Software            *)
(* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                *)


{$A+}                        (* Word alignment on                   *)
{$B-}                        (* Boolean complete evaluation off     *)
{$D+}                        (* Debug information on                *)
{$E+}                        (* Emulate coprocessor if necessary    *)
{$F-}                        (* Don't force far calls               *)
{$G-}                        (* Don't generate 80286 code           *)
{$I+}                        (* I/O checking on                     *)
{$L+}                        (* Generate local symbol information   *)
{$N-}                        (* No numeric processing               *)
{$O-}                        (* No overlaying                       *)
{$R+}                        (* Range checking on                   *)
{$S+}                        (* Stack checking on                   *)
{$V-}                        (* No var-string checking              *)
{$X-}                        (* No extended syntax allowed          *)
{$M 65520,0,655360}          (* Stack and heap size                 *)

Uses Crt, Graph, SortAlgs, SortInps;

Const NrAlgs      = 8;              (* Number of implemented algorithms     *)
      MaxDelay    = 1000;           (* Maximum delay between two operations *)

Type  String40     = String [40];
      AlgList      = Array [1..NrAlgs] Of String40;       (* the algorithms *)

Const Title       = 'SortDemo 2.4';
      Logo        = '(C) Tapirsoft, H. Selke';
      AlgMenu     : AlgList  = ('bubblesort', 'shakersort', 'selectionsort',
                                'insertionsort', 'shellsort','quicksort',
                                'heapsort', 'mergesort');

Var   achoice, ichoice, i,
      n, range, perc, WaitTime : Integer;
      OldTextAttr, HeadColour, HeadBackColour, TextColour, ParCount : Byte;
      s      : String40;
      IFName : String12;


Function li2s (l : longint) : String40;
(* Converts a long integer to a string. *)
Var s : String40;
Begin                                                               (* li2s *)
  Str (l:0,s);
  li2s := s;
End;   (* li2s *)

Function Str2Int (str : String40; MinVal, MaxVal : Integer) : Integer;
(* Converts a string to an integer. If the resulting integer is greater     *)
(* than MaxVal or less than MinVal, -1 is returned.                         *)
Var value, code : Integer;
Begin                                                            (* Str2Int *)
  Val (str, value, code);
  If (code <> 0) Or (value > MaxVal) Or (value < MinVal) Then Str2Int := -1
  Else Str2Int := value
End;    (* Str2Int *)

Procedure Lower (Var s : String); Assembler;
(* Converts a string to small letters.                                      *)
(* Taken from A. Schaepers, Turbo Pascal 6.0.                               *)
asm                                                                (* Lower *)
       push ds
       lds si, s                      (* ; Addr (s) to DS:SI                *)
       push ds
       pop es                         (* ; address of return string (ES:DI) *)
       mov di,si                      (* ; is the same                      *)
       cld
       lodsb                          (* ; lengthbyte of s                  *)
       stosb                          (* ; lengthbyte of return string      *)
       mov cl, al                     (* ; this is the lengthbyte           *)
       xor ch, ch
       jcxz @LoDone                   (* ; length is 0                      *)
@LLoop:lodsb                          (* ; load one character of s into al  *)
       cmp al, 'A'                    (* ; less than 'A'?                   *)
       jb @islower                    (* ; then, don't convert              *)
       cmp al, 'Z'                    (* ; less than or equal to 'Z'?       *)
       jb @islow                      (* ; then, direct conversion          *)
       cmp al, ''                    (* ; else                             *)
       jnz @L2
       mov al, ''
       jmp @islower
@L2:   cmp al, ''
       jnz @L3
       mov al, ''
       jmp @islower
@L3:   cmp al, ''
       jnz @islower
       mov al, ''
       jmp @islower
@islow:add al, 'a'-'A'                (* ; convert the character            *)
@islower: stosb                       (* ; and store it in the return string*)
       loop @LLoop                    (* ; until cx = 0                     *)
@LoDone: pop ds
End;   (* Lower *)

Procedure Usage (number : Integer);
(* Number determines which error message is displayed. *)
Var c : Char;

Procedure ShowTitle;
Var OldTextAttr : Byte;
Begin                                                          (* ShowTitle *)
  OldTextAttr := TextAttr;
  TextAttr := HeadColour + 16 * HeadBackColour;
  GotoXY (Lo(WindMin)+1, Hi(WindMin)+1);
  ClrEol; Write (Logo);
  GotoXY ((Lo(WindMax) - Length (Title)) Div 2, Hi(WindMin)+1);
  Write (Title);
  TextAttr := OldTextAttr;
  WriteLn; WriteLn;
End;   (* ShowTitle *)

Begin                                                              (* Usage *)
  CloseGraph;
  ClrScr;
  ShowTitle;
  WriteLn ('Usage: SDm [options] algorithm');
  If number = 0 Then
    WriteLn ('For full details on SDm and the SortDemo package, ',
             'see the file SortDemo.Doc.')
  Else WriteLn ('Type SDm ? for a complete help screen.');
  WriteLn;
  If (number = 0) Or (number = 2) Then
  Begin
    WriteLn ('Options:');
    WriteLn ('  -N<number>  = number of keys to be sorted (up to ',
                             XMax, ');    default: ', n);
    WriteLn ('  -R<range>   = range of values of keys (up to ',
                             YMax, ');        default: ', range);
    WriteLn ('  -P<percent> = percentage of keys out of order ',
                             '(1 to 30);  default: ', perc);
    WriteLn ('  -D<time>    = delay time in milliseconds (up to ',
                             MaxDelay, ');    default: ', DelayTime);
    WriteLn ('  -W<time>    = wait time before starting ',
                             '(up to 10000 ms); default: ', WaitTime);
    WriteLn;
    Write   ('  -RAndom        = random input', ' ':10);
    WriteLn ('  -Fast     = fast (real time) mode');
    Write   ('  -REverse       = reverse ordered input', ' ':1);
    WriteLn ('  -SLow     = slow motion');
    Write   ('  -SOrted        = sorted input', ' ':10);
    WriteLn ('  -Manual   = manual mode');
    WriteLn ('  -Almost        = almost sorted input');
    WriteLn ('  -I[<filename>] = input from file'); WriteLn;
  End;
  If number < 2 Then
  Begin
    Write ('Algorithms:',' ':29);
    WriteLn ('This is free software, and you are');
    Write ('  Bubblesort          SHEllsort',' ':9);
    WriteLn ('welcome to redistribute it under');
    Write ('  SHAkersort          Quicksort',' ':9);
    WriteLn ('certain conditions; however, it comes');
    Write ('  SElectionsort       Heapsort',' ':10);
    WriteLn ('with ABSOLUTELY NO WARRANTY. See the');
    Write ('  Insertionsort       Mergesort',' ':9);
    WriteLn ('file COPYLEFT for full details.');
  End
  Else
  Begin
    Case number Of
         2  : ;
         3  : WriteLn ('The number of keys must lie in the interval (2,',
                       XMax, ').');
         4  : WriteLn ('The range of values must lie in the interval (1,',
                       YMax, ').');
         5  : WriteLn ('Percentages must lie in the interval (1,30).');
         6  : WriteLn ('The delay time must lie in the interval (0,',
                       MaxDelay, ').');
         7  : WriteLn ('The wait time must lie in the interval (0,10000).');
         10 : WriteLn ('I can''t open that input file.');
         11 : WriteLn ('The input file must not contain negative numbers.');
         12 : WriteLn ('The input file must contain at least two numbers.')
    End;
    WriteLn;
    WriteLn ('This is free software, and you are welcome to ',
             'redistribute it under');
    WriteLn ('certain conditions; however, it comes with ',
             'ABSOLUTELY NO WARRANTY.');
    WriteLn ('See the file COPYLEFT for full details.');
  End;
  WriteLn;
  Write ('Hit a key to leave SDm.');
  c := ReadKey;
  TextAttr := OldTextAttr;
  Halt
End;   (* Usage *)

Procedure ReadConfigFile;
Var ConfigFile : Text;
    Buf : Array [1..2000] Of Char;
    i, t, IORes : Integer;
    s, v : String40;

Procedure ReadConfigLine;
Var c : Char;
Begin                                                     (* ReadConfigLine *)
  s := ''; v := '';
  While (Not EoF (ConfigFile)) And (EoLn (ConfigFile)) Do
    ReadLn (ConfigFile);
  If Not EoF (ConfigFile) Then
  Begin
    Read (ConfigFile, c);
    If c <> '#' Then
    Begin
      Repeat
        If (c <> ' ') Then s := s + c;
        Read (ConfigFile, c);
      Until (EoLn (ConfigFile)) Or (c = ':');
      If Not EoLn (ConfigFile) Then
      Begin
        Repeat
          Read (ConfigFile, c);
          If (c <> '#') And (c <> ' ') Then v := v + c
        Until (EoLn (ConfigFile)) Or (c = '#');
      End
    End;
    ReadLn (ConfigFile)
  End;
End;   (* ReadConfigLine *)

Function Colour (v : String40; OldColour : Byte) : Byte;
(* Returns the number of the colour named v, or the value of OldColour if v *)
(* isn't a valid name.                                                      *)
Type PaletteType = Array [0..15] Of String [12];
Const Palette : PaletteType = ('black','blue','green','cyan','red','magenta',
                               'brown','lightgray','darkgray','lightblue',
                               'lightgreen','lightcyan','lightred',
                               'lightmagenta','yellow','white');
Var i : Integer;
Begin                                                             (* Colour *)
  i := 0;
  While (i < 16) And (v <> Palette [i]) Do Inc (i);
  If i < 16 Then Colour := i
  Else Colour := OldColour
End;   (* Colour *)

Begin                                                     (* ReadConfigFile *)
  {$I-}
  Assign (ConfigFile, 'SortDemo.Cfg');
  SetTextBuf (ConfigFile, Buf);
  Reset (ConfigFile);
  {$I+}
  IORes := IOResult;
  If IORes = 0 Then
  Begin
    While Not EoF (ConfigFile) Do
    Begin
      ReadConfigLine;
      If s <> '' Then
      Begin
        Lower (s); Lower (v);
        If s = 'dotcolour' Then DotColour := Colour (v, DotColour)
        Else If s = 'textcolour' Then TextColour  := Colour (v, TextColour)
        Else If s = 'backcolour' Then BackColour  := Colour (v, BackColour)
        Else If s = 'headcolour' Then HeadColour := Colour (v, HeadColour)
        Else If s = 'headbackcolour' Then
          HeadBackColour := Colour (v, HeadBackColour)
        Else If s = 'numberofkeys' Then
        Begin
          t := Str2Int (v,2,XMax);
          If t <> -1 Then
          Begin
            n := t; XDist := XMax Div n
          End
        End
        Else If s = 'range' Then
        Begin
          t := Str2Int (v,1,YMax);
          If t <> -1 Then
          Begin
            range := t; YDist := YMax Div range
          End
        End
        Else If s = 'input' Then
        Begin
          If v = 'random' Then ichoice := 1
          Else If v = 'reverse' Then ichoice := 2
          Else If v = 'sorted' Then ichoice := 3
          Else If v = 'almost' Then ichoice := 4
          Else If v = 'file' Then ichoice := 5
        End
        Else If s = 'percentage' Then
        Begin
          t := Str2Int (v,1,30); If t <> -1 Then perc := t
        End
        Else If s = 'inputfile' Then IFName := v
        Else If s = 'speed' Then
        Begin
          If v = 'fast' Then speed := fast
          Else If v = 'slow' Then speed := slow
          Else If v = 'manual' Then speed := manual
        End
        Else If s = 'delaytime' Then
        Begin
          t := Str2Int (v,0,MaxDelay); If t <> -1 Then DelayTime := t
        End
        Else If s = 'waittime' Then
        Begin
          t := Str2Int (v,0,10000); If t <> -1 Then WaitTime := t
        End
      End
    End
  End
End;   (* ReadConfigFile *)

Procedure Prepare;
(* Initializes the graphics card and the variables. *)
Var GrMode, GrDriver, ErrorCode : Integer;
Begin                                                            (* Prepare *)
  GrDriver := Detect;
  InitGraph (GrDriver, GrMode, '');
  ErrorCode := GraphResult;
  If ErrorCode <> 0 Then
  Begin
    CloseGraph;
    WriteLn (GraphErrorMsg (ErrorCode));
    Halt
  End;
  DotColour := GetMaxColor;
  TextColour := LightGray;
  BackColour := Black;
  HeadColour := Black;
  HeadBackColour := LightGray;
  XMax := GetMaxX + 1;
  YMax := GetMaxY + 1;
  If XMax > NMax Then XMax := NMax;
  n := XMax;
  range := YMax;
  XDist := 1; YDist := 1;
  achoice := 0; ichoice := 1;
  speed := fast; perc := 10;
  DelayTime := 10; WaitTime := 1000;
  IFName := 'SortDemo.Inp';
  ReadConfigFile;
  OldTextAttr := TextAttr;
  TextAttr := TextColour + 16 * BackColour;
  SetColor (DotColour);
  SetBkColor (BackColour);
  SetViewPort (0,0,XMax,YMax,Clipon);
  ClearDevice
End;   (* Prepare *)

Procedure CallFileInit (IFName : String12; Var n, range : Integer);
Var FIResult : Integer;
Begin
  FIResult := FileInit (IFName, n, range, True);
  If FIResult <> 0 Then Usage (FIResult);
End;

(* ----------------------------------------- *)

Begin                                                                (* SDm *)
  Randomize;
  Prepare;
  ParCount := ParamCount;
  If ParCount < 1 Then Usage (0);
  s := ParamStr (ParCount);
  For i := 1 To ParCount Do
  Begin
    s := ParamStr (i);
    Lower (s);
    If (Pos ('-', s) = 1) Or (Pos ('/', s) = 1) Then
    Begin
      Delete (s, 1, 1);
      If Pos (s, 'random') = 1 Then ichoice := 1
      Else If Pos (s, 'reverse') = 1 Then ichoice := 2
      Else If Pos (s, 'sorted') = 1 Then ichoice := 3
      Else If Pos (s, 'almost') = 1 Then ichoice := 4
      Else If Pos (s, 'fast') = 1 Then speed := fast
      Else If Pos (s, 'slow') = 1 Then speed := slow
      Else If Pos (s, 'manual') = 1 Then speed := manual
      Else Case s [1] Of
             'n' : Begin
                     Delete (s, 1, 1);
                     n := Str2Int (s, 2, XMax);
                     If n = -1 Then Usage (3)
                     Else XDist := XMax Div n
                   End;
             'r' : Begin
                     Delete (s, 1, 1);
                     range := Str2Int (s, 1, YMax);
                     If range = -1 Then Usage (4)
                     Else YDist := YMax Div range
                   End;
             'p' : Begin
                     Delete (s, 1, 1);
                     perc := Str2Int (s, 1, 30);
                     If perc = -1 Then Usage (5)
                     Else ichoice := 4
                   End;
             'd' : Begin
                     Delete (s, 1, 1);
                     DelayTime := Str2Int (s, 0, MaxDelay);
                     If DelayTime = -1 Then Usage (6)
                     Else speed := slow
                   End;
             'w' : Begin
                     Delete (s, 1, 1);
                     WaitTime := Str2Int (s, 0, 10000);
                     If WaitTime = -1 Then Usage (7)
                   End;
             'i' : Begin
                     ichoice := 5;
                     Delete (s, 1, 1);
                     If s <> '' Then IFName := s
                   End
             Else  Usage (2)
           End;
    End
    Else If (Pos ('?', s) = 1) Then Usage (0)
    Else
    Begin
      achoice := 0;
      Repeat
        Inc (achoice);
        If achoice > NrAlgs Then Usage (1)
      Until Pos (s, AlgMenu [achoice]) = 1
    End
  End;
  If achoice = 0 Then Usage (1);
  Case ichoice Of
    1 : RandomInit (n, range);
    2 : ReversInit (n, range);
    3 : SortedInit (n, range);
    4 : AlmostInit (n, range, perc);
    5 : CallFileInit (IFName, n, range)
  End;
  Delay (WaitTime);
  Case achoice Of
    1 : BubbleSort (n);
    2 : ShakerSort (n);
    3 : SelectSort (n);
    4 : InsertSort (n);
    5 : ShellSort  (n);
    6 : QuickSort  (n);
    7 : HeapSort   (n);
    8 : MergeSort  (n);
  End;
  OutTextXY (30, 10, 'Comparisons: ' + li2s (comps));
  OutTextXY (30, 20, 'Exchanges  : ' + li2s (swaps));
  OutTextXY (30, 30, 'Press <Return> to quit.');
  While Not (ReadKey In [#3, #13, #27]) Do;
  CloseGraph;
  TextAttr := OldTextAttr
End.   (* SDm *)
