/*
 * For Epsilon version 5.0:
 *
 * Copyright (C) 1991, K. Shane Hartman
 *
 * This file is free software; you can redistribute it and/or modify
 * it under so long as this notice is preserved and no fee is charged 
 * (other than reasonable media fees) for distribution. You are forbidden 
 * to deny these rights to any other user of Epsilon.  Lugaru Software Ltd.
 * may incorporate any and all of this code into Epsilon and have all rights
 * to the code, since it is only useful for Epsilon,
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * Revision History:
 * Send bug fixes, comments or suggestions to shane@ai.mit.edu.
 *
 * Version 1.1: 07/17/91 shane@ai.mit.edu
 * Version 1.2: 07/29/91 shane@ai.mit.edu Quote (") the topic pattern for DOS.
 *                       Remove incorrect comment about setting environment
 *                       variable.
 * Version 1.3: 08/02/91 shane@ai.mit.edu Changed copyright wording.
 * Version 1.4: 08/17/91 J.Kercheval, johnk@wrq.com Modify to use the filename
 *                       buffer for the process buffer and to clean up
 *                       buffers on exit. Delete filename buffer, then 
 *                       create it.  This prevents splitting multiple 
 *                       instances of the paste buffer.
 *
 * Interface to Microsoft QH help system from Epsilon.
 *
 * You invoke the command with M-x QH.  The default topic offered is the
 * closest word.  QH (which must be in your path) is invoked with the topic
 * you type (or the default).  If you paste from within QH (P command), then
 * return to Epsilon (X command), the pasted output will be written to the file
 * qh.out.  The window will be split between the original window and the
 * pasted output will be displayed.
 *
 */

#include "eel.h"

command qh () on reg_tab[ALT('h')]
{
  char cmd[80];
  char topic[40];
  char *oldbuf = bufname;
  char *fname = "qh.out";
  
  iter = 0;
	re_search (1, word_pattern);
	re_search (-1, word_pattern);
	grab (point, matchstart, topic);
  get_strdef (cmd, "Topic", topic);
  strcpy (topic, cmd);
  sprintf (cmd, "qh -p%s \"%s\"", fname, topic);
  shell ("", cmd, fname);
  delete_buffer (fname);
  create (fname);
  bufname = fname;
  if (file_read (fname, 1) || !size ())
  {
    bufname = oldbuf;
    delete_buffer (fname);
  }
  else
  {
    delete_file (fname);
    bufname = oldbuf;
    center_window ();
    window_split (HORIZONTAL);
    to_buffer (fname);
    window_number--;
  }
}
