       
/*
**  Motorola S-Record Format Functions.
**
**  Copyright 1993-97 by Paul D. Burgin. All rights reserved.
*/

#include "stdio.h"
#include "ctype.h"
#include "dos.h"
#include "dir.h"
#include "conio.h"

#include "build.h"
#include "types.h"
#include "extern.h"

FILE			*mfp;
int				lastchar;
unsigned char	checksum;
boolean			reported_error;
unsigned char	last_moto[MAXPATH+4] = "motorola";

/* Read a hexadecimal digit from file. */
unsigned char hex_digit(void)
{
	if (lastchar != EOF)
	{
		lastchar = fgetc(mfp);

		if ((lastchar >= '0') && (lastchar <= '9'))
			return (lastchar - '0');

		else if ((lastchar >= 'A') && (lastchar <= 'F'))
			return (lastchar - 'A') + 10;

		else if (lastchar != EOF)
		{
			selection_box(1,16,0,FALSE,FALSE,FALSE,99,"File is corrupt!");
			lastchar = EOF;
			reported_error = TRUE;
		}
	}
	return 0;
}

/* Read a hexidecimal number from file. */
unsigned char hex_pair(void)
{
	unsigned char hex_value;

	hex_value = (hex_digit() << 4) | hex_digit();
	checksum += hex_value;
	return(hex_value);
}

/* Read a motorola format record from file. */
void load_record(unsigned char address_length)
{
	unsigned long	record_address;
	unsigned char	record_length;
	boolean			old_mapmode1 = mapmode1;

	mapmode1 = TRUE;
	checksum = 0;
	record_length = (hex_pair() - address_length) - 1;
	record_address = (hex_pair() << 8) | hex_pair();
	if (address_length > 2)
		record_address = (record_address << 8) | hex_pair();

	if (record_address < 0x0000ff00)
	{
		while (record_length-- > 0)
			far_set_mem8((unsigned int)record_address++, hex_pair());

		hex_pair();
		if ((checksum != 0xff) && !reported_error)
		{
			selection_box(1,17,0,FALSE,FALSE,FALSE,99,"Checksum failure!");
			lastchar = EOF;
			reported_error = TRUE;
		}

		while ((lastchar != '\n') && (lastchar != EOF))
			lastchar = getc(mfp);
	}
	else
	{
		selection_box(1,21,0,FALSE,FALSE,FALSE,99,"Address out of range!");
		lastchar = EOF;
		reported_error = TRUE;
	}

	mapmode1 = old_mapmode1;
}

/* Load motorola S format file into dragon address space. */
boolean load_motorola(unsigned char *moto_name)
{
	boolean	end_received = FALSE;
	reported_error = FALSE;

	/* Open input file. */
	if ((mfp = fopen(moto_name,"rt")) == NULL)
	{
		selection_box(2,14,0,FALSE,FALSE,FALSE,99,
			"Failed to open",
			"motorola file!");
		return FALSE;
	}

	/* Read the records of the file. */
	do
	{
		lastchar = fgetc(mfp);
		if (lastchar != EOF)
		{
			/* Check for record signature. */
			if (lastchar != 'S')
			{
				selection_box(1,18,0,FALSE,FALSE,FALSE,99,"Invalid file type!");
				fclose(mfp);
				return FALSE;
			}

			/* Check record type & load it. */
			switch (lastchar = fgetc(mfp))
			{
				case EOF:	break;

				case '0':   /* comment record */
							do
							{
								lastchar = getc(mfp);
							} while ((lastchar != '\n') && (lastchar != EOF));
							break;

				case '1':	/* 2 byte address record */
							load_record(2);
							break;

				case '2':	/* 3 byte address record */
							load_record(3);
							break;

				case '8':   /* 3 byte address end record */
							load_record(3);
							end_received = TRUE;
							lastchar = EOF;
							break;

				case '9':   /* 2 byte address end record */
							load_record(2);
							end_received = TRUE;
							lastchar = EOF;
							break;

				default:	selection_box(1,20,0,FALSE,FALSE,FALSE,99,
								"Unknown record type!");
							fclose(mfp);
							return FALSE;
			}
		}
	} while (lastchar != EOF);

	fclose(mfp);

	if (!end_received && !reported_error)
		selection_box(1,22,0,FALSE,FALSE,FALSE,99,"Premature end of file!");
	return(!reported_error);
}
