#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>

void OutputHelp(unsigned char *progname);
extern void ProcessDatafile(FILE *datafile, int tfoverride, char *tfname, int restore);  // interpret.c
extern long int GetFilesize(FILE *target);  // check.c
extern long int SearchForLinkedDatafile(FILE *datafile);  // check.c
extern void LinkDatafile(char *exename, char *datafilename);  // misc.c
extern void ExtractDatafile(char *exename, char *datafilename);  // misc.c


int main(int argc, char *argv[])
{
unsigned char datafilename[66]={0}, tfname[66]={0}, progname[13]={0};
unsigned char *p_dummy;
FILE *datafile;
int link_datafile=0, extract_linked_datafile=0;
int tfoverride=0, restore=0, i, j;
long int linked_datafile_offset=0;

p_dummy = argv[0] + strlen(argv[0]);  // get the programm-filename
while (*p_dummy != '\\' && p_dummy != argv[0]) p_dummy--; p_dummy++;
strcpy(progname, p_dummy); p_dummy = progname;
while (*p_dummy != '.' && p_dummy != argv[0]+strlen(argv[0])) p_dummy++; *p_dummy = 0;


for (i=1; i<=argc-1; i++)   // walk through every arg
  {
  if (argv[i][0] == '-' || argv[i][0] == '/')    // option ?
        {
        for (j=1; j<strlen(argv[i]); j++)
          {
          switch (tolower(argv[i][j]))
                {
                case 'h':         // help
                case '?':
                  OutputHelp(progname);
                  exit(0);
                case 'r':         // restore
                  restore = 1;
                  break;
                case 'l':         // link datafile given in commandline
                  link_datafile = 1;
                  break;
                case 'x':         // extract linked datafile to name in commandline
                  extract_linked_datafile = 1;
                  break;
                case 't':         // use linked datafile, ask for new targetfilename
                  printf("\nEnter new targetfilename: "); gets(tfname);
                  tfoverride = 1;
                  break;
                default:          // wrong option ...
                  fprintf(stderr, "\nUsage: %s [-rlxth?] [datafile] [targetfile]\n", progname);
                  exit(1);
                  }
                }
          }
   else
        {
        if (datafilename[0] == NULL && !tfoverride)  // first get datafilename,
          {                                          // then get targetfilename
          strcpy(datafilename, argv[i]);
          }
        else if (tfname[0] == NULL && !tfoverride)
          {
          strcpy(tfname, argv[i]);
          tfoverride = 1;
          }
        else if (!tfoverride)               // too much arguments ...
          {
          fprintf(stderr, "\nUsage: %s [-rlxth?] [datafile] [targetfile]\n", progname);
          exit(1);
          }
        }
  }

if (link_datafile)
  {
  LinkDatafile(argv[0], datafilename);       // link it
  exit(0);
  }
if (extract_linked_datafile)
  {
  ExtractDatafile(argv[0], datafilename);    // extract it
  exit(0);
  }

if (datafilename[0] == NULL)
  {                              // try to use linked datafile
  if ((datafile = fopen(argv[0], "rb")) == NULL)
                {
                fprintf(stderr, "\nCannot open programm file for linked datafile search. Aborting.\n");
                exit(255);
                }
  clrscr();
  printf("Searching for linked datafile ...");
  linked_datafile_offset = SearchForLinkedDatafile(datafile);  // look for a linked df
  if (linked_datafile_offset == 0)
                {
                fprintf(stderr, " Failed.\nNo linked datafile found.\nUsage: %s [-raxth?] datafile [targetfile]\n", progname);
                fclose(datafile);
                exit(1);
                }
  printf(" Done.\nUsing linked datafile.\n");
  fclose(datafile);
  datafile = fopen(argv[0], "rt");
  fseek(datafile, linked_datafile_offset, SEEK_SET);  // go to linked df
  }
 else
  {                              // datafilename given in commandline, use it
  clrscr();
  // open datafile
  printf("Opening datafile %s ...", datafilename);
  if ((datafile = fopen(datafilename, "rt")) == NULL)
                {
                fprintf(stderr, "\n Cannot open datafile %s. Aborting.\n", datafilename);
                exit(255);
                }
   else
                {
                printf(" Done.\n");
                }
  // go to the beginn of datafile
  // Kill this line when you want ProcessDatafile to begin at the actual location.
  fseek(datafile, 0L, SEEK_SET);
  }

if (restore) printf("Restoring enabled.\n");

// dispatch datafile
ProcessDatafile(datafile, tfoverride, tfname, restore);

// close datafile
printf("Closing datafile.\n");
fclose(datafile);

return 0;
}



void OutputHelp(unsigned char *progname)
{
clrscr();
printf("                               PATCH 1.0                   1996 by A. Pretzsch\n"
           "\n"
           "PATCH patches the targetfile(s) following the instructions given in a datafile.\n"
           "Restoring the targetfile(s) is possible, too. A linked datafile can be used.\n"
           "\n"
           "Usage: %s [-rlxth?] [datafile] [targetfile]\n"
           "\n"
           "  Options:\n"
           "    r: restore targetfile(s) using the given original-data in datafile\n"
           "    l: link datafile\n"
           "    x: extract linked datafile\n"
           "    t: use linked datafile, ask for new targetfilename\n"
           "    h/?: This help\n"
           "\n"
           "Features:\n"
           "  - restoring\n"
           "  - linked datafile\n"
           "  - multiple targetfiles\n"
           "  - CRC16 check\n"
           "  - filesize check\n"
           "  - execute external commands (query)\n"
           "  - message output\n"
           "  - automatic backup files (query)\n"
           "\n", progname);
return;
}
