


MAKEKIT(1)          UNIX Programmer's Manual           MAKEKIT(1)



NAME
     makekit - split files up into shell archive packages

SYNOPSIS
     makekit [ -e ] [ -h# ] [ -iname ] [ -k# ] [ -m ] [ -nname ]
     [ -oname ] [ -p ] [ -s#[k] ] [ -ttext ] [ file...  ]

DESCRIPTION
     Makekit reads a list of files and directories, determines
     their sizes, and parcels them up into a series of shell
     archives such that all the archives are of reasonable size.
     It then invokes shar(1L) to actually create the archives.

     By default, no archive will be larger than about 50,000
     bytes; this may be changed by using the ``-s'' option.  If
     the number given with the ``-s'' option ends with the letter
     ``k'' then the size is multiplied by 1024, otherwise it is
     taken to be the desired maximum size, in bytes.  Each
     archive will have a name that looks like Partnn, where
     ``nn'' represents the two-digit sequence number (with lead-
     ing zero if needed).  The leader part of the archive name
     may be changed with the ``-n'' option.  The ``-n'' is also
     useful when write permission to the directory being archive
     is defined; e.g., ``-n/tmp/KERNEL.''

     Makekit reads its list of files on the command line, or
     standard input if none are given.  It is also possible to
     specify an input filename with the ``-i'' option.  The input
     should contain a list of files, one to a line, to separate.
     In addition, if each input line looks like this:
          filename   whitespaces   optional-
          digits   whitespaces   text
     then makekit will ignore the spaces and digits, but remember
     the text associated with each file, and output it with the
     filename when generating the ``shipping manifest.'' Further,
     the ``-h'' option may be given to have the program skip the
     indicated number of lines in the input; this option is pro-
     vided so that makekit can more easily re-parse the manifests
     it has generated.

     The generated manifest will be sent to the standard output.
     An alternate output file may be given by using the ``-o''
     option; if the output file exists, makekit will try to
     rename it with an extension of .BAK.  If the ``-o'' option
     is used, makekit will add that name to the list of files to
     be archived; the ``-e'' option may be given to exclude the
     manifest from the list.

     The ``-m'' option is the same as given the options, ``-
     iMANIFEST -oMANIFEST -h2.''





Printed 2/21/88               LOCAL                             1






MAKEKIT(1)          UNIX Programmer's Manual           MAKEKIT(1)



     After partitioning the files and directories, makekit calls
     shar with the proper options to generate archives in a
     series.  Each resultant archive will, when executed, check
     to see if all the parts are present.  By using the ``-t''
     option, you can specify a line of starting instructions to
     display to the recipient when all pieces have been unpacked.
     See shar for more information on multi-part archives.  If
     the ``-x'' option is used, shar is not called, but the mani-
     fest is still created.

     Makekit normally reorders its input so that the archives are
     as ``dense'' as possible, with the exception that direc-
     tories are given priority over files, and a file named
     README is the first of all.  The manifest is also sorted in
     alphabetical order; this makes it easy to locate ``missing''
     files when the distribution is a large one.  The ``-p''
     option may be used to override both sortings, however, and
     preserve the original order of the input list in generating
     both the manifest, and the shell archives.

NOTES
     Makekit tries to partition the files so that all directories
     are in the first archive.  This usually means the first
     archive must be the first one to be unpacked.

SEE ALSO
     findsrc(1L), shar(1L)




























Printed 2/21/88               LOCAL                             2



