goto start
:usage
echo off
cls
echo Ŀ
echo  asp_cd.bat -- Extracts VENDINFO.DOZ fields currently  
echo                used in processing submissions for the  
echo                Formgen ASP CD-ROM, for visual check.   
echo                Also prepares checklist for submission. 
echo                (Creates temporary files ASPCD.TMP and  
echo                ASPPRINT.TMP in current directory.)     
echo                                                        
echo  usage:                                                
echo         asp_cd vendinfo_file                           
echo  where:                                                
echo         vendinfo_file = pathname of VENDINFO.DOZ file  
echo                                                        
echo  example:                                              
echo     asp_cd C:\VENDINFO.DOZ                             
echo                                                        
echo  NOTE: VENDPRCS.EXE must be on your DOS path.          
echo                                                        
echo  From the VNDUTL VENDINFO Utilities, v1.20 (3/6/95)    
echo  Copyright 1995 Rams' Island Software, Parker, CO USA  
echo 
goto done

::----- check arguments -------------------------------------------
::-----    first argument must VENDINFO file pathname -------------
:start
if %1. == .        goto usage

:UpdateOK
if not exist %1    goto problem
goto argsOK

:argsOK
::----- test VENDINFO file ----------------------------------------   
vendprcs %1 -xppt
if errorlevel 52 goto viFileOK
goto problem

:viFileOK
::----- display relevant fields, for visual checking --------------

echo     ASP CD-ROM Submission Checker (for Formgen ASP CD-ROM)   >  ASPCD.TMP
vendprcs -y " "                                          >> ASPCD.TMP
echo Verify that the following information is complete and correct. >> ASPCD.TMP
echo In particular, notice and correct any fields whose value is given >> ASPCD.TMP
echo as "(none)", unless the information is clearly irrelevant to your >> ASPCD.TMP
echo product.                                            >> ASPCD.TMP
vendprcs -y " "                                          >> ASPCD.TMP
echo SPECIAL NOTES:                                      >> ASPCD.TMP
echo   The "Author number" field is your ASP Author Member >> ASPCD.TMP
echo      number, assigned by ASP, listed on your ASPects mailing label, >> ASPCD.TMP
echo      or obtainable from the ASP member database (ASPDAT.ZIP, downloadable >> ASPCD.TMP
echo      from CompuServe forum or obtainable from ASP). >> ASPCD.TMP
echo   The "Product number" field is a number you assign to each >> ASPCD.TMP
echo      of your products, starting at 1 and continuing sequentially. >> ASPCD.TMP
echo   FormGen is using only four lines of address information, >> ASPCD.TMP
echo      so you should make sure your entire address appears below. >> ASPCD.TMP
vendprcs -y " "                                          >> ASPCD.TMP
echo INFORMATION EXTRACTED FROM YOUR DOZ FILE:           >> ASPCD.TMP
vendprcs %1 -xac     -y "Company name:      @"           >> ASPCD.TMP
vendprcs %1 -xcdfi   -y "Author number:     @"           >> ASPCD.TMP
vendprcs %1 -xaa -zi19 -zc30 -zr4 -y "Author address:    @" >> ASPCD.TMP
vendprcs %1 -xap     -y "Author phone:      @"           >> ASPCD.TMP
vendprcs %1 -xaei    -y "Author e-mail:     @"           >> ASPCD.TMP
vendprcs -y " "                                          >> ASPCD.TMP
vendprcs %1 -xpp     -y "Product name:      @"           >> ASPCD.TMP
vendprcs %1 -xpv	   -y "Version number:    @"           >> ASPCD.TMP
vendprcs %1 -xpc1	   -y "Category:          @"           >> ASPCD.TMP
vendprcs %1 -xcdfj	-y "Product number:    @"           >> ASPCD.TMP

vendprcs -y " "                                          >> ASPCD.TMP
vendprcs %1 -xcdff	-y "Doc filename:      @"           >> ASPCD.TMP
vendprcs %1 -xcdfg   -y "Order form:        @"           >> ASPCD.TMP
vendprcs %1 -xpn	   -y "ZIP prefix:        @"           >> ASPCD.TMP
vendprcs %1 -xcdfk	-y "Preferred dir:     @"           >> ASPCD.TMP
vendprcs %1 -xcdfb	-y "Volume label:      @"           >> ASPCD.TMP
vendprcs %1 -xcdpe	-y "Install command:   @"           >> ASPCD.TMP
vendprcs %1 -xcdpl	-y "Config command:    @"           >> ASPCD.TMP
vendprcs %1 -xcdpc	-y "Startup command:   @"           >> ASPCD.TMP
vendprcs -y " "                                          >> ASPCD.TMP
vendprcs %1 -xp2df	-y "Disk space req:    @K"          >> ASPCD.TMP
vendprcs %1 -xpfvv	-y "VGA required?:     @"           >> ASPCD.TMP
vendprcs %1 -xpfim	-y "Mouse required?:   @"           >> ASPCD.TMP
vendprcs -y " "                                          >> ASPCD.TMP
vendprcs %1 -xpd4 -zi19 -zc45 -y "Short Description: @"  >> ASPCD.TMP
vendprcs -y " "                                          >> ASPCD.TMP
vendprcs -y "Long Description:"                          >> ASPCD.TMP
vendprcs %1 -xpd6 -zi2 -zc75 -y "  @"                    >> ASPCD.TMP

echo ============================================================================ > ASPPRINT.TMP
echo Checklist of preparation steps for ASP CD-ROM submission: >> ASPPRINT.TMP
echo ============================================================================ >> ASPPRINT.TMP
vendprcs -y " " >> ASPPRINT.TMP
echo  [ ] Prepare a VENDINFO.DOZ (description OUT OF zip) file for >> ASPPRINT.TMP
echo      your product (you've presumably already done this, and are >> ASPPRINT.TMP
echo      checking it now). >> ASPPRINT.TMP
vendprcs -y " " >> ASPPRINT.TMP
vendprcs %1 -xppl -y " [ ] Prepare @.ZIP package, with embedded FILE_ID.DIZ file," >> ASPPRINT.TMP
echo      and with embedded VENDINFO.DIZ (description IN zip) file if desired. >> ASPPRINT.TMP
vendprcs -y " " >> ASPPRINT.TMP
echo  [ ] Place the file on a (preferably 3-1/2) diskette. >> ASPPRINT.TMP
echo      (You may include multiple *.ZIP files on one diskette.) >> ASPPRINT.TMP
vendprcs -y " " >> ASPPRINT.TMP
echo  [ ] Place the VENDINFO.DOZ file you've prepared on the same >> ASPPRINT.TMP
vendprcs %1 -xppl -y "     diskette, renaming it to @.DOZ." >> ASPPRINT.TMP
vendprcs -y " " >> ASPPRINT.TMP
echo  [ ] Send package to: >> ASPPRINT.TMP
echo         FormGen, Inc. >> ASPPRINT.TMP
echo         ATTN: Roger Arias >> ASPPRINT.TMP
echo         7641 East Gray Rd. >> ASPPRINT.TMP
echo         Scottsdale, AZ  49677 >> ASPPRINT.TMP
echo         USA >> ASPPRINT.TMP
vendprcs -y " " >> ASPPRINT.TMP
echo ============================================================================ >> ASPPRINT.TMP
echo                                                      Produced by VNDUTL 1.20 >> ASPPRINT.TMP

::----- display created file ----------------------------------------
@echo off
cls
more < ASPCD.TMP
pause

::----- display checklist -------------------------------------------
cls
type ASPPRINT.TMP
pause

::----- display print instruction -----------------------------------
cls
echo For a printed version of the checklist, simply print ASPPRINT.TMP.

goto done

:problem
@echo off
cls
echo Specified VENDINFO file
echo    (%1)
echo does not exist, or is corrupted, unregistered, or has some other
echo difficulty.
goto done

:done
