/*
  letters.h - Letter handling for extended ASCII.

  Jason Hood, 19 November, 2002.

  The standard ctype functions will not recognise extended ASCII, but the LFN
  functions will. Create a set of tables to correctly handle case conversions.
*/

#ifndef LETTERS_H
#define LETTERS_H

extern char _upper_char[256];	// Translate lower- to uppercase.
extern char _lower_char[256];	// Translate upper- to lowercase.

#define upper( c ) _upper_char[(unsigned char)c]
#define lower( c ) _lower_char[(unsigned char)c]

char* strupper( char* );
char* strlower( char* );
int   strcomp( const char*, const char* ); // Compare ignoring case

#endif
