/*
  pattern.h: Wildcard pattern matching.

  Jason Hood, 8 November, 2002.

  Initially based on regexpr.h by Vesa Kolhinen.
*/

#ifndef PATTERN_H
#define PATTERN_H

#include <dos.h>


#define MAX_LEN 260		// Maximum length of a complete path name

char* compile_set( char* );
int   compile_pattern( char* , char* );
int   matchstr( char*, char* );
void  make_appr_mask( char*, char* );
int   efindfirst( char*, char*, struct my_ffblk*, int );
#define efindnext( pattern, ffblk ) efindfirst( pattern, "", ffblk, 0 )

typedef struct
{
  char* str;
  int	len;
} substr;

#define MAX_SUBPATS 60
#define MAX_METAS   10

extern int    caseless;
extern substr subpat[MAX_SUBPATS];
extern int    subpats;
extern int    meta[4][MAX_METAS];
extern int    metas[4];

#endif
