/*
   letters.h - Letter handling for extended ASCII.

   Jason Hood, 19 November, 2002.

   The standard ctype functions will not recognise extended ASCII, but the LFN
   functions will. Create a set of tables to correctly handle case conversions.

   v1.01 - 6 April, 2003:
     Win32 has its own functions.
*/

#ifndef LETTERS_H
#define LETTERS_H

#ifdef _WIN32

#include <windows.h>

#define upper( c ) (char)(long)CharUpper( (char*)(unsigned char)c )
#define lower( c ) (char)(long)CharLower( (char*)(unsigned char)c )
#define strupper CharUpper
#define strlower CharLower
#define strcomp  lstrcmpi

#else // DOS

extern char _upper_char[256];	// Translate lower- to uppercase.
extern char _lower_char[256];	// Translate upper- to lowercase.

#define upper( c ) _upper_char[(unsigned char)c]
#define lower( c ) _lower_char[(unsigned char)c]

char* strupper( char* );
char* strlower( char* );
int   strcomp( const char*, const char* ); // Compare ignoring case

#endif // ?_WIN32

#endif
