PROGRAM ttyprt;
{$m 49152,0,655360}
(*****************************************************************************
**
**  Author: Robert W. Bloom
**
**  Function:  This program outputs a file in TTY format (double-spaced, all
**             caps, 20 lines per page) with appropriate headers and footers
**             to a HP LaserJet, Qume Kiss, NEC Spinwriter, or ALPS P2000
**             printer.  It can read either a external ASCII or WordStar file,
**             or handle direct input.  Special WordStar formatting (high bits,
**             dot commands, etc) are handled correctly, but special commands
**             (tabs, fonts) are not.  Also handles the straight ASCII files
**             like can be output from Word Perfect and PC-Write.
**
**  Acknowledgement:  The original 'Le Message' was done by Mike Orlowicz who
**             did all the hard stuff with the NEC printer.  I converted the
**             original BASIC source to TurboPascal, added bells and
**             whistles, and added the formatting for other printers.
**
******************************************************************************)

USES printer,crt,dos;
CONST
{$define HPLJ}                  {should be HPLJ, NEC, KISS, or ALPS}
    Version='v3.6, 16 Jan 91';

{$ifdef HPLJ}
    TypPrt='HP LaserJet';      {'L' version for LaserJet w/OCR Font}
{$endif}
{$ifdef NEC}
    TypPrt='NEC w/OCR  ';      {'N' version for NEC SpinWriter w/OCR Thimble}
{$endif}
{$ifdef KISS}
    TypPrt='QMS Kiss   ';      {'K' version for Kiss w/OCR Cartridge}
{$endif}
{$ifdef ALPS}
    TypPrt='ALPS w/Crtg';      {'K' version for ALPS w/OCR Cartridge}
{$endif}
    Max_Lines_Page=20;         {number of lines per page}
    Max_Tty_Width=68;          {how wide is the TTY lines?}
    Max_Mfr_Width=132;         {how wide is the MFR lines?}
    Max_Tty_Length=400;        {max number of lines in a long tty (20 pages)}
    Max_MFR_Length=100;        {max number of lines in a long mfr}
    Max_Ed_Lines=500;          {max number of lines for mini-editor}
    End_Mark='!';              {end message mark}
    Sign_Line=53;              {line for signature block (NEC only)}
    Sign_Length=35;            {max length of signature block line}
    Bot_Class_Line=58;         {line for bottom classification (NEC only)}

{TYPED "CONSTANTS" -> used in HP LJ print positioning.  These are the defaults}
                               {if the SIG_BLKS.DAT file is not found}
    hp_lm : REAL = 6.1;        {left margin}
    hp_tm : REAL = 2.1;        {top margin - where top classification goes}
    hp_head : REAL = 5.2;      {absolute line number of the header line}
    hp_no : REAL = 7.2;        {absolute line number of the 'BOOK' field}
    hp_text : REAL = 8.7;      {absolute line number where text should start}
    hp_sign : REAL = 54.0;     {absolute line number of first signature line}
    hp_cl : REAL = 59.4;       {absolute line number of closing classification}
    sfn : STRING[30] = 'SAVEMSG.TTY';   {file to save to from mini-editor}
    rfn : STRING[30] = 'AUTOLOAD.MSG';  {file to read into mini-editor}
    ifn : STRING[30] = '';              {file to read into file input}
    bfn : STRING[30] = 'SIG_BLKS.DAT';  {signature blocks file name}
    hfn : STRING[30] = 'HELP_MSG.OVL';  {on-line help file name}
    ffn : STRING[30] = 'OCR-A.FNT';     {OCR soft font filename}
    sfid : INTEGER = 1776;              {softfont id number, a 'good' year}

TYPE
    FILE_STR=STRING[30];
    S10=STRING[10];
    S35=STRING[35];
    IO_FILE_TYPE=TEXT;
    SIG_BLK_REC=RECORD
         code : CHAR;
        line1 : S35;
        line2 : S35;
    END;

VAR
    tty : ARRAY [1..Max_Tty_Length] OF STRING[Max_Tty_Width]; {the whole message}
    mfr : ARRAY [1..Max_Mfr_Length] OF STRING[Max_Mfr_Width]; {possible MFR}
    sig_blk : ARRAY [1..50] OF SIG_BLK_REC; {preset signature blocks}
{   ed_text : ARRAY [1..Max_Ed_Lines] OF STRING[Max_Tty_Width]; 
       editor buffer - defined in procedure mini-ed due to space constraints}
    tot_tty_lines,tot_mfr_lines,        {number text, MFR lines}
    tot_pages,                          {number pages in message}
    cur_line, cur_page : INTEGER;       {current line, page}
    io_file : IO_FILE_TYPE;             {all files are text}
    start_page,end_page : INTEGER;      {printing limits}
    class : STRING[25];                 {classification}
    class_by,declass : S35;             {classified by, declassify lines}
    act_pred,info_pred : STRING[2];     {precedences}
    dtg : S10;                          {day time group}
    sign1,sign2 : S35;                  {signature block}
    mon_str : STRING[3];                {current month, three chars}
    yr_str : STRING[2];                 {current year, two digits}

(******************* Procedure List ******************************************)
FUNCTION menu : CHAR;                        FORWARD;
    PROCEDURE help_msg(subj:S10);            FORWARD;
    FUNCTION get_fn(c:CHAR) : S35;           FORWARD;
    FUNCTION open_fn(fn:FILE_STR) : BOOLEAN; FORWARD;
    FUNCTION get_line : STRING;              FORWARD;
    PROCEDURE load_font;                     FORWARD;
PROCEDURE mini_ed(restart:BOOLEAN);          FORWARD;
    PROCEDURE disp_dir;                      FORWARD;
    PROCEDURE chg_dir;                       FORWARD;
PROCEDURE read_ifn;                          FORWARD;
PROCEDURE get_hfaoi(EorF:CHAR);              FORWARD;
    PROCEDURE disp_msg;                      FORWARD;
PROCEDURE prt_msg(VAR ok : BOOLEAN);         FORWARD;
    PROCEDURE prt_header;                    FORWARD;
    PROCEDURE prt_body;                      FORWARD;
    PROCEDURE prt_sign;                      FORWARD;
    PROCEDURE prt_class;                     FORWARD;
PROCEDURE prt_mfr;                           FORWARD;
    PROCEDURE beep;                          FORWARD;

FUNCTION menu; { :char}
(*****************************************************************************
Initializes variables, asks for input file, gives help
Returns character selected
******************************************************************************)
LABEL help_loop,file_loop,file_menu;
VAR
    temp : STRING[132];
    i : INTEGER;
    c,opt : CHAR;    {menu selections}
BEGIN
help_loop:
    TextBackGround(Black); TextColor(LightGreen);
    WRITELN; WRITELN('Main Menu');
    TextColor(LightCyan);
    WRITELN; WRITE('Options:  ');
    TextColor(LightRed);  WRITE('F  ');
    TextColor(Cyan); WRITELN(#26,' To read message text from external WordStar or ASCII file');
    TextColor(LightRed);  WRITE('          E  ');
    TextColor(Cyan); WRITELN(#26,' To enter the message text directly with mini-editor');
{$ifdef HPLJ}
    TextColor(LightRed);  WRITE('          L  ');
    TextColor(Cyan); WRITELN(#26,' To load OCR-A softfont into printer memory');
{$endif}
    TextColor(LightRed);  WRITE('          D  ');
    TextColor(Cyan); WRITELN(#26,' Describe this program to me');
    TextColor(LightRed);  WRITE('          ?  ');
    TextColor(Cyan); WRITELN(#26,' Help!  Explain these options to me');
    TextColor(LightRed);  WRITE('       <esc> ');
    TextColor(Cyan); WRITELN(#26,' To exit TTYPRT without any further action');
    WRITELN;
    TextColor(Yellow);  WRITE('Waiting ');
    opt:=READKEY;
    WRITELN;
    CASE opt OF
    'e','E' : menu:='E';                    {input from keyboard into mini-editor}
    'H','?' : BEGIN                         {display help message}
                  help_msg('main');
                  clrscr;
                  GOTO help_loop
              END;
{$ifdef HPLJ}
    'L','l' : BEGIN                         {Load soft font}
                  load_font;
                  clrscr;
                  GOTO help_loop
              END;
{$endif}
    'D','d' : BEGIN                         {display help message}
                  help_msg('full');
                  clrscr;
                  GOTO help_loop
              END;
    'X',#27 : BEGIN                     {exit}
                  WRITELN; TextColor(Cyan);
                  WRITELN('TTYPRT completed, returning to DOS.');
                  halt
              END;
    'f','F' : BEGIN                         {input from file}
file_menu:
                  ClrScr;
                  TextColor(LightGreen); WRITELN('Input from external file');
                  WRITELN;
                  TextColor(LightCyan);   WRITE('    Options:   ');
                  TextColor(LightRed);  WRITE('*   ');
                  TextColor(Cyan); WRITELN(#26,' To display current file directory');
                  TextColor(LightRed);  WRITE('               .   ');
                  TextColor(Cyan); WRITELN(#26,' To change the current directory');
                  TextColor(LightRed);  WRITE('             <esc> ');
                  TextColor(Cyan); WRITELN(#26,' To exit back to main menu');
                  TextColor(LightRed);  WRITE('               ?   ');
                  TextColor(Cyan); WRITELN(#26,' Help!  Explain this to me');
                  TextColor(LightRed);  WRITE('             _____ ');
                  TextColor(Cyan); WRITELN(#26,' Filename to read');
file_loop:
                  WRITELN; TextColor(Yellow);
                  WRITE('Enter filename to use for message text (or other option) ',#26,' ');
                  c:=READKEY; TextBackground(Blue); TextColor(LightGray);
                  WRITE(c); TextBackground(Black);
                  CASE c OF
                  '*' : BEGIN
                            disp_dir;
                            GOTO file_loop
                        END;
                  '.' : BEGIN
                            chg_dir;
                            GOTO file_loop
                        END;
                  '?'  : BEGIN
                            help_msg('extread');
                            GOTO file_menu;
                        END;
                  ^M,#27 : BEGIN
                            clrscr;
                            GOTO help_loop;
                        END;
                  ELSE  BEGIN
                            ifn:=get_fn(c);
                            IF Length(ifn)=0 THEN BEGIN
                                TextBackground(Black); ClrScr;
                                GOTO help_loop;
                            END;
                            IF NOT open_fn(ifn) THEN BEGIN
                                beep; TextColor(LightMagenta+Blink);
                                WRITELN; WRITELN('File not found');
                                TextColor(Cyan);
                                GOTO file_loop
                            END;
                            menu:='F'
                        END
                  END {case}
              END;
    ELSE      BEGIN                         {beep if anything else}
                  beep;
                  GOTO help_loop
              END
    END {case}
END; {FUNCTION menu}

PROCEDURE read_ifn;
(*****************************************************************************
Reads entire message, counts lines, checks for overlong lines, aborts if so.
******************************************************************************)
VAR
    ln_2_long,end_text : BOOLEAN;
    c : CHAR;          {char to read from file}
    tmpstr : STRING[132];  {line to read}
    lc : BYTE;      {line count}
BEGIN
    WRITELN; TextColor(Cyan);
    WRITELN('reading and checking file for length ... ');
    lc:=1; end_text:=FALSE; ln_2_long:=FALSE;
    WHILE (NOT EOF(io_file)) AND (NOT end_text) AND (lc<=Max_Tty_Length) DO BEGIN
        TextColor(Cyan); WRITE(^M'reading line ',lc);
        tmpstr:=get_line;
        IF (LENGTH(tmpstr)>0) AND (tmpstr[1]<>'.') THEN BEGIN
            {don't save blank lines or dot commands}
            IF tmpstr[1]='!' THEN
                end_text:=TRUE           {end of text section}
            ELSE IF LENGTH(tmpstr)>Max_Tty_Width THEN BEGIN
                ln_2_long:=TRUE;
                TextColor(Cyan); WRITELN(^M'Line ',lc:2,' too long:');
                TextColor(LightGray); WRITELN(' -> ',tmpstr);
                lc:=lc+1
            END ELSE BEGIN
                tty[lc]:=tmpstr;
                tty[lc][0]:=tmpstr[0];   {match actual lengths}
                lc:=lc+1
            END
        END
    END; {while}
    tot_tty_lines:=lc-1;

    lc:=1; tmpstr:='';
    WRITELN; TextColor(Cyan);
    WRITELN('Reading MFR, if any');
    WHILE (NOT EOF(io_file)) AND (NOT ln_2_long) AND (lc<=Max_Tty_Length) DO BEGIN
        TextColor(Cyan); WRITE(^M'reading line ',lc);
        tmpstr:=get_line;
        IF tmpstr[1]<>'.' THEN BEGIN        {don't save dot commands}
            mfr[lc]:=tmpstr;
            mfr[lc][0]:=tmpstr[0];
            lc:=lc+1
        END
    END; {while}
    CLOSE(io_file);
    tot_mfr_lines:=lc-1;                     {total number of lines in mfr}
    WRITELN;

    IF lc>Max_Tty_Length THEN BEGIN
        beep; TextColor(LightMagenta+Blink);
        WRITELN(^M'Message is longer than ',Max_Tty_Length,' lines.');
        TextColor(LightMagenta);
        WRITELN('TTYPRT cannot handle a message that long.  Please split up and');
        WRITELN('send as two (or more) separate messages.');
        TextColor(Yellow);
        WRITELN; WRITE('Strike any key to return to DOS ');
        c:=READKEY;
        halt
    END;
    IF ln_2_long THEN BEGIN
        beep; TextColor(LightMagenta);
        WRITELN(^M'One or more lines are overlong.  Switching input to');
        WRITELN('TTYPRT''s mini-editor.  Please correct lines as necessary.');
        WRITELN; TextColor(Yellow);
        WRITE('Strike <esc> to abort or any other key to continue on to mini-editor.');
        c:=READKEY;
        WRITELN;
        IF c=#27 THEN halt;
        rfn:=ifn;
        mini_ed(FALSE);
    END
END; {PROCEDURE read_ifn;}

{$i util.pas}             {utility procedures}
{$i hfaoi.pas}            {get Header, Footer And Output Information}
{$i out_proc.pas}         {output procedures and printer-specific stuff}
{$i mini_ed.pas}          {mini_editor with other sub-procedures}

(******************* Main Program ********************************************)
VAR
    prt_ok : BOOLEAN;
    i : INTEGER;
    select: CHAR;
BEGIN
    TextBackground(Black); TextColor(Green); ClrScr;
    GOTOXY(24, 1); WRITE('ͻ');
    GOTOXY(24, 2); WRITE('                               ');
    GOTOXY(24, 3); WRITE('                               ');
    GOTOXY(24, 4); WRITE('                               ');
    GOTOXY(24, 5); WRITE('͹');
    GOTOXY(24, 6); WRITE('                               ');
    GOTOXY(24, 7); WRITE('                               ');
    GOTOXY(24, 8); WRITE('                               ');
    GOTOXY(24, 9); WRITE('                               ');
    GOTOXY(24,10); WRITE('                               ');
    GOTOXY(24,11); WRITE('ͼ');
    TextColor(Yellow);
    GOTOXY(31, 2); WRITE('T T Y   P R I N T !');
    TextColor(Cyan);
    GOTOXY(33, 3); WRITE(version);
    GOTOXY(31, 4); WRITE('Printer: ');
    TextBackground(Blue); TextColor(LightGray); WRITE(TypPrt);
    TextBackground(Black); TextColor(Cyan);
    GOTOXY(29, 7); WRITE('Formats and prints files');
    GOTOXY(34, 8); WRITE('for a DD173/2');
    GOTOXY(31, 9); WRITE('(Joint Messageform)');
    GOTOXY( 9,12);
    tot_tty_lines:=0; tot_mfr_lines:=0;
    FOR i:=1 TO Max_Tty_Length DO tty[i]:='';   {clear msg buffer}
    FOR i:=1 TO Max_Mfr_Length DO mfr[i]:='';   {clear mfr buffer}
    IF paramcount=0 THEN BEGIN          {any filename on command line?}
        ifn:='';                        {no, so zero it}
        select:=menu                    {and get char from menu}
    END ELSE BEGIN
        ifn:=ParamStr(1);               {yes, filename given on command line}
        IF NOT open_fn(ifn) THEN BEGIN      {so open it}
            beep; TextColor(LightMagenta+Blink);
            WRITELN('Filename given on command line not found');
            TextColor(Cyan);
            select:=menu                {if not openable, ask!}
        END ELSE BEGIN
            select:=' ';                 {non-menu selection}
            read_ifn                    {and read it}
        END
    END;

    CASE select OF
       'E' : mini_ed(FALSE);            {goto mini editor}
       'F' : read_ifn;                  {read input file if so stated}
    {else, file given on command line and read successfully}
    END; {case}
    get_hfaoi(select);                  {get the header/footer/output info}
    prt_msg(prt_ok);                    {and print it}
    WRITELN;
    IF (cur_page<=end_page) AND prt_ok AND (tot_mfr_lines>0) THEN prt_mfr;
                                        {and mfr if printing all}
    WRITELN; TextColor(Cyan);
    WRITELN('TTYPrt completed.')        {all done}
END. {program}
