

;              ciforth : a generic I86 ISO FORTH by HCC FIG

; $Id: ci86.gnr,v 4.15.3.1 2003/09/04 18:09:50 albert Exp $
; Copyright (2000): Albert van der Horst by GNU Public License
;
;HCC FIG Holland : Hobby Computer Club, Forth Interest Group  Holland
        ;  66,106
 ;   ciforth $Revision: 4.15.3.1 $
;
; For the generic system (to generate ciforth in an other configuration than this one):
;     http://home.hccnet.nl/a.w.m.van.der.horst/ci86gnr.html
;
; If this is a configured assembly file, it should be accompanied with configured
; documentation (texinfo, ps, html.)
; WITHOUT THE DOCUMENTATION: GIVE UP! GET THE REAL THING!
; You have a configured system, if there are NO curly brackets on the next line.
;                          
;
; Configuration of this particular version:
; 16-bits real mode  
; running under MSDOS
; with modern MSDOS I/O  
  
; Normally ciforth doesn't observe ISO >IN.
; Contains :
; (there may be no items here.)
;        Security words
;         Loadable words, i.e. all of ISO CORE, more than is needed
;           for a self contained kernel.
; A field in the header to point to source
;
 ;
; This is a NASM version of ciforth created by ``m4'' from the generic listing.
; It can be assembled using ``nasm'' obtainable via :
; Source: ftp://ftp.us.kernel.org/pub/software/devel/nasm/source/
; URL: http://www.cryogen.com/Nasm/

; This version can be assembled on a Linux system in behalf of a
; MS-DOS   version by
;   nasm -fbin ciforth.asm -o ciforth.com
; For assembling on other systems where nasm is available see the
; documentation of nasm.

%if 0
        A generic version of ISO FORTH for IBM type standard PC's by
                Albert van der Horst

                in cooperation with
                HCC Forth user group
                The Netherlands
                www.forth.hccnet.nl

              based on
              FIG-FORTH
   implemented by:  Charlie Krajewski
                    205 ( BIG ) Blue Rd.
                    Middletown, CT  06457

  The listing has been made possible by the
  prior work of:
               Thomas Newman, Hayward, Ca.

 : other_acknowledgements
         John_Cassidy
         Kim_Harris
         George_Flammer
         Robert_D._Villwock ;

 : for tools
         Richard M. Stallman
         Linus Torvalds

No one who programs with FORTH can afford to be without:
  "Starting Forth  by Leo Brodie" and "Thinking Forth by Leo Brodie".
   Both out of print.

This Forth is a descendant in the 300+ (RCS)- generations from fig-Forth.

For nostalgic reasons the following comment has never been removed:
   Although there is much to be said for typing in your own
   listing and getting it running, there is much to be said
   not typing in your own listing.  If you feel that 100+
   pages of plinking is nutty, contact me for availability
   of a disc with source & executable files.  Obtainable at
   a bargain basement price, prepare yourself for bargain
   basement support.

All publications of the FORTH Interest Group are public domain.
They may be further distributed by the inclusion of this
credit notice:
               This publication has been made available by:

               FORTH Interest Group
               P.O. Box 1105
               San Carlos, Ca.  94070
[I feel obliged to keep this last one in (AH). Note that although it is
based on fig-Forth no stone is left unturned.]
%endif
        ;
; ########################################################################################
;                       PREPARATION (no code)
; ########################################################################################
FIGREL  EQU     4       ; FIG RELEASE #
FIGREV  EQU     0       ; FIG REVISION #
USRVER  EQU     0      ; USER VERSION NUMBER, a digit now
;
;      VERY ELEMENTARY .
CW      EQU     2    ; Size of a cell in Forth, not in the bootcode.
ERRORSCREEN EQU     48    ; Screen where the error messages start.
;
;      MEMORY LAYOUT.
; Normally this is specified at the m4 configuration level.
; For a configured system these values can be changed at this single place. 
NBUF    EQU     8    ; No. of buffers, or screens 
KBBUF   EQU     1024      ; Data bytes per disk buffer
US      EQU     40H*CW  ; User variable space
EM      EQU     10000H     ; Where the memory ends w.r.t. ORIG.
EMP     EQU     (EM-1)/1000H+1 ; Number of pages.
RTS     EQU     0100H    ; Return stack & terminal input buffer
;

;
;      ASCII CHARACTER EQUIVALENTS
;
ABL     EQU     ' '     ; SPACE
ACR     EQU     0DH     ; CR
ASO     EQU     '['     ; SQUARE BRACKET OPEN 
ASC     EQU     ']'     ; SQUARE BRACKET CLOSE 
ADOT    EQU     '.'     ; PERIOD
ALF      EQU     0AH     ; LINE FEED, USED INTERNALLY AS
                        ; LINE ENDER
AFF      EQU     0CH     ; FORM FEED
BELL    EQU     07H     ; ^G
BSIN    EQU     08H     ; INPUT DELETE CHARACTER
BSOUT   EQU     08H     ; OUTPUT BACKSPACE ( ^H )
;
;      HEADER RELATED EQUATES
B_DUMMY   EQU     01H     ; dea is dummy, from vocabulary link
B_INVIS   EQU     02H     ; dea is invisible, "smudged".
B_IMMED   EQU     04H     ; dea is a immediate.
B_DENOT   EQU     08H     ; dea is a denotation.
C_HOFFSET EQU     0       ; Offsets of code field in cells, w.r.t. dea
D_HOFFSET EQU     1       ; Same for data field
F_HOFFSET EQU     2       ; Same for flag field
L_HOFFSET EQU     3       ; Same for link field
N_HOFFSET EQU     4       ; Same for name field
S_HOFFSET EQU     5       ; Same for source field
PH_OFFSET EQU     6   ; Past header field: Start of data area. 
BD_OFFSET EQU     6+1 ; Start of BODY for CREATEd word.
;


BUF1    EQU     EM-(KBBUF+2*2)*NBUF      ; FIRST DISK BUFFER
STRUSA  EQU     BUF1-US         ; User area
 ;  
; 

STRTIB  EQU     STRUSA-RTS      ; Start return stack area
                                ; Under this : data stack
INITR0  EQU     STRUSA         ; Grows down
INITS0  EQU     STRTIB          ; Grows down
 ;  

;

;

BPS     EQU     512             ;Bytes/sector, common to all of MSDOS
SPB     EQU     KBBUF/BPS
;
;

;
;

;
; 

; 

create  EQU     3C00H
open    EQU     3D00H
close   EQU     3E00H
read    EQU     3F00H
write   EQU     4000H
delete  EQU     4100H
lseek   EQU     4200H
; 

; 

; ########################################################################################
;                      BOOTCODE    (optional, always real mode)
; ########################################################################################

; All bootcode must be relocatable and its memory references absolute.
; Not for the sake of booting, but to allow MSDOS to start the program too. 

        ;    SEGMENT PARA PUBLIC 'CODE'
        ; CS:;,DS:;,SS:;,ES:;
    
    
ORG0:

; 

; 
; 
NOBOOT:         ; Skip till here if not booting.

; 
ENDBOOT:

; ########################################################################################
;                       ADJUST CODE SEGMENT REGISTER (still real mode)
; ########################################################################################
; Required start of .COM program.

           ORG     100H
ORIG:                         ; Accommodate also .exe files  
       MOV     BX, (EM-1)/10H+1
        MOV     AH,4Ah              ;Modify memory allocation
        INT     21h 
 
; ########################################################################################
;                       MOVE CODE TO ITS PLACE (still real mode)
; ########################################################################################
;
; ########################################################################################
;                       FILL GDT AND SWITCH TO PROTECTED MODE/32 BITS (optional)
; ########################################################################################
; 


        PUSH    DS
        MOV     AX,0
        MOV     DS,AX
        LEA     AX,[WARM_ENTRY]
        LEA     BX,[4*23H]
        MOV     [BX],AX         ;Jump to WARM_ENTRY on <CTRL-BREAK>
        INC     BX
        INC     BX
        MOV     AX,CS
        MOV      WORD[BX], AX
        POP     DS
ENDREADJUST:
 ;  
; 

; 
; ########################################################################################
;                       PREPARE FOR USING DPMI (OPTIONAL)
; ########################################################################################
;

        MOV     [LOADEXEC+4], DS
        MOV     [LOADEXEC+8], DS
        MOV     [LOADEXEC+12], DS

;Must be done before switching to protected mode.
        MOV     AX, [ES:2CH]
        MOV     [USINI+(CW*(31))],AX   ;Remember ENV pointer.
        MOV     [LOADEXEC], AX
 ; 

;

; 

; ########################################################################################
;                       FORTH GLUE CODE (optional, except for the jump)
; ########################################################################################

;

;
COLD_ENTRY:
        CLD                     ; DIR = INC

        MOV     AX,DS
        MOV     SS,AX           ;Atomic with next instruction.
        MOV     SP, WORD[USINI+(CW*(2))]    ;PARAM. STACK
        MOV     BP, WORD[USINI+(CW*(3))]    ;RETURN STACK
        MOV     SI, CLD1  ; (IP) <-
        JMP     NEXT
;
CLD1:   DW      COLD    ;  This is a piece of headerless high level code.
;
; ########################################################################################
;                       FORTH ITSELF (entry point : BOOTUP)
; ########################################################################################
;
%if 0
   FORTH REGISTERS
   The names under FORTH are used in the generic source.

   FORTH   8088     FORTH PRESERVATION RULES
   -----   ----     ----- ------------ -----
   HIP   SI      High level Interpreter Pointer.  Must be preserved
                    across FORTH words.

   WOR   BX      Working register.  When entering a word
                    via its code field the DEA is passed in WOR.

   SPO   SP      Parameter stack pointer.  Must be preserved
                    across FORTH words.

   RPO   BP      Return stack pointer.  Must be preserved across
                    FORTH words.

            AX      General register.  Used to pass data from
                    FORTH words, see label APUSH or macro _APUSH

            DX      General register.  Used to pass more data from
                    FORTH words, see label DPUSH or macro _DPUSH

            BX      General purpose register.

            CX      General purpose register.

            CS      Segment register. Must be preserved
                    across FORTH words.

            DS      ditto

            SS      ibid

            ES      Temporary segment register only used by
                    a few words. However it MUST remain equal to
                    DS, such that string primitives can be used
                    with impunity.

----------------------------------------------------------
%endif
        ;
%if 0
---------------------------------------------

   COMMENT CONVENTIONS
   ------- -----------

   =       IS EQUAL TO
   <-      ASSIGNMENT

  NAME        =  Address of name
  (NAME)      =  Contents of name

  CFA         =  CODE FIELD ADDRESS : a pointer to executable code
  DFA         =  DATA FIELD ADDRESS : a pointer to
                        data/high level code/ DOES> pointer
  FFA         =  FLAG FIELD ADDRESS: contains flags
  LFA         =  LINK FIELD ADDRESS: a pointer
  NFA         =  NAME FIELD ADDRESS: a pointer to a variable number of chars
  PHA         =  POST HEADER ADDRESS

  S1          =  Parameter stack - 1st cell
  S2          =  Parameter stack - 2nd cell
  R1          =  Return stack    - 1st cell
  R2          =  Return stack    - 2nd cell

  LSB         =  Least significant bit
  MSB         =  Most  significant bit
  LB          =  Low byte
  HB          =  High byte
  LW          =  Low  cell

------------------------------------------------------------
%endif
; 
        ;

; 
; 
;
; 
; In 32 bit versions there may be no jumps to NEXT at all 
; The label NEXT1 is rarely relevant (for _OLDDEBUG_) 
DPUSH:  PUSH    DX      ; Fall through.
APUSH:  PUSH    AX
NEXT:
;
        LODSW           ;AX <- (IP)
NEXT1:  MOV     BX,AX   ; (WOR) <- (IP)

        JMP      WORD[BX]    ; TO `CFA'
;
;       Dictionary starts here.

DP0:
; Vocabularies all end in a link to 0.
; Only the word FORTH links to the DENOTATION wordlist,
; that in turn links to 0.


;  *********
;  *   '   *
;  *********
;
N_TICK:   DW      1
        DB      "'"
TICK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    0
        DW    N_TICK
    DW    0

        DW      ITICK
        DW      LITER
        DW      SEMIS
;

;  *********
;  *   &   *
;  *********
;
N_DCHAR:   DW      1
        DB      "&"
DCHAR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    TICK-(CW*(C_HOFFSET))
        DW    N_DCHAR
    DW    0

        DW      INBRS
        DW      SWAP, DROP
        DW      LDUP, QBL
        DW      LIT, 10, QERR
        DW      LITER
        DW      QDELIM
        DW      SEMIS
;

;  *********
;  *   ^   *
;  *********
;
N_DCTL:   DW      1
        DB      "^"
DCTL:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DCHAR-(CW*(C_HOFFSET))
        DW    N_DCTL
    DW    0

        DW      INBRS
        DW      SWAP, DROP
        DW      LDUP, QBL
        DW      LIT, 10, QERR
        DW      LIT, '@', LSUB
        DW      LITER
        DW      QDELIM
        DW      SEMIS
;

;  *********
;  *   0   *
;  *********
;
N_DEN0:   DW      1
        DB      "0"
DEN0:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DCTL-(CW*(C_HOFFSET))
        DW    N_DEN0
    DW    0

;  *********
;  *   1   *
;  *********
;
N_DEN1:   DW      1
        DB      "1"
DEN1:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN0-(CW*(C_HOFFSET))
        DW    N_DEN1
    DW    0

;  *********
;  *   2   *
;  *********
;
N_DEN2:   DW      1
        DB      "2"
DEN2:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN1-(CW*(C_HOFFSET))
        DW    N_DEN2
    DW    0

;  *********
;  *   3   *
;  *********
;
N_DEN3:   DW      1
        DB      "3"
DEN3:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN2-(CW*(C_HOFFSET))
        DW    N_DEN3
    DW    0

;  *********
;  *   4   *
;  *********
;
N_DEN4:   DW      1
        DB      "4"
DEN4:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN3-(CW*(C_HOFFSET))
        DW    N_DEN4
    DW    0

;  *********
;  *   5   *
;  *********
;
N_DEN5:   DW      1
        DB      "5"
DEN5:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN4-(CW*(C_HOFFSET))
        DW    N_DEN5
    DW    0

;  *********
;  *   6   *
;  *********
;
N_DEN6:   DW      1
        DB      "6"
DEN6:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN5-(CW*(C_HOFFSET))
        DW    N_DEN6
    DW    0

;  *********
;  *   7   *
;  *********
;
N_DEN7:   DW      1
        DB      "7"
DEN7:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN6-(CW*(C_HOFFSET))
        DW    N_DEN7
    DW    0

;  *********
;  *   8   *
;  *********
;
N_DEN8:   DW      1
        DB      "8"
DEN8:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN7-(CW*(C_HOFFSET))
        DW    N_DEN8
    DW    0

;  *********
;  *   9   *
;  *********
;
N_DEN9:   DW      1
        DB      "9"
DEN9:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN8-(CW*(C_HOFFSET))
        DW    N_DEN9
    DW    0

;  *********
;  *   A   *
;  *********
;
N_DENA:   DW      1
        DB      "A"
DENA:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN9-(CW*(C_HOFFSET))
        DW    N_DENA
    DW    0

;  *********
;  *   B   *
;  *********
;
N_DENB:   DW      1
        DB      "B"
DENB:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENA-(CW*(C_HOFFSET))
        DW    N_DENB
    DW    0

;  *********
;  *   C   *
;  *********
;
N_DENC:   DW      1
        DB      "C"
DENC:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENB-(CW*(C_HOFFSET))
        DW    N_DENC
    DW    0

;  *********
;  *   D   *
;  *********
;
N_DEND:   DW      1
        DB      "D"
DEND:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENC-(CW*(C_HOFFSET))
        DW    N_DEND
    DW    0

;  *********
;  *   E   *
;  *********
;
N_DENE:   DW      1
        DB      "E"
DENE:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEND-(CW*(C_HOFFSET))
        DW    N_DENE
    DW    0

;  *********
;  *   F   *
;  *********
;
N_DENF:   DW      1
        DB      "F"
DENF:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENE-(CW*(C_HOFFSET))
        DW    N_DENF
    DW    0

;

;  *********
;  *   -   *
;  *********
;
N_DENM:   DW      1
        DB      "-"
DENM:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DENF-(CW*(C_HOFFSET))
        DW    N_DENM
    DW    0

        DW      PNUMB, DNEGA, SDLITE
        DW      SEMIS
;

;  *********
;  *   +   *
;  *********
;
N_DENP:   DW      1
        DB      "+"
DENP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DENM-(CW*(C_HOFFSET))
        DW    N_DENP
    DW    0

        DW      PNUMB, SDLITE
        DW      SEMIS
;

;  *********
;  *   "   *
;  *********
;
N_DENQ:   DW      1
        DB      '"'
DENQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DENP-(CW*(C_HOFFSET))
        DW    N_DENQ
    DW    0

        DW      LIT, SKIP, COMMA        ;  'SKIP , HERE >R 0 ,
        DW      HERE, TOR, ZERO, COMMA
DENQ1:
        DW      LIT, '"', PPARS         ;           BEGIN &" (PARSE)
        DW      INBRS, LDUP, LIT, '"', EQUAL ;           IN[] DUP &" =
        DW      ZBRAN
        DW      DENQ2-$-CW                 ;           WHILE
        DW      TDROP, ONEP             ;           2DROP 1+ R@ $+!
        DW      LDUP, ALLOT, RR, SADD
        DW      BRAN
        DW      DENQ1-$-CW                  ;           REPEAT
DENQ2:
        DW      QBL, ZEQU
        DW      LIT, 10, QERR           ;           ?BLANK 0= 5 ?ERROR
        DW      DROP                    ;                DROP R@ $+!
        DW      LDUP, ALLOT, RR, SADD
        DW      FROMR, SFET, DLITE      ;           R> $@ POSTPONE DLITERAL ;
        DW      SEMIS
;

; The FORTH vocabulary is the only one not to link to zero.
; It links to the DENOTATION vocabulary.
;  *************
;  *   FORTH   *
;  *************
;
N_FORTH:   DW      5
        DB      "FORTH"
FORTH:        DW    DODOE
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DENOTBODY 
        DW    N_FORTH
    DW    0

        DW      DOVOC
        DW      0       ; END OF VOCABULARY LIST

        DW    0H
        DW    0
        DW    B_DUMMY
        DW    TASK-(CW*(C_HOFFSET))
        DW    0
    DW    0

;
;

;  ************
;  *   CORE   *
;  ************
;
N_CORE:   DW      4
        DB      "CORE"
CORE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    0
        DW    N_CORE
    DW    0

        DW      ZERO    ; Not (fully) present.
        DW      SEMIS
;

;  ***********
;  *   CPU   *
;  ***********
;
N_LCPU:   DW      3
        DB      "CPU"
LCPU:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CORE-(CW*(C_HOFFSET))
        DW    N_LCPU
    DW    0

; 

       DW      LIT, 0B328H, LIT, 5H      ; '8088'     
 
        DW      SEMIS
;

;  ***************
;  *   VERSION   *
;  ***************
;
N_LVERSION:   DW      7
        DB      "VERSION"
LVERSION:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LCPU-(CW*(C_HOFFSET))
        DW    N_LVERSION
    DW    0

%if 0
;       If this is there it is an official release
        DW      SKIP
        DW      22
IBMPC:  DB      'IBM-PC ciforth'
        DB      FIGREL+40H,ADOT,FIGREV+30H,ADOT,USRVER+30H
        DW      LIT, IBMPC, LIT, 22
%endif
;       If M4_VERSION exists and contains a . it is an official release
        DW      SKIP
         DW      5
SB0: DB      "4.0.3"
       
        DW      LIT, SB0
        DW      LIT, 5
        DW      SEMIS
;

;  ************
;  *   NAME   *
;  ************
;
N_LNAME:   DW      4
        DB      "NAME"
LNAME:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LVERSION-(CW*(C_HOFFSET))
        DW    N_LNAME
    DW    0

        DW      SKIP
         DW      7
SB1: DB      "ciforth"
       
        DW      LIT, SB1
        DW      LIT, 7
        DW      SEMIS
;

;  ****************
;  *   SUPPLIER   *
;  ****************
;
N_SUPPLIER:   DW      8
        DB      "SUPPLIER"
SUPPLIER:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LNAME-(CW*(C_HOFFSET))
        DW    N_SUPPLIER
    DW    0

        DW      SKIP
         DW      20
SB2: DB      "Albert van der Horst"
       
        DW      LIT, SB2
        DW      LIT, 20
        DW      SEMIS
;
;

;  ******************
;  *   DENOTATION   *
;  ******************
;
N_DENOT:   DW      10
        DB      "DENOTATION"
DENOT:        DW    DODOE
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    FORTH
        DW    N_DENOT
    DW    0

        DW      DOVOC
        DW      FORTH-(CW*(C_HOFFSET))     ; NEXT VOCABULARY 
DENOTBODY:

        DW    0H
        DW    0
        DW    B_DUMMY
        DW    DENQ-(CW*(C_HOFFSET))
        DW    0
    DW    0

;

;  *******************
;  *   ENVIRONMENT   *
;  *******************
;
N_ENV:   DW      11
        DB      "ENVIRONMENT"
ENV:        DW    DODOE
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DENOT-(CW*(C_HOFFSET))
        DW    N_ENV
    DW    0

        DW      DOVOC
        DW      DENOT-(CW*(C_HOFFSET))       ; NEXT VOCABULARY 

        DW    0H
        DW    0
        DW    B_DUMMY
        DW    SUPPLIER-(CW*(C_HOFFSET))
        DW    0
    DW    0

;

;  ************
;  *   NOOP   *
;  ************
;
N_NOOP:   DW      4
        DB      "NOOP"
NOOP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ENV-(CW*(C_HOFFSET))
        DW    N_NOOP
    DW    0

       JMP     NEXT
;
; 
;

;  ***********
;  *   LIT   *
;  ***********
;
N_LIT:   DW      3
        DB      "LIT"
LIT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    NOOP-(CW*(C_HOFFSET))
        DW    N_LIT
    DW    0

        LODSW           ; AX <- LITERAL
        JMP     APUSH          ; TO TOP OF STACK
;

;  ***************
;  *   EXECUTE   *
;  ***************
;
N_EXEC:   DW      7
        DB      "EXECUTE"
EXEC:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LIT-(CW*(C_HOFFSET))
        DW    N_EXEC
    DW    0

        POP     BX      ; GET XT
        JMP      WORD[BX + (CW*(C_HOFFSET))]  ;(IP) <- (PFA)
;


;  ***************
;  *   RECURSE   *
;  ***************
;
N_RECURSE:   DW      7
        DB      "RECURSE"
RECURSE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    EXEC-(CW*(C_HOFFSET))
        DW    N_RECURSE
    DW    0

        DW      LATEST, COMMA
        DW      SEMIS
;
;

;  **************
;  *   BRANCH   *
;  **************
;
N_BRAN:   DW      6
        DB      "BRANCH"
BRAN:        DW    (SKIP+(CW*(PH_OFFSET-C_HOFFSET)))
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RECURSE-(CW*(C_HOFFSET))
        DW    N_BRAN
    DW    0

;

;  ************
;  *   SKIP   *
;  ************
;
N_SKIP:   DW      4
        DB      "SKIP"
SKIP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BRAN-(CW*(C_HOFFSET))
        DW    N_SKIP
    DW    0

BRAN1:  LODSW
        ADD     SI,AX
        JMP     NEXT
;

;  ***************
;  *   0BRANCH   *
;  ***************
;
N_ZBRAN:   DW      7
        DB      "0BRANCH"
ZBRAN:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SKIP-(CW*(C_HOFFSET))
        DW    N_ZBRAN
    DW    0

        POP     AX      ; GET STACK VALUE
        OR      AX,AX   ; ZERO?
        JZ      BRAN1   ; YES, BRANCH
        LEA     SI,[SI+(CW*(1))]
        JMP     NEXT
;
;

;  **************
;  *   (LOOP)   *
;  **************
;
N_XLOOP:   DW      6
        DB      "(LOOP)"
XLOOP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ZBRAN-(CW*(C_HOFFSET))
        DW    N_XLOOP
    DW    0

        MOV     BX,1    ; INCREMENT
XLOO1:  ADD     [BP],BX ; INDEX = INDEX + INCR
        MOV     AX,[BP] ; GET NEW INDEX
        SUB     AX,[BP+(CW*(1))]        ; COMPARE WITH LIMIT
        XOR     AX,BX   ; TEST SIGN
        JS      BRAN1   ; KEEP LOOPING
;
;  END OF `DO' LOOP
        LEA     BP,[BP+(CW*(3))]  ; ADJ RETURN STACK
        LEA     SI,[SI+(CW*(1))]       ; BYPASS BRANCH OFFSET
        JMP     NEXT
;

;  ***************
;  *   (+LOOP)   *
;  ***************
;
N_XPLOO:   DW      7
        DB      "(+LOOP)"
XPLOO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XLOOP-(CW*(C_HOFFSET))
        DW    N_XPLOO
    DW    0

        POP     BX      ; GET LOOP VALUE
        JMP SHORT     XLOO1
        JMP     NEXT           ;Helpfull for disassembly.
;

;  ************
;  *   (DO)   *
;  ************
;
N_XDO:   DW      4
        DB      "(DO)"
XDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XPLOO-(CW*(C_HOFFSET))
        DW    N_XDO
    DW    0

        LODSW
        ADD     AX,SI  ;Make absolute
        POP     DX      ; INITIAL INDEX VALUE
        POP     BX      ; LIMIT VALUE
        XCHG    BP,SP   ; GET RETURN STACK
        PUSH    AX      ; Target location.
        PUSH    BX
        PUSH    DX
        XCHG    BP,SP   ; GET PARAMETER STACK
        JMP     NEXT
;

;  *************
;  *   (?DO)   *
;  *************
;
N_XQDO:   DW      5
        DB      "(?DO)"
XQDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XDO-(CW*(C_HOFFSET))
        DW    N_XQDO
    DW    0

        LODSW
        ADD     AX,SI  ;Make absolute
        POP     DX      ; INITIAL INDEX VALUE
        POP     BX      ; LIMIT VALUE
        CMP     DX,BX
        JZ      QXDO1
        XCHG    BP,SP   ; GET RETURN STACK
        PUSH    AX      ; Target location.
        PUSH    BX
        PUSH    DX
        XCHG    BP,SP   ; GET PARAMETER STACK
        JMP     NEXT
QXDO1:  MOV     SI,AX
        JMP     NEXT
;

;  *********
;  *   I   *
;  *********
;
N_IDO:   DW      1
        DB      "I"
IDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XQDO-(CW*(C_HOFFSET))
        DW    N_IDO
    DW    0

        MOV     AX,[BP] ; GET INDEX VALUE
        JMP     APUSH          ; TO PARAMETER STACK
;

;  *********
;  *   J   *
;  *********
;
N_JDO:   DW      1
        DB      "J"
JDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    IDO-(CW*(C_HOFFSET))
        DW    N_JDO
    DW    0

        MOV     AX,[BP+(CW*(3))] ; GET INDEX VALUE
        JMP     APUSH          ; TO PARAMETER STACK
;

;  **************
;  *   UNLOOP   *
;  **************
;
N_UNLOOP:   DW      6
        DB      "UNLOOP"
UNLOOP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    JDO-(CW*(C_HOFFSET))
        DW    N_UNLOOP
    DW    0

        DW      LIT, RDROP, COMMA
        DW      LIT, RDROP, COMMA
        DW      LIT, RDROP, COMMA
        DW      SEMIS
;

;  ***************
;  *   +ORIGIN   *
;  ***************
;
N_PORIG:   DW      7
        DB      "+ORIGIN"
PORIG:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    UNLOOP-(CW*(C_HOFFSET))
        DW    N_PORIG
    DW    0

        DW      LIT
        DW      USINI
        DW      PLUS
        DW      SEMIS
;
;      Initialisation block for user variables through DOC-LINK
;       <<<<< must be in same order as user variables >>>>>
;
;        DW      WARM_ENTRY FIXME
;        DW      COLD_ENTRY
USINI:  DW      STRUSA  ; User area currently in use, cold value same as next.
        DW      STRUSA  ; INIT (U0) user area of the main task 1
        DW      INITS0  ; INIT (S0)         2
        DW      INITR0  ; INIT (R0)         3
        DW      STRTIB  ; INIT (TIB)        4
        DW      BSIN    ; RUBOUT: get rid of latest char 5
        DW      0       ; AVAILABLE         6
        DW      1       ; INIT (WARNING)     7
        DW      INITDP  ;      INIT (FENCE)  8
DPA:    DW      INITDP  ;      INIT (DP)     9
        DW      ENV-(CW*(C_HOFFSET)) ;       INIT (VOC-LINK) 10
;

        DW      0       ; INIT (OFFSET) 
;
;
;
;
;
        DW      0, 0            ; WHERE             12 13 
        DW      0, STRTIB       ;REMAINDER   14 15 
; 
        RESB    US-($ - USINI)        ; All user can be initialised.
;
;      <<<<< end of data used by cold start >>>>>

;  *************
;  *   DIGIT   *
;  *************
;
N_DIGIT:   DW      5
        DB      "DIGIT"
DIGIT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PORIG-(CW*(C_HOFFSET))
        DW    N_DIGIT
    DW    0

        POP     DX      ;NUMBER BASE
        POP     AX      ;ASCII DIGIT
        SUB     AL,'0'
        JB      DIGI2   ;NUMBER ERROR
        CMP     AL,9
        JBE     DIGI1   ;NUMBER = 0 THRU 9
        SUB     AL,7
        CMP     AL,10   ;NUMBER 'A' THRU 'Z'?
        JB      DIGI2   ;NO
DIGI1:  CMP     AL,DL   ; COMPARE NUMBER TO BASE
        JAE     DIGI2   ;NUMBER ERROR
        SUB     DX,DX   ;ZERO
        MOV     DL,AL   ;NEW BINARY NUMBER
        MOV     AL,1    ;TRUE FLAG
        NEG     AX
        JMP     DPUSH          ;ADD TO STACK
;   NUMBER ERROR
DIGI2:  SUB     AX,AX   ;FALSE FLAG
        JMP     DPUSH
;

;  ***************
;  *   (MATCH)   *
;  ***************
;
N_PMATCH:   DW      7
        DB      "(MATCH)"
PMATCH:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DIGIT-(CW*(C_HOFFSET))
        DW    N_PMATCH
    DW    0

        DW      TOR
        DW      RR, TFFA, FETCH
        DW      LIT, B_INVIS | B_DUMMY, LAND ;Get flags.
        DW      ZEQU
        DW      LDUP
        DW      ZBRAN
        DW      MATS2-$-CW
        DW      DROP
        DW      RR, TNFA, FETCH, FETCH
        DW      OVER, LSUB
;
; The following four lines take care of denotations.
        DW      LDUP, ZLESS  ;Ignorable length difference.
        DW      RR, TFFA, FETCH, LIT, B_DENOT, LAND ;Get flag.
        DW      LAND  ;Denotation applicable. 
        DW      ZEQU, LAND ;This AND is actually an OR.
;
        DW      ZEQU
        DW      LDUP
        DW      ZBRAN
        DW      MATS2-$-CW
        DW      DROP, OVER
        DW      RR, TNFA, FETCH, SFET
        DW      CORA, ZEQU  ; Compare equals.
MATS2:  DW      FROMR, SWAP
        DW      SEMIS
;

;  **************
;  *   ?BLANK   *
;  **************
;
N_QBL:   DW      6
        DB      "?BLANK"
QBL:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PMATCH-(CW*(C_HOFFSET))
        DW    N_QBL
    DW    0

        DW      LBL, ONEP, LESS
        DW      SEMIS
;

;  ************
;  *   IN[]   *
;  ************
;
N_INBRS:   DW      4
        DB      "IN[]"
INBRS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QBL-(CW*(C_HOFFSET))
        DW    N_INBRS
    DW    0

        DW      SRC, CELLP, TFET
        DW      OVER, EQUAL
        DW      ZBRAN
        DW      INBRS1-$-CW
        DW      ZERO
        DW      BRAN
        DW      INBRS2-$-CW
INBRS1:
        DW      LDUP
        
        DW      CFET
        DW      ONE, LIN, PSTORE
INBRS2:
        DW      SEMIS
;

;  **************
;  *   (WORD)   *
;  **************
;
N_LPWORD:   DW      6
        DB      "(WORD)"
LPWORD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    INBRS-(CW*(C_HOFFSET))
        DW    N_LPWORD
    DW    0

        DW      X
PWORD0: DW      DROP
        DW      INBRS, QBL
        DW      OVER, SRC, CELLP, FETCH, LSUB ; At end?
        DW      LAND, ZEQU
        DW      ZBRAN
        DW      PWORD0-$-CW

        DW      X
PWORD1: DW      DROP
        DW      INBRS, QBL
        DW      ZBRAN
        DW      PWORD1-$-CW

        DW      OVER, LSUB
        
        DW      SEMIS
;

;  ***************
;  *   (PARSE)   *
;  ***************
;
N_PPARS:   DW      7
        DB      "(PARSE)"
PPARS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LPWORD-(CW*(C_HOFFSET))
        DW    N_PPARS
    DW    0

        DW      SRC, CELLP, TFET
        DW      OVER, LSUB
        
        DW      ROT, SSPLIT, TSWAP
        DW      ZEQU
        DW      ZBRAN
        DW      PPARS8-$-CW
        DW      DROP, SRC, CELLP, FETCH
PPARS8: 
        DW      LIN, STORE
        DW SEMIS
;

;  ***********
;  *   SRC   *
;  ***********
;
N_SRC:   DW      3
        DB      "SRC"
SRC:        DW    DOUSE
        DW    (CW*(27))
        DW    0H
        DW    PPARS-(CW*(C_HOFFSET))
        DW    N_SRC
    DW    0
      ; And 28 and 29.
;


;  **************
;  *   SOURCE   *
;  **************
;
N_SOURCE:   DW      6
        DB      "SOURCE"
SOURCE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SRC-(CW*(C_HOFFSET))
        DW    N_SOURCE
    DW    0

        DW      SRC, FETCH
        DW      SRC, CELLP, FETCH
        DW      OVER, LSUB
        DW      SEMIS
;

;  ***********
;  *   >IN   *
;  ***********
;
N_IIN:   DW      3
        DB      ">IN"
IIN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SOURCE-(CW*(C_HOFFSET))
        DW    N_IIN
    DW    0

        DW      LIN, FETCH
DW      SRC, FETCH, LSUB     
        DW      PIIN, STORE
        DW      PIIN
        DW      SEMIS
;
;

;  **********
;  *   CR   *
;  **********
;
N_CR:   DW      2
        DB      "CR"
CR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    IIN-(CW*(C_HOFFSET))
        DW    N_CR
    DW    0

        DW      LIT,ALF
        DW      EMIT
        DW      ZERO, LOUT, STORE
        DW      SEMIS
;

;  *************
;  *   CMOVE   *
;  *************
;
N_LCMOVE:   DW      5
        DB      "CMOVE"
LCMOVE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CR-(CW*(C_HOFFSET))
        DW    N_LCMOVE
    DW    0

        CLD             ;direction
        MOV     BX,SI   ;save 
        POP     CX      ;count
        POP     DI      ;dest
        POP     SI      ;source
        REP     MOVSB
        MOV     SI,BX   ;get back 
        JMP     NEXT
;

;  ************
;  *   MOVE   *
;  ************
;
N_LMOVE:   DW      4
        DB      "MOVE"
LMOVE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LCMOVE-(CW*(C_HOFFSET))
        DW    N_LMOVE
    DW    0

        MOV     BX,SI   ;SAVE 
        POP     CX      ;count
        POP     DI      ;dest
        POP     SI      ;source
        CMP     SI,DI
        JC    MOVE1
        CLD             ;INC DIRECTION
        JMP SHORT MOVE2
MOVE1:  STD
        ADD     DI,CX
        DEC     DI
        ADD     SI,CX
        DEC     SI
MOVE2:
        REP     MOVSB   ;THAT'S THE MOVE
        CLD             ;INC DIRECTION
        MOV     SI,BX   ;GET BACK 
        JMP     NEXT
;

;  ***************
;  *   FARMOVE   *
;  ***************
;
N_FMOVE:   DW      7
        DB      "FARMOVE"
FMOVE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LMOVE-(CW*(C_HOFFSET))
        DW    N_FMOVE
    DW    0

        CLD             ;direction
        MOV     AX,SI   ;save 
        MOV     BX,DS    ;save 
        POP     CX      ;count
        POP     DI      ;dest
        POP     DX
        AND     DX,DX
        JZ      FARMV1
        MOV     ES,DX
FARMV1:
        POP     SI      ;source
        POP     DX
        PUSH    DS
        PUSH    BX      ;ES in fact.
        AND     DX,DX
        JZ      FARMV2
        MOV     DS,DX
FARMV2:
        REP     MOVSB
        MOV     SI,AX   ;restore 
        POP     ES
        POP     DS
        JMP     NEXT
;

;  ***********
;  *   UM*   *
;  ***********
;
N_USTAR:   DW      3
        DB      "UM*"
USTAR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FMOVE-(CW*(C_HOFFSET))
        DW    N_USTAR
    DW    0

        POP     AX
        POP     BX
        MUL     BX      ;UNSIGNED
        XCHG    AX,DX   ;AX NOW = MSW
        JMP     DPUSH          ;STORE DOUBLE CELL
;

;  **************
;  *   UM/MOD   *
;  **************
;
N_USLAS  
        DW      PIIN, STORE
  DW  S   AX8SI     JMP     NEXT
;

; DX,DX
        JZ   -D_HOFFSET))
        DW    0H
                           FILL GDT A     JZ   -D_HOFFSET))
        GnIIN, STORE
  DW  S   A    e    ;source
        POP2      2
      ))
P 
N_USLAS  
        ))]  ;        JZ   -D_HOF lE   ;get baoT))
   O
    ;                 FILL GDT A     JZ   -D_HOFFSET)source
   e  4
HOFFSET))
        P SHORT MOVE2
MOVE1:  STD
        ADD     DI,CX
        DEC     DI
        ADD     SI,CX
        DE;

lE  (CW*(C_HOM   B_IMMED + B_DW      4   DW      ZEQU
        DW      LDUP
           DI
        ADD id
N LIT, 10, QERR           ;           DW      0       ; INIT (OlmMSO:   DW          DW      0       ; INIT (O    FE
  afore switching to protected mode. OP     DRCW*(PH_O)]  ; ADJ RE  DW   V    source
   e  4
HOFFSET))
        P SHi   DI,CX
        DEC     DI
        ADD     SI,CX
EP     AX     DI
        ADD     SI,CX
EP     AX     DI
        ADD     SI,CX
EP     AX     DI
        SP
           DI
    C)
        DW    N_LIT
    DW    0

    C)
  ARMOVEeES
W*(C_HOFFSET))
        DT))
         D
    DW    0

;  *********
;  *  D       DW      INITDP  ;      INIT (FENCE)  8
DPA:    DW      INITDP  ;      INIT (DP)     9
        DW S(PH_OFFSET-C_HOFFSET))
     O  *   ?B***I      ;source
   C+(CW*(PH_OFFSET-D_HOFF    ADD     SI,CX
EP     AX     DI
    DB       d
    DW    0

        DW      X
PWORS(PH_OF
  e
        ADD     DI,CX
2P     SI,DI
 0
 0
 ;      INIT (D    ICW = MSW
      .L
    DW    0

    UM*   *
      INITDP  ;      INIT (DP)     9
        DW B_I   INIT    ?B***I   *******
;
DEC     DI
        ADD     SI,CX
      
;

     E    "IN[]"
INBRS: )
        I
    DB       d
    DW    0

        DW     DB       INIT (D    ICW = CPU   *
; 
        DW      DROP, OVD   ML        DW***
;

 
      .L
    DW    0

 *   BRANCH   *
;  **************
;
N_

 *   BRANCH   *
;A:    DW          DB      "BRANCH"
BRAN:            DW    $+(CW*(PH_OFFSE  "IN[]"
I
EP     AX     DI
   DW    DENE-(  DENA-(CW   *
3W    $+(CW*(PH_OF        DROP, OVD   ML  
;  ******* SI,CX
        DE;

l
   **
;  *   RECURSE   *
;  *************CC**I l*(C_HOFFSET))
        DW    N_   DH      DW     iste
;  *BRAN:         P)

  OL
    across       RAN: OP     BX ****1HPDW    LMOVE-(CW*(C_HOuP     NEXT
;

; DX,DXl
   **
;  * P, OVD   ML  
Wp     BRAMoT))
      NEXT
r      FSET)s 
Wp     N_   DH      DUsed to pass data from CW*(C_HOrnG  C)
  A nte  JB      DIG  NEXOR
    DW      ( AX     DI
 A*(PH_OFASE  "INAED
    BX ****1H
N_USLAS  
         ;ES in fact.
  V DB      "NOOP"
NOLDUP
           DI
     NEXT  *********
;
N_DENQ:   DW           D;  * P, OVD  Dpplic.HPDW    LMOVE-(CW*(C_PFQOVD  Dpp,ET)s 
Wp     N_   DH

    C)
  ARMOVEeES       AND     DX,DX
        JZ          d
 LMOVE-(CW*(C_HOuP   SP
        DW    ENV-(PH_OFASE  "INAED
       DW    CELLP, FETCH
        DW  nN_IDO:   DW      1
     EA   EmW    0

 *   BRANCH   *
;  **************
;
N_

 *     BX      ;UNSIGNED
    DW    EmEN_

 *     BX     8******
;  *   A   *_

 *      n
Wp     ,
N_Xe   acrosE.EmEN_

 
 *        DW     0H
        DW    UNLOOP-(CW*(C_HOFFSET)EBX,SI   ;save  A nte  e  DUseX(CW*(C_****
O0

 *   BRANCH   *
  Dpplic.HPDW    LMOVE-(CW*(C_PFQOV
;  *****(CW*(C_****
O0

 *   BRANCH   *      4
        DEC     SI
MOVE2:
        REP     MOVSB   ;THAT'S THE MOVE
        CLD             ;INC DIREC     AL,DL   ;TCH) EV    sourciF BASE
        JAE     DIGI2   ;NUMBER ERROR
        SUBATCH) LMOVE-(CW*(C_LMOVE-(C***
O0

 *   BRANCH   *
  Dpplic.HPDW*(PH_O)CW*(C.  DW    0
      ; AnOOVE-(L))
P 
N_USLAS  
   EN_

 *     BX     8******
;  *   A   *_

 *  PDW    LMOVE-(CW*(C_HOuP     NEXT
 *_

 *  PDW    LMOVE-(CW*(C_HOu*****EBX,
 *   BRANCH   *
  Dpplic.H  *
;  ***************
;
N_PMATCH:   DW      7
      
    DIREC     ALE*(PH_O)CLl  DC_LN_USLAS  
*
  Dpplic.HPDW    LNCH   )CLl  DC_LN_USLAS  
*

;  **DEN7-(CW*(C_HOFFSET))
        DW    N_D aPDW    LMOMOVE2:
        REP    SI
W    N_D aPDW    LMOMW    B_IMMED + B_DENO
       ER EO: LlDW     TER SLDI
   DW    DENE-(    22
IBMPC:  DB      'IBM-PC cDW      eABMPC:  D  
    DIREDW      SKITER
 F BASE
 ;OMOVE2:
        REP    SI
W    N_D aPDW    LMO   ****P    SI                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        