      program airport
      use is_file
!  -------------
      character(len=1) :: yn
      character(len=8) :: crec
      integer :: ierr, jerr, i
      type(data_record_type_isdata) :: mrec
      type(is_block_defn), pointer :: blk 
      character(len=128) :: fname
!
      ierr = 0
!     open file
      blk => is_file_open('airport', err=ierr)
      if(ierr /= 0) then
         print*,' create file '
         print*,' indexed file is empty, the first command you want to do'
         print*,' is either "a" to add a record, or "A" to add from a file'
         call is_file_create('airport', err=ierr)
         if(ierr /= 0)print*,' create error ',ierr
         blk => is_file_open('airport', err=jerr)
         if((ierr /= 0) .or. (jerr /= 0)) then
            print*,' can''t open or create file', jerr
            stop
          end if
      end if
!
!! next block of code is optional - use only if your system supports POSIX calls
!      ix = ipxfargc()
!      if(ix == 1) then
!         crec = ' '
!         call pxfgetarg(1, crec(1:3), ilen, ierr)
!         if(ierr /= 0) stop ' error'
!         call raicas(crec)
!         call is_get_record(blk, crec, mrec, ierr)
!         if(ierr /= 0) then
!            print*,'Key "',crec(1:3),'" not found, here is what is close:'
!            call is_get_prev_record(blk, mrec, ierr)
!            call is_get_prev_record(blk, mrec, ierr)
!            if(ierr == 0)print *,' ', mrec % key,' ', trim(mrec%data)
!            call is_get_next_record(blk, mrec, ierr)
!            if(ierr == 0)print *,' ', mrec % key,' ', trim(mrec%data)
!            call is_get_next_record(blk, mrec, ierr)
!            if(ierr == 0)print *,' ', mrec % key,' ', trim(mrec%data)
!         else
!            print *,' ', mrec % key,' ', trim(mrec % data)
!         end if
!         go to 99
!      end if
!! end of optional block
      yn = '?'
      forever: do
      ierr = 0
      if( yn == '?' ) then
        print *,'function:  l= lookup, m= modify,  q= quit'
        print *,'           1= rewind, $= skip-to-eof, >= next, <= prev'
        print *,'           A= add-from-file, a= add-new-record'
        print *,'           D= delete-from-file, d= delete-record'
      end if 
      write(*,fmt='(a)',advance='no') 'Command: '
      read *,yn
      if (yn == 'q') exit
      if (yn == 'A' ) then
        i = 0
        fname = ' '
        write(*,fmt='(a)',advance='no') 'Filename: '
        read *,fname
        open(unit=1,file=fname,action='read',err=3)
        do
          read(1,fmt='(a3,5x,a)', err=2, end=3) mrec%key, mrec%data
          call raicas(mrec % key)
          i = i + 1
          call is_put_record(blk, mrec, ierr)
          if(ierr /= 0) print*,' put error ', ierr, mrec
        enddo
        go to 3
  2     continue
        print*,' put error ', ierr, mrec
  3     continue
        close(1)
        print*,i,' records read '
      else if (yn == 'l') then
         print *, ' please type in key'
         read *, crec
         call raicas(crec)
         call is_get_record(blk, crec, mrec, ierr)
           if(ierr /= 0) then
             print*,' Record not found, here is what is close:'
             call is_get_prev_record(blk, mrec, ierr)
             call is_get_prev_record(blk, mrec, ierr)
             if(ierr == 0)print *,' record = ', mrec % key,' ', trim(mrec%data)
             call is_get_next_record(blk, mrec, ierr)
             if(ierr == 0)print *,' record = ', mrec % key,' ', trim(mrec%data)
             call is_get_next_record(blk, mrec, ierr)
             if(ierr == 0)print *,' record = ', mrec % key,' ', trim(mrec%data)
           else
             print *,' record = ', mrec % key,' ', trim(mrec % data)
           end if
       else if (yn == 'a') then
         print *,' type in new record data '
         read *,mrec % key, mrec % data
         call raicas(mrec % key)
         call is_put_record(blk, mrec, ierr)
           if(ierr /= 0) print*,' write(new) error'
       else if (yn == 'm') then
         print *, ' please type in key'
         read *, crec
         call raicas(crec)
         call is_get_record(blk, crec, mrec, ierr)
           if(ierr /= 0) then
             print*,' read error', ierr
           else
             print *,' record = ', mrec % key,' ', trim(mrec % data)
           end if
         print *,' type in new record data '
         read *, mrec % data
         call is_replace_record(blk, mrec, ierr)
           if(ierr /= 0) print*,' write(replace) error', ierr
       else if (yn == 'd') then
         print *, ' please type in key'
         read *, crec
         call raicas(crec)
         call is_delete_record(blk, crec, ierr)
           if(ierr /= 0) then
             print*,' delete error:', crec,' ',ierr
           end if
       else if (yn == 'D') then
         i = 0
         fname = ' '
         write(*,fmt='(a)',advance='no') 'Filename: '
         read *,fname
         open(unit=2,file=fname,action='read',err=22)
         do 
          read(2,fmt='(a3)',err=22,end=22) crec
          call raicas(crec)
          call is_delete_record(blk, crec, ierr)
           if(ierr /= 0) then
             print*,' delete error ', crec
           else
             i = i + 1
           end if
         enddo
 22      continue
         print*,i,' records deleted'
         close(2)
       else if (yn == '1') then
         print*, ' position at beginning '
         call is_pos_begin(blk, ierr)
           if(ierr < 0) then
             print*,' position error', ierr
           end if
       else if (yn == '$') then
         print*, ' position at end '
         call is_pos_eof(blk, ierr)
           if(ierr < 0) then
             print*,' posiion error', ierr
           end if
       else if (yn == '<') then
         print*, ' previous '
         call is_get_prev_record(blk, mrec, ierr)
           if(ierr < 0) then
             print*,' read error', ierr
           else
             print *,' record = ', mrec % key,' ', trim(mrec % data)
           end if
       else if (yn == '>') then
         print*, ' next '
         call is_get_next_record(blk, mrec, ierr)
           if(ierr < 0) then
             print*,' read error', ierr
           else
             print *,' record = ', mrec % key,' ', trim(mrec % data)
           end if
       else
         print *,' unrecogized command ',yn
         yn = '?'
       end if

      end do forever
 99   continue
      !print*,' closing '
      call is_file_close(blk, ierr)
      if(ierr /= 0) print*,' close error', ierr
! ------------------------------------------------
contains
subroutine raicas (zstr)
    character (len=*), intent (inout) :: zstr  ! The string
!  Raise a string to upper case
    character (len=26), parameter :: zlwc="abcdefghijklmnopqrstuvwxyz"
    character (len=26), parameter :: zupc="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    character(len=1) :: togglechar
    logical :: toggle
!   Modified to not do upper case to embedded strings (pgg 21.11.94) 
    toggle = .TRUE.  
    lstr = len_trim (zstr)
    do istr = 1, lstr
       if (toggle) then
          if(zstr (istr:istr) == '"' .or. zstr (istr:istr) == "'") then
             toggle = .not. toggle
             togglechar = zstr (istr:istr)
          end if
          irnk = index (zlwc, zstr (istr:istr))
          if (irnk > 0) then
             zstr (istr:istr) = zupc (irnk:irnk)
          endif
       else
          if(zstr (istr:istr) == togglechar) toggle = .not. toggle
       endif
    enddo
end subroutine raicas

end
