{ VGA Show /320x200,256 Colors }
{$M 20000,0,655360}

uses Dos,Show320,SVGA256,Txt;

const
  Delays:array[0..47] of byte=(
    25,20,20,05,05, 12,08,05,08,15, 08,05,05,05,05,
    08,03,03,08,08, 10,10,10,10,08, 05,08,03,04,04,
    04,04,03,02,02, 03,70,50,50,70, 15,03,06,04,04, 06,12,12);
  ShowType:integer=0; No:integer=0;
  Page:integer=0;     PageSize:integer=85;
var Filenames:array[0..4095] of string[12];
    K,Max,PageMax:integer;

{  GetFilenames  }
procedure GetFilenames(Path:string);
var DirInfo:SearchRec;
begin
  Max:=0; FillChar(Filenames,26624,32);
  FindFirst(Path,Archive,DirInfo);
  while DosError=0 do begin
    FileNames[Max]:=DirInfo.Name;
    FileNames[Max,0]:=#12;
    FindNext(DirInfo); Inc(Max);
  end;
  if Max=0 then begin
    Writeln; Writeln('Sorry! Can''t find any file!');
    Halt(1);
  end;
  Dec(Max);
end;
{  SortFilenames  }
procedure SortFilenames(L,R:integer);
var I,J:integer;
    M,T:string[12];
begin
  I:=L; J:=R; M:=Filenames[(L+R) shr 1];
  repeat
    while Filenames[I]<M do Inc(I);  { Move right }
    while M<Filenames[J] do Dec(J);  { Move left }
    if I<=J then begin
      T:=Filenames[I]; Filenames[I]:=Filenames[J]; Filenames[J]:=T;
      Inc(I); Dec(J);
    end;
  until I>J;
  if L<J then SortFilenames(L,J);
  if I<R then SortFilenames(I,R);
end;
{  ShowPic  }
procedure ShowPic(Ty,X,Y,LenX,LenY:integer);
var S,O,D:integer;
    L:longint;
    Pic:pointer;
begin
  GetMem(Pic,64768);
  L:=FileLen(Filenames[PageSize*Page+No],1);
  if L>64768 then L:=64768;
  FileRead(Filenames[PageSize*Page+No],0,L,1,Pic^);
  S:=Seg(Pic^); O:=Ofs(Pic^); D:=Delays[Ty];
  SetMode(1); SetPalette(0,256,Mem[S:O]); Inc(O,768);
  case Ty of
     0:ShowBar   (X,Y,LenX,LenY,D,Mem[S:O]);
     1:ShowBox   (1,X,Y,LenX,LenY,D,Mem[S:O]);
     2:ShowBox   (2,X,Y,LenX,LenY,D,Mem[S:O]);
     3:ShowCircle(1,X,Y,LenX,LenY,188,D,Mem[S:O]);
     4:ShowCircle(2,X,Y,LenX,LenY,188,D,Mem[S:O]);
     5:ShowCell  (X,Y,LenX,LenY,8,8,D,Mem[S:O]);
     6:ShowClkRnd(X,Y,LenX,LenY,D,Mem[S:O]);
     7:ShowClock (X,Y,LenX,LenY,D,Mem[S:O]);
     8:ShowClock2(X,Y,LenX,LenY,D,Mem[S:O]);
     9:ShowColor (1,X,Y,LenX,LenY,0,256,D,Mem[S:O]);
    10:ShowDot   (X,Y,LenX,LenY,D,Mem[S:O]);
    11:ShowFall  (1,X,Y,LenX,LenY,10,D,Mem[S:O]);
    12:ShowFall  (2,X,Y,LenX,LenY,16,D,Mem[S:O]);
    13:ShowFall  (3,X,Y,LenX,LenY,16,D,Mem[S:O]);
    14:ShowFall  (4,X,Y,LenX,LenY,10,D,Mem[S:O]);
    15:ShowFlow  (1,X,Y,LenX,LenY,2,D,Mem[S:O]);
    16:ShowFlow  (2,X,Y,LenX,LenY,2,D,Mem[S:O]);
    17:ShowFlow  (3,X,Y,LenX,LenY,2,D,Mem[S:O]);
    18:ShowFlow  (4,X,Y,LenX,LenY,2,D,Mem[S:O]);
    19:ShowIn    (X,Y,LenX,LenY,2,D,Mem[S:O]);
    20:ShowJam   (1,X,Y,LenX,LenY,10,D,Mem[S:O]);
    21:ShowJam   (2,X,Y,LenX,LenY,16,D,Mem[S:O]);
    22:ShowJam   (3,X,Y,LenX,LenY,16,D,Mem[S:O]);
    23:ShowJam   (4,X,Y,LenX,LenY,10,D,Mem[S:O]);
    24:ShowLine  (1,X,Y,LenX,LenY,D,Mem[S:O]);
    25:ShowLine  (2,X,Y,LenX,LenY,D,Mem[S:O]);
    26:ShowMove  (1,X,Y,LenX,LenY,2,D,Mem[S:O]);
    27:ShowMove  (2,X,Y,LenX,LenY,4,D,Mem[S:O]);
    28:ShowScroll(1,X,Y,LenX,LenY,4,D,Mem[S:O]);
    29:ShowScroll(2,X,Y,LenX,LenY,5,D,Mem[S:O]);
    30:ShowScroll(3,X,Y,LenX,LenY,5,D,Mem[S:O]);
    31:ShowScroll(4,X,Y,LenX,LenY,4,D,Mem[S:O]);
    32:ShowShadow(X,Y,LenX,LenY,199,D,Mem[S:O]);
    33:ShowShadow(X,Y,LenX,LenY,211,D,Mem[S:O]);
    34:ShowShadow(X,Y,LenX,LenY,307,D,Mem[S:O]);
    35:ShowSlope (X,Y,LenX,LenY,D,Mem[S:O]);
    36:ShowSplit (1,X,Y,LenX,LenY,10,D,Mem[S:O]);
    37:ShowSplit (2,X,Y,LenX,LenY,10,D,Mem[S:O]);
    38:ShowSplit (3,X,Y,LenX,LenY,10,D,Mem[S:O]);
    39:ShowSplit (4,X,Y,LenX,LenY,10,D,Mem[S:O]);
    40:ShowZoom  (X,Y,LenX,LenY,2,D,Mem[S:O]);
    41:ShowZoom2 (X,Y,LenX,LenY,2,D,Mem[S:O]);
    42:ShowZoom4 (1,X,Y,LenX,LenY,4,D,Mem[S:O]);
    43:ShowZoom4 (2,X,Y,LenX,LenY,5,D,Mem[S:O]);
    44:ShowZoom4 (3,X,Y,LenX,LenY,5,D,Mem[S:O]);
    45:ShowZoom4 (4,X,Y,LenX,LenY,4,D,Mem[S:O]);
    46:ShowZoomXY(1,X,Y,LenX,LenY,2,D,Mem[S:O]);
    47:ShowZoomXY(2,X,Y,LenX,LenY,4,D,Mem[S:O]);
  end;
  FreeMem(Pic,64768);
end;
{  TextProc  }
procedure TextProc;
begin
  SetMode(0);
  SetCurShape($20,0);
  SetFlash(0);
end;
{  Screen  }
procedure Screen;
const St:array[1..3] of string[30]=(
	'          ',
	'              ',
	'      ');

var I,J:integer;
begin
  TextBar(1, 1,80, 1,$9F,' ');
  TextBar(1, 2,80,23,$1F,' ');
  TextBar(1,25,80, 1,$9F,' ');
  PrintChar(4, 1,'VGA Show /320x200,256 Colors');
  PrintChar(4,25,'Arrows,PgUp,PgDn,Home,End-Select   Enter-Show   '+
    '+-/*-Delay   Esc-Quit');
  for I:=1 to 3 do PrintText(8,2+I,$1F,St[I]);
  for I:=1 to 3 do for J:=1 to Length(St[I]) do
    case St[I,J] of
      '':PrintText(8+J,2+I,$7F,St[I,J+1]);
      '':case St[I,J+1] of
	    ' ':PrintText(8+J,2+I,$17,'');
	    '':PrintText(8+J,2+I,$7F,'');
	  end;
      '':case St[I,J+1] of
	    ' ':PrintText(8+J,2+I,$17,'');
	    '':PrintText(8+J,2+I,$7F,'');
	  end;
    end;
end;
{  ShowPage  }
procedure ShowPage(PageNo:integer);  { 5x17 }
var I:integer;
begin
  PageMax:=PageSize-1;
  if (Max<PageSize-1) or (Page=Max div PageSize)
    then PageMax:=Max mod PageSize;
  TextBar(4,7,74,17,$1F,' ');
  for I:=0 to PageMax do
    PrintText(5+15*(I mod 5),7+I div 5,$1E,Filenames[PageSize*PageNo+I]);
end;
{  SelectType  }
procedure SelectType(X,Y:integer);    { 58x17 }
const St:array[0..47] of string[11]=(
  'Bars 16->1 ','Outside    ','Inside     ','Circle Out ',
  'Circle In  ','Rnd Cells  ','Clock Rnd  ','Clock Line ',
  'Clock 2Line','Color Shade','Random Dots','Fall Up    ',
  'Fall Left  ','Fall Right ','Fall Down  ','Flow Up    ',
  'Flow Left  ','Flow Right ','Flow Down  ','In 4 Parts ',
  'Jam Up     ','Jam Left   ','Jam Right  ','Jam Down   ',
  'Lines U-D  ','Lines L-R  ','Move U-D   ','Move L-R   ',
  'Scroll Up  ','Scroll Left','Scroll Rght','Scroll Down',
  'Shadow Smal','Shadow Mid ','Shadow Big ','Lines Slope',
  'Split Up   ','Split Left ','Split Rght ','Split Down ',
  'Zoom Out   ','Zoom In    ','Zoom Up    ','Zoom Left  ',
  'Zoom Right ','Zoom Down  ','Zoom U-D   ','Zoom L-R   ');
var I:integer;
    Buf:array[0..3999] of byte;
begin
  GetText(X,Y,59,17,Buf);
  TextWindow1(X,Y,58,16,$3F,$3E,2,' Show Type ');
  PrintText(X+3,Y,$3E,' Delay     ');
  for I:=0 to 47 do PrintText(X+4+13*(I and 3),Y+2+I shr 2,$30,St[I]);
  repeat
    PrintText(X+3,Y,$3E,' Delay     ');
    PrintNum(X+10,Y,$3E,Delays[ShowType]);
    PrintText(X+3+13*(ShowType and 3),Y+2+ShowType shr 2,$A0,' '+St[ShowType]+' ');
    K:=Key;
    PrintText(X+3+13*(ShowType and 3),Y+2+ShowType shr 2,$30,' '+St[ShowType]+' ');
    case K of
      $4B00:Dec(ShowType);    $4D00:Inc(ShowType);     { Left,Right }
      $4800:Dec(ShowType,4);  $5000:Inc(ShowType,4);   { Up,Down }
      $4700:ShowType:=0;      $4F00:ShowType:=47;      { Home,End }
      $4900:Dec(ShowType,16); $5100:Inc(ShowType,16);  { PgUp,PgDn }
      $4A2D:Dec(Delays[ShowType]);                     { Right - }
      $4E2B:Inc(Delays[ShowType]);                     { Right + }
      $352F:Dec(Delays[ShowType],10);                  { Right / }
      $372A:Inc(Delays[ShowType],10);                  { Right * }
    end;
    if Delays[ShowType]<0   then Delays[ShowType]:=0;
    if Delays[ShowType]>250 then Delays[ShowType]:=250;
    if ShowType<0  then ShowType:=47;
    if ShowType>47 then ShowType:=0;
  until (K=$011B) or (K=$1C0D);                        { Esc,Enter }
  PutText(X,Y,59,17,Buf);
end;
{  SelectFile  }
procedure SelectFile;
begin
  TextProc; Screen; ShowPage(0);
  repeat
    PrintText(4+15*(No mod 5),7+No div 5,$A0,' '+Filenames[PageSize*Page+No]+' ');
    K:=Key;
    PrintText(4+15*(No mod 5),7+No div 5,$1E,' '+Filenames[PageSize*Page+No]+' ');
    case K of
      $4B00:Dec(No);    $4D00:Inc(No);        { Left,Right }
      $4800:Dec(No,5);  $5000:Inc(No,5);      { Up,Down }
      $4700:No:=0;      $4F00:No:=PageMax;    { Home,End }
      $4900:if Page>0 then begin Dec(Page); ShowPage(Page); end;
      $5100:if Page<Max div PageSize then begin Inc(Page); ShowPage(Page); end;
      $1C0D:begin
	      SelectType(11,6);
	      if K=$1C0D then begin
		ShowPic(ShowType,0,0,320,200);
		K:=Key;
		TextProc; Screen; ShowPage(Page);
		Inc(ShowType); if ShowType>47 then ShowType:=0;
	      end;
	      K:=0;
	    end;
    end;
    if No<0 then No:=PageMax;
    if No>PageMax then No:=0;
  until K=$011B;                              { Esc }
  SetMode(0);
end;

begin
  GetFilenames('*.*');
  SortFilenames(0,Max);
  SelectFile;
end.
