/** 3DGPL *************************************************\
 *  (MSDOS, i386+, VGA, WATCOM C)                         *
 *  Header for hardware specific stuff.                   *
 *                                                        *
 *  Defines:                                              *
 *    HW_open_screen         opening output surface;      *
 *    HW_blit                colourmap onto the screen;   *
 *    HW_close_screen        closing output;              *
 *                                                        *
 *    HW_run_event_loop      runiing for events;          *
 *    HW_quit_event_loop     quiting running.             *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

#include <conio.h>                          /* kbhit() etc. */
#include "../hardware/hardware.h"           /* all the defenitions */

unsigned char *HW_colourmap;                /* where drawing are */
int HW_running;                             /* event loop running? */

/**********************************************************\
 *  Opening output surface and setting the palette.       *
 *                                                        *
 *  RETURNS: always 1.                                    *
 *  --------                                              *
\**********************************************************/

void HW_set_mode(void);
#pragma aux HW_set_mode=   \
 "mov  al,13h "            \
 "xor  ah,ah"              \
 "int  10h"                \
 modify [ax];

void HW_set_colour(int r,int g,int b,int number);
#pragma aux HW_set_colour= \
 "mov  ax,1010h"           \
 "int  10h"                \ 
 parm  [dh] [ch] [cl] [bx];

int HW_open_screen(char *display_name,
                   char *screen_name,
                   struct HW_colour palette[256],
                   unsigned char *colourmap
                  )
{
 int i;
 unsigned char r,g,b;

 HW_colourmap=colourmap;                    /* the graphics buffer */
 
 HW_set_mode();                             /* mode 13 */

 for(i=0;i<256;i++)
 {
  r=(unsigned char)palette[i].hw_r;
  g=(unsigned char)palette[i].hw_g;
  b=(unsigned char)palette[i].hw_b;
  HW_set_colour(r,g,b,i);                   /* palette */
 }
 return(1);
}

/**********************************************************\
 *  Colormap onto the screen.                             *
\**********************************************************/

void HW_blit(void)
{
 HW_copy_int((int*)HW_colourmap,(int*)0xa0000,HW_COLOURMAP_SIZE_INT);
}

/**********************************************************\
 *  Closing output surface.                               *
\**********************************************************/
 
void HW_close_screen(void)
{
}

/**********************************************************\
 *  Running the event loop.                               *
\**********************************************************/

void HW_run_event_loop(void (*application_main)(void),
                       void (*application_key_handler)(int key_code)
                      )
{
 char c;
 HW_running=1;

 while(HW_running==1)                       /* still running? hmmm */
 {
  if(kbhit()) 
  {
   c=getch();
   if(c==0) application_key_handler(getch());
   else application_key_handler(c);
  }
  application_main();
 }
}

/**********************************************************\
 *  Stoping the event loop.                               *
\**********************************************************/

void HW_quit_event_loop(void)
{
 HW_running=0;                              /* that's it */
}

/**********************************************************/
