/********************************************************************
PATHDEMO.POV - Example script file of a stone building with pillars
********************************************************************/

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stones.inc"

/*The Viewer*/
camera {
  location <0.0, 50.0, -180.0>
  look_at <0.0, 0.0, 0.0>
  sky <0.0, 1.0, 0.0>
 }

  object {
     union {
       sphere { 
         <150, 350, -300>, 40
         pigment { color Clear }
       }
       light_source { <150, 350.0, -300.0> color White }
     }
    no_shadow
   }

/* The sky */

sphere {
     <0.0, 0.0, 0.0>, 500.0
   finish {
      ambient 0.7
      diffuse 0.0   /* we don't want clouds casting shadows on the sky */
   }
   pigment {
      gradient y
      colour_map { [0.0 0.8  colour red 0.3 green 0.3 blue 0.8
                           colour red 0.4 green 0.7 blue 1.0]
                 [0.8 1.0 colour red 0.4 green 0.7 blue 1.0
                          colour red 0.7 green 0.7 blue 1.0]
      }
     scale <500.0, 500.0, 500.0>
   }
   normal {bumps 0.1   scale 0.2}
}

/* Put in a few clouds */
   sphere { <0.0, 0.0, 0.0>, 489.0
   finish {
     ambient 0.7
     diffuse 0.0
   }
   pigment {
      bozo
      turbulence 0.5
      colour_map {
          [0.0 0.6  colour red 1.0 green 1.0 blue 1.0 filter 1.0
                    colour red 1.0 green 1.0 blue 1.0 filter 1.0]
          [0.6 0.8 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                    colour red 1.0 green 1.0 blue 1.0]
          [0.8 1.001 colour red 1.0 green 1.0 blue 1.0
                     colour red 0.8 green 0.8 blue 0.8]
      }
     scale <500, 120, 500>
     rotate <0,25,0>
   }
}

/* The ground */
plane {
      <0, 1, 0>, -5

      pigment {
        HuntersGreen
      }
      finish {
        ambient 0.4
        diffuse 0.6
      }
      normal {bumps 0.4   scale 0.2}
   }

/* The base */

 object {
  difference {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 50.0,10.0,100.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 10.0,12.0,20.0>
    translate < 0.0,0.0,-85.0>
}

 }
 texture {
   Stone12
   scale <20.0, 30.0, 40.0>
 }
 finish {
   ambient 0.3
   diffuse 0.7
   reflection 0.2
   specular 0.2
 }
}

/* The steps */

 object {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 10.0,2.0,10.0>
    translate < 0.0,8.0,-75.0>
 }
 texture {
   Stone12
   scale <20.0, 20.0, 20.0>
   rotate <30.0, 10.0, 5.0>
 }
 finish {
   ambient 0.3
   diffuse 0.7
   reflection 0.2
   specular 0.2
 }
}

object {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 10.0,2.0,10.0>
    translate < 0.0,4.0,-81.0>
 }
 texture {
   Stone12
   scale <15.0, 20.0, 25.0>
   rotate <10.0, 34.0, -55.0>
 }
 finish {
   ambient 0.4
   diffuse 0.6
   reflection 0.2
   specular 0.2
 }
}

object {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 10.0,2.0,10.0>
    translate < 0.0,0.0,-87.0>
 }
 texture {
   Stone12
   scale <10.0, 15.0, 20.0>
   rotate <-67.0, 4.0, -5.0>
 }
 finish {
   ambient 0.4
   diffuse 0.6
   reflection 0.2
   specular 0.2
 }
}

object {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 10.0,2.0,10.0>
    translate < 0.0,-4.0,-93.0>
 }
 texture {
   Stone12
   scale <22.0, 17.0, 14.0>
   rotate <-7.0, 54.0, 24.0>
 }
 finish {
   ambient 0.4
   diffuse 0.6
   reflection 0.2
   specular 0.2
 }
}

object {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 10.0,2.0,10.0>
    translate < 0.0,-8.0,-99.0>
 }
 texture {
   Stone12
   scale <25.0, 17.0, 20.0>
   rotate <-17.0, 24.0, 0.0>
 }
 finish {
   ambient 0.4
   diffuse 0.6
   reflection 0.2
   specular 0.2
 }
}

/* Pillar: Front-right */
 object {
  union {
 cylinder {<0.0, -35.0,0.0>, <0.0, 35.0, 0.0>, 10.0
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,35.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,36.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 12.0
    translate < 0.0,37.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 13.0
    translate < 0.0,38.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 14.0
    translate < 0.0,39.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 15.0,1.5,15.0>
    translate < 0.0,41.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 11.0,10.0,11.0>
    translate < 0.0,-40.0,0.0>
}
 }
 texture {Red_Marble
          scale <10.0, 10.0, 10.0>
          rotate <25.0, -10.0, 15.0>
         }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.5, 0.5, 0.5>
  translate <36.0, 35.0, -92.0>
}

/* Pillar: Front-Left */
 object {
  union {
 cylinder {<0.0, -35.0,0.0>, <0.0, 35.0, 0.0>, 10.0
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,35.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,36.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 12.0
    translate < 0.0,37.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 13.0
    translate < 0.0,38.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 14.0
    translate < 0.0,39.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 15.0,1.5,15.0>
    translate < 0.0,41.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 11.0,10.0,11.0>
    translate < 0.0,-40.0,0.0>
}
 }
 texture {Red_Marble
          scale <10.0, 10.0, 10.0>
          rotate <25.0, -10.0, 15.0>
         }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.5, 0.5, 0.5>
  translate <-36.0, 35.0, -92.0>
}

/* Pillar: Back-right */
 object {
  union {
 cylinder {<0.0, -35.0,0.0>, <0.0, 35.0, 0.0>, 10.0
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,35.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,36.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 12.0
    translate < 0.0,37.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 13.0
    translate < 0.0,38.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 14.0
    translate < 0.0,39.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 15.0,1.5,15.0>
    translate < 0.0,41.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 11.0,10.0,11.0>
    translate < 0.0,-40.0,0.0>
}
 }
 texture {Red_Marble
          scale <10.0, 10.0, 10.0>
          rotate <15.0, 10.0, 5.0>
         }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.5, 0.5, 0.5>
  translate <36.0, 35.0, 92.0>
}

/* Pillar: back-Left */
 object {
  union {
 cylinder {<0.0, -35.0,0.0>, <0.0, 35.0, 0.0>, 10.0
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,35.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,36.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 12.0
    translate < 0.0,37.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 13.0
    translate < 0.0,38.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 14.0
    translate < 0.0,39.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 15.0,1.5,15.0>
    translate < 0.0,41.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 11.0,10.0,11.0>
    translate < 0.0,-40.0,0.0>
}
 }
 texture {Red_Marble
          scale <10.0, 10.0, 10.0>
          rotate <5.0, 10.0, 15.0>
         }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.5, 0.5, 0.5>
  translate <-36.0, 35.0, 92.0>
}

/* Pillar: middle-right */
 object {
  union {
 cylinder {<0.0, -35.0,0.0>, <0.0, 35.0, 0.0>, 10.0
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,35.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,36.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 12.0
    translate < 0.0,37.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 13.0
    translate < 0.0,38.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 14.0
    translate < 0.0,39.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 15.0,1.5,15.0>
    translate < 0.0,41.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 11.0,10.0,11.0>
    translate < 0.0,-40.0,0.0>
}
 }
 texture {Red_Marble
          scale <10.0, 10.0, 10.0>
          rotate <25.0, -10.0, 15.0>
         }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.5, 0.5, 0.5>
  translate <36.0, 35.0, 0.0>
}

/* Pillar: back-Left */
 object {
  union {
 cylinder {<0.0, -35.0,0.0>, <0.0, 35.0, 0.0>, 10.0
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,35.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 11.0
    translate < 0.0,36.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 12.0
    translate < 0.0,37.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 13.0
    translate < 0.0,38.0,0.0>
}
 cylinder {<0.0, -0.5,0.0>, <0.0, 0.5, 0.0>, 14.0
    translate < 0.0,39.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 15.0,1.5,15.0>
    translate < 0.0,41.0,0.0>
}
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 11.0,10.0,11.0>
    translate < 0.0,-40.0,0.0>
}
 }
 texture {Red_Marble
          finish {ambient 0.3}
          scale <10.0, 10.0, 10.0>
          rotate <35.0, 0.0, -15.0>
         }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.5, 0.5, 0.5>
  translate <-36.0, 35.0, 0.0>
}

/* roof on front pillars */

 object {
  difference {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 75.0,20.0,10.0>
}
 cylinder {<0.0, -15.0,0.0>, <0.0, 15.0, 0.0>, 150.0
    scale < 2.0,1.0,1.0>
    rotate < 90.0,0.0,0.0>
    translate < 250.0,100.0,0.0>
}
 cylinder {<0.0, -15.0,0.0>, <0.0, 15.0, 0.0>, 150.0
    scale < 2.0,1.0,1.0>
    rotate < 90.0,0.0,0.0>
    translate < -250.0,100.0,0.0>
}
 cylinder {<0.0, -10.0,0.0>, <0.0, 10.0, 0.0>, 5.0
    scale < 1.5,5.0,1.5>
    rotate < 90.0,0.0,0.0>
    translate < 0.0,-5.0,0.0>
}
 }
  texture {
    Stone12
    scale <10.0, 7.5, 8.9>
    rotate <90.0, 0.0, 0.0>
  }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.8, 0.8, 0.8>
  translate <0.0, 70.0, -92.0>
}

/* roof on middle pillars */

 object {
  difference {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 75.0,20.0,10.0>
}
 cylinder {<0.0, -15.0,0.0>, <0.0, 15.0, 0.0>, 150.0
    scale < 2.0,1.0,1.0>
    rotate < 90.0,0.0,0.0>
    translate < 250.0,100.0,0.0>
}
 cylinder {<0.0, -15.0,0.0>, <0.0, 15.0, 0.0>, 150.0
    scale < 2.0,1.0,1.0>
    rotate < 90.0,0.0,0.0>
    translate < -250.0,100.0,0.0>
}
 cylinder {<0.0, -10.0,0.0>, <0.0, 10.0, 0.0>, 5.0
    scale < 1.5,5.0,1.5>
    rotate < 90.0,0.0,0.0>
    translate < 0.0,-5.0,0.0>
}
 }
  texture {
    Stone12
    scale <10.0, 7.5, 8.9>
    rotate <90.0, 0.0, 0.0>
  }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.8, 0.8, 0.8>
  translate <0.0, 70.0, 0.0>
}

/* roof on back pillars */

 object {
  difference {
 box{ <-1, -1, -1>, <1, 1, 1>
    scale < 75.0,20.0,10.0>
}
 cylinder {<0.0, -15.0,0.0>, <0.0, 15.0, 0.0>, 150.0
    scale < 2.0,1.0,1.0>
    rotate < 90.0,0.0,0.0>
    translate < 250.0,100.0,0.0>
}
 cylinder {<0.0, -15.0,0.0>, <0.0, 15.0, 0.0>, 150.0
    scale < 2.0,1.0,1.0>
    rotate < 90.0,0.0,0.0>
    translate < -250.0,100.0,0.0>
}
 cylinder {<0.0, -10.0,0.0>, <0.0, 10.0, 0.0>, 5.0
    scale < 1.5,5.0,1.5>
    rotate < 90.0,0.0,0.0>
    translate < 0.0,-5.0,0.0>
}
 }
  texture {
    Stone12
    scale <10.0, 7.5, 8.9>
    rotate <90.0, 0.0, 0.0>
  }
  finish {
    ambient 0.3
    diffuse 0.7
  }
  scale <0.8, 0.8, 0.8>
  translate <0.0, 70.0, 92.0>
}


