/*
Written by: Robert C. Pendleton

Placed in the public domain by the author.

*/

#ifndef _VESA_H_
#define _VESA_H_

/*

VESA graphics driver for 256 color VESA graphic modes. It requires
a VESA version 1.1 BIOS.

It has been tested with a VESA 1.1 BIOS on an ET4000

*/

#include "ptypes.h"

//---------------------------------------------------
/*
*/

typedef struct {
	uint8 red;
	uint8 green;
	uint8 blue;
} palette;


//---------------------------------------------------
/*
*/

typedef enum {
	NONE       = 0x000,
	g320x200   = 0x013,
	g640x400   = 0x100,
	g640x480   = 0x101,
	g800x600   = 0x103,
	g1024x768  = 0x105,
	g1280x1024 = 0x107,
} vesaMode;

//---------------------------------------------------
/*
*/

typedef union {
	struct {
		uint8 vesa[4];
		uint8 majorMode;
		uint8 minorMode;
		uint8 _far *vendorName;
		uint32 capabilities;
		int16 _far *modes;
	};
	uint8 filler[512];
} vesaInfo;

//---------------------------------------------------
/*
*/

typedef union {
		struct {
		uint16 modeAttr;
		uint8 windowAAttr;
		uint8 windowBAttr;
		uint16 windowGranularity;
		uint16 windowSize;
		uint16 windowAStartSeg;
		uint16 windowBStartSeg;
		uint32 posFuncPtr;
		uint16 bytesPerScanLine;
/*------------ Optional ------------*/
		uint16 width;
		uint16 height;
		uint8 charWidth;
		uint8 charHeight;
		uint8 numberOfPlanes;
		uint8 bitsPerPixel;
		uint8 numberOfBanks;
		uint8 memoryModel;
		uint8 sizeOfBank;
	};
	uint8 filler[512];
} vesaModeInfo;

//---------------------------------------------------
/*
*/

extern void setVGAColor(int16 index, int16 r, int16 g, int16 b);
extern void setVGAPalette(palette *p);
extern char getVesaInfo(vesaInfo *infoPtr);
extern void printVesaInfo(FILE *file, vesaInfo *info);
extern char getVesaModeInfo(int16 mode, vesaModeInfo *infoPtr);
extern void printVesaModeInfo(FILE *file, vesaModeInfo *info);
extern char setVesaMode(int16 mode);
extern char getVesaMode(int16 *mode);
extern char getVesaStateSize(uint8 flags, int32 *size);
extern char getVesaState(uint8 flags, uint8 *buffer);
extern char setVesaState(uint8 flags, uint8 *buffer);
extern char setVesaWinAAddr(uint16 addr);
extern char setVesaWinBAddr(uint16 addr);
extern char getVesaWinAAddr(uint16 *addr);
extern char getVesaWinBAddr(uint16 *addr);
extern char setVesaScanLineLength(uint16 length);
extern char getVesaScanLineLength(uint16 *bytesPerScanLine, 
				     uint16 *pixelsPerScanLine, 
				     uint16 *maxScanLines);
extern char setVesaDisplayStart(uint16 pixel, uint16 line);
extern char getVesaDisplayStart(uint16 *pixel, uint16 *line);

#endif
