/**************************************************************************/
/*                Face.Hpp : Defines one face of any object.              */
/*                           No. of points on the face can be             */
/*                           specified. The Eye position &                */
/*                           Light position have a default value          */
/*                           which can be overridden.                     */
/*                                                                        */
/*                By : Nikhil V.              Dt. : 9/23/1997.            */
/**************************************************************************/
#ifndef FACE
#define FACE

#include "point.hpp"
#include "utils.h"

// These are global variables exclusively used in this module, but probably
// changed & definately initialized in some other module dynamically.
Vector Eye;
Vector Light;

class Face {
	int 	BasicColor,                  // Dedicated palette entry.
		Visible,                     // Visibility flag.
		NumPt,                       // No. of points in the face.
		*poly,                       // Dynamic Array to hold the srcreen
		Dist;				    // coordinates.
	Point *p, *i;                     // The points.
	int calcshade() {
		Vector N = (p[0] - p[1])^(p[2] - p[1]) ; // Calculate the normal to the
		N = N.Normalize();              // Face. Use it to calculate
		Vector t = Eye*Dist - p[1];     // whether the Face can be seen
		double coseye = N*t;            // Another vector is the vector
		if(coseye <= 0) return 0;       // between eye & p[1]
								  // If not visible simply return 0.
		Vector temp = Light + Eye;
		temp = temp.Normalize();
		double dfacecol = 32.0 + 28.0*(N*Light) + 2.0*pow(temp*N, 4);
		return (int)dfacecol;            // Use Illumination model to
		}                                // calculate shade.
	void showskeleton();                  // Only the edges.
	public:
		Face(int (*points)[3], int color, int num, int dist);
		Face() {
			}
		~Face() {
			delete p;
			delete i;
			}
		void changeAng(int angl, int tilt);
		void XForm(double XMatrix[3][3]);// Transform the face.
		void show();                     // Actual shaded face.
		void erase();                    // Draw in background color.
		void reset();                    // Undo the transform.
		void chDist(int dist);
	};

void Face::changeAng(int angl, int tilt) {
	for(int j = 0; j < NumPt; j++) {       // Changing the viewing parameters
		p[j].changeAng(angl, tilt);       // of each point in the face.
		i[j].changeAng(angl, tilt);
		}
	}

void Face::chDist(int dist) {
	Dist = dist;
	for(int j = 0; j < NumPt; j++) {       // Changing the viewing parameter
		p[j].chDist(dist); 			    // of each point in the face.
		i[j].chDist(dist);
		}
	}

// points is a 2D array with num points having (x, y, z) coordinates.
// dist is the distance of the eye from the origin.
// Color is the basic color of the face. A unique palette entry.
Face::Face(int (*points)[3], int color, int num, int dist) {
	Dist = dist;
	BasicColor = color;
	Visible = 0;
	NumPt = num;
	p = new Point[NumPt];             // Initialize the data structures.
	i = new Point[NumPt];
	for(int j = 0; j < NumPt; j++) {  // Initialize the points.
		i[j] = Point(Vector(points[j][0], points[j][1],
							  points[j][2]));
		p[j] = Point(Vector(points[j][0], points[j][1],
							  points[j][2]));
		}
	Eye = Eye.Normalize();            // Global Variables. Still searching
	Light = Light.Normalize();        // for better way to do this.
	show();                           // Display.
	}

// XMatrix is the 2D array used to transform the face.
void Face::XForm(double XMatrix[3][3]) {
	for(int j = 0; j < NumPt; j++) {
		p[j].Xform(XMatrix);  // Perform Matrix transforming.
		}
	}

void Face::showskeleton() {            // Used to show only the edges.
	for(int j = 0; j < NumPt-1; j++) p[j] >> p[j+1];
	p[NumPt-1] >>p[0];
	}

void Face::show() {
	int shade = calcshade();          // Calculate the shade. If the shade
	if(!shade) {                      // is 0, then face is invisible, so
		Visible = 0;                 // simply return.
		return;
		}
	Visible = 1;                      // Else, set the visible flag.
	poly = new int[NumPt*2];          // Initialize the data structure.
	for(int j = 0; j < NumPt; j++) p[j].viewXform(poly[2*j], poly[2*j+1]);
	struct palettetype pal;           // Get the screen coordinates & set
	getpalette(&pal);                 // palette entry dedicated for the use
							    // of this face to the calculated
	setrgbpalette(pal.colors[BasicColor], shade, shade, shade); // shade.
	setcolor(BasicColor);
	setfillstyle(SOLID_FILL, BasicColor);
	fillpoly(NumPt, poly);            // Draw the polygon.
	delete poly;
	}

void Face::erase() {
	if(!Visible) return;
	poly = new int[2*NumPt];
	for(int j = 0; j < NumPt; j++) p[j].viewXform(poly[2*j], poly[2*j+1]);
	setcolor(BLACK);                  // Same as the show() method except
	setfillstyle(SOLID_FILL, M_BLACK);// the drawing color in this case is
	fillpoly(4, poly);                // Black.
	delete poly;
	}

void Face::reset() {
	for(int j = 0; j < NumPt; j++) p[j] = i[j]; // Resets to initial points.
	}

#endif
/**************************************************************************/
