/**************************************************************************/
/*           Mouse.H : Header file containing useful routines for         */
/*                     handling the mouse, which can be used by           */
/*                     any C program.                                     */
/*                                                                        */
/*           By : Nikhil V.                      Dt. : 9/23/1997.         */
/**************************************************************************/
#ifndef MOUSE
#define MOUSE

#include <dos.h>

enum m_butt {LEFT = 1, RIGHT, MIDDLE}; // Button Names. To be used in the
							    // C program.
union REGS in, out;                    // Global just because declaring in
struct SREGS s;                        // each function doesn't make sense.

int m_init() {                         // Reset driver & read status
	in.x.ax = 0;                      // AX = 0ffffh if reset successful.
	int86(0x33, &in, &out);           // BX = No.Of buttons (Generally 2)
	if(!out.x.ax) return 0;           // If reset fails, AX = 0.
	return 1;
	}

void m_show() {                        // Shows the mouse cursor.
	in.x.ax = 1;
	int86(0x33, &in, &out);
	}

void m_hide() {                        // Hides the mouse cursor. You should
	in.x.ax = 2;                      // hide the mouse cursor before any
	int86(0x33, &in, &out);           // screen update.
	}

int m_status(int &x, int &y) {         // Returns m_butt if there is any
	in.x.ax = 3;                      // button pressed, otherwise simply
	int86(0x33, &in, &out);           // returns the x, y position of the
	x = out.x.cx;                     // mouse cursor.
	y = out.x.dx;
	return out.x.bx;
	}

void m_gotoxy(int x, int y) {          // Takes the cursor to the desired
	in.x.ax = 4;                      // (x, y) location.
	in.x.cx = x;
	in.x.dx = y;
	int86(0x33, &in, &out);
	}

void m_chcursor(int far *newcursor, int hotx, int hoty) {
	in.x.ax = 9;                      // Changes the graphics curscor. The
	in.x.bx = hotx;                      // cursor hotspot can be specified.
	in.x.cx = hoty;
	segread(&s);
	s.es = FP_SEG(newcursor);
	in.x.dx = FP_OFF(newcursor);
	int86x(0x33, &in, &out, &s);
	}

void m_enclose(int minx, int miny, int maxx, int maxy) {
	in.x.ax = 7;
	in.x.cx = minx;                   // Limits the cursor boundary within
	in.x.dx = maxx;                   // a specified rectangle.
	int86(0x33, &in, &out);
	in.x.ax = 8;
	in.x.cx = miny;
	in.x.dx = maxy;
	int86(0x33, &in, &out);
	}

#endif
/**************************************************************************/
