/**************************************************************************/
/*             Point.Hpp : Just derivation of Vector to suit my           */
/*                         application.                                   */
/*                                                                        */
/*             By : Nikhil V.                   Dt : 9/23/1997.           */
/**************************************************************************/
#ifndef POINT
#define POINT

#include "vector.hpp"
#include <graphics.h>

#define StartAng 205
#define StartTlt 30
#define StartDst 750
#define MidX     200
#define MidY     200
#define Mz       500

class Point : public Vector{           // Inherited "child" class.
	int Angle, Tilt, Dist, Perspective;
	double cosA, sinA, cosB, sinB, coscos, sinsin, cosAsinB, sinAcosB;
	public:
		Point(int persp = 1):Vector() {
			Angle = StartAng;           // Constructors with plotting
			Tilt = StartTlt;             // parameters.
			Dist = StartDst;
			Perspective = persp;
			cosA = cos(StartAng*M_PI/180.0);
			sinA = sin(StartAng*M_PI/180.0);     // Calculate other parameters.
			cosB = cos(StartTlt*M_PI/180.0);
			sinB = sin(StartTlt*M_PI/180.0);
			coscos = cosA*cosB;
			sinsin = sinA*sinB;
			cosAsinB = cosA*sinB;
			sinAcosB = sinA*cosB;
			}
		Point(Vector &arg, int pers = 1):Vector(arg) {
			Angle = StartAng;                  // Initialize to random values.
			Tilt = StartTlt;
			Dist = StartDst;
			Perspective = pers;
			cosA = cos(StartAng*M_PI/180.0);
			sinA = sin(StartAng*M_PI/180.0);    // Calculate other parameters.
			cosB = cos(StartTlt*M_PI/180.0);
			sinB = sin(StartTlt*M_PI/180.0);
			coscos = cosA*cosB;
			sinsin = sinA*sinB;
			cosAsinB = cosA*sinB;
			sinAcosB = sinA*cosB;
			}
		Point(Point &arg) {
			*this = arg;             // Equate two Points
			Angle = arg.Angle;
			Tilt = arg.Tilt;
			Dist = arg.Dist;
			Perspective = arg.Perspective;
			cosA = cos(Angle*M_PI/180.0);
			sinA = sin(Angle*M_PI/180.0);
			cosB = cos(Tilt*M_PI/180.0);
			sinB = sin(Tilt*M_PI/180.0);
			coscos = cosA*cosB;
			sinsin = sinA*sinB;
			cosAsinB = cosA*sinB;
			sinAcosB = sinA*cosB;
			}
		void changeAng(int angl, int tilt) {
			Angle = angl;                 // Change the viewing (Plotting)
			Tilt = tilt;                  // parameters whenever you feel
			cosA = cos(angl*M_PI/180.0);  // like.
			sinA = sin(angl*M_PI/180.0);
			cosB = cos(tilt*M_PI/180.0);
			sinB = sin(tilt*M_PI/180.0);
			coscos = cosA*cosB;
			sinsin = sinA*sinB;
			cosAsinB = cosA*sinB;
			sinAcosB = sinA*cosB;
			}
		void chDist(int newdist) {
			Dist = newdist;
			}
		Point Xform(double XMatrix[3][3]); // Only matrix mutiplication.
		void viewXform(int &xp, int &yp) { // Mapping of x, y, z to
			double xt, yt, zt;			// screen coordinates.
			xt = x*cosA - y*sinA;
			yt = x*sinsin + y*cosAsinB + z*cosB;
			zt = Dist + x*sinAcosB + y*coscos - z*sinB;
			if(Perspective && fabs(zt) > 0.001) {
				xp = MidX - floor(Mz*xt/zt + 0.5);
				yp = MidY - floor(Mz*yt/zt + 0.5);
				return;
				}
			xp = MidX - floor(xt+0.5);
			yp = MidY - floor(yt+0.5);
			}
		void operator >>(Point &arg) {     // Draws a line between the arg
			int xp1, yp1, xp2, yp2;       // and the current Point using
			(*this).viewXform(xp1, yp1);  // the viewing transforms.
			arg.viewXform(xp2, yp2);
			line(xp1, yp1, xp2, yp2);
			}
	};

Point Point::Xform(double XMatrix[3][3]) {
	double t[3];                      // Matrix multiplication with the
	for(int i = 0; i < 3; i++) {      // transform matrix.
		t[i] = x*XMatrix[i][0] + y*XMatrix[i][1] + z*XMatrix[i][2];
		}
	x = t[0];
	y = t[1];
	z = t[2];
	return *this;                     // Return the transformed point.
	}

#endif
/**************************************************************************/
