/***************************************************************************/
/*            Utils.H : Header file to hold all the misc routines          */
/*                      & declarations. Also the include header files.     */
/*                                                                         */
/*            By : Nikhil V.                       Dt. : 9/23/1997.        */
/***************************************************************************/
#ifndef UTILS
#define UTILS

#include <math.h>
#include <graphics.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "point.hpp"

// Defining my own names for the palette entries. It is encouraged while
// writing programs which might manipulate the system palette.
enum Color {BACKGROUND, M_BLACK, M_FAC1, M_FAC2, M_FAC3, M_FAC4, M_FAC5,
		  M_LIGHTGRAY, M_DARKGRAY, M_FAC6, RES1, RES2, RES3, RES4,
		  RES5, M_WHITE};

// Just names for three axes.
enum Axes {XAXIS, YAXIS, ZAXIS};

// Defining faces having 4 vertices.
int face1[4][3] = {{0, 0, 0}, {0, 0, 100}, {100, 0, 100}, {100, 0, 0}};          //
int face2[4][3] = {{0, 0, 0}, {100, 0, 0}, {100, 100, 0}, {0, 100, 0}};          //
int face3[4][3] = {{0, 0, 0}, {0, 100, 0}, {0, 100, 100}, {0, 0, 100}};          //
int face4[4][3] = {{100, 100, 100}, {100, 100, 0}, {100, 0, 0}, {100, 0, 100}};  //
int face5[4][3] = {{100, 100, 100}, {100, 0, 100}, {0, 0, 100}, {0, 100, 100}};  //
int face6[4][3] = {{100, 100, 100}, {0, 100, 100}, {0, 100, 0}, {100, 100, 0}};  //

// This routines turns the matrix passed to it into a transform matrix
// depending on a control flag.
void makeXMatrix(Axes axis, double angle, double XMatrix[3][3]) {
	double cosang = cos(angle*M_PI/180.0), sinang = sin(angle*M_PI/180.0);
	for(int i = 0; i < 3; i++) {
		for(int j = 0; j < 3; j++) {
			XMatrix[i][j] = 0;  // Zero out the matrix.
			}
		}
	switch(axis) {
		case XAXIS : XMatrix[0][0] = 1;
				   XMatrix[1][1] = cosang;
				   XMatrix[2][2] = cosang;
				   XMatrix[1][2] = sinang;
				   XMatrix[2][1] = -sinang;
				   break;
		case YAXIS : XMatrix[1][1] = 1;
				   XMatrix[0][0] = cosang;
				   XMatrix[2][2] = cosang;
				   XMatrix[0][2] = sinang;
				   XMatrix[2][0] = -sinang;
				   break;
		case ZAXIS : XMatrix[2][2] = 1;
				   XMatrix[1][1] = cosang;
				   XMatrix[0][0] = cosang;
				   XMatrix[0][1] = sinang;
				   XMatrix[1][0] = -sinang;
				   break;
		}
	}

//
struct fillsettingstype fillinfo;
int col, bkcol;
struct viewporttype viewinfo;

// Save the current graphics state & restore it afterwords.
void savestate() {
	getfillsettings(&fillinfo);
	col = getcolor();
	bkcol = getbkcolor();
	getviewsettings(&viewinfo);
	}

void restorestate() {
	setfillstyle(fillinfo.pattern, fillinfo.color);
	setcolor(col);
	setbkcolor(bkcol);
	}

// Draw the lines between origin & 3 pts along 3 coordinate axes.
void showaxes(Point &Origin, Point &X, Point &Y, Point &Z) {
	setcolor(WHITE);
	Origin >> X;
	Origin >> Y;
	Origin >> Z;
	}

// Matrix Calculations
// Turn the given matrix into 3X3 identity matrix.
void makeIdMat(double mat[3][3]) {
	for(int i = 0; i < 3; i++) {
		for(int j = 0; j < 3; j++) {
			if(i == j) mat[i][j] = 1;
			else mat[i][j] = 0;
			}
		}
	}

// Multiply 2 matrices, mat1 = mat1*mat2.
void matMult(double mat1[3][3], double mat2[3][3]) {
	double mat[3][3] = {0};
	for(int i = 0; i < 3; i++) {
		for(int j = 0; j < 3; j++) {
			for(int k = 0; k < 3; k++) mat[i][j] += mat1[i][k]*mat2[k][j];
			}
		}
	for(i = 0; i < 3; i++) {
		for(int j = 0; j < 3; j++) {
			mat1[i][j] = mat[i][j];
			}
		}
	}

#endif
/***************************************************************************/
