/*****************************************************************************
*   Module to handle screen printing.					     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 1.0,	Dec. 1989    *
*****************************************************************************/

#include <stdio.h>
#include "program.h"
#include "igraph.h"
#include "eestring.h"

static void PutTextInfoNoCentering(int PosX, int PosY, char *Str);

/*****************************************************************************
* Put out a string, always centered to the given position, with given	     *
* orientation, taking into account current zoom factor.			     *
*****************************************************************************/
void PutTextInfo(TextOrientationType Orient, int PosX, int PosY, int Scale,
								char *Str)
{
    IGTextFormat(Orient, Scale, TEXT_X_CENTER, TEXT_Y_CENTER);
    IGMoveTo(PosX, PosY);
    IGText(Str);
    IGTextFormat(TEXT_ORIENT_HORIZ, 1, TEXT_X_CENTER, TEXT_Y_CENTER);
}

/*****************************************************************************
* Same as PutTextInfo but does no centering.				     *
*****************************************************************************/
static void PutTextInfoNoCentering(int PosX, int PosY, char *Str)
{
    IGMoveTo(PosX, PosY);
    IGText(Str);
    IGTextFormat(TEXT_ORIENT_HORIZ, 1, TEXT_X_CENTER, TEXT_Y_CENTER);
}

/*****************************************************************************
* Put out pin number and pin text info, given the pin line coordinates.	     *
* The line must be vertical or horizontal.				     *
* If PinNext == NULL nothing is printed. If PinNum = 0 no number is printed. *
* Current Zoom factor is taken into account.				     *
* If TextInside then the text is been put inside (moving from x1, y1 in      *
* the opposite direction to x2, y2), otherwise all is drawn outside.	     *
*****************************************************************************/
void PutLineTextInfo(int x1, int y1, int x2, int y2, char *PinText, int PinNum,
				BooleanType TextInside, BooleanType DrawNums)
{
    int x, y;
    BooleanType IsNot;
    char SPinNum[MAX_PIN_INFO];

    /* Do we need to invert the string? Is this string has only "~"? */
    if (PinText != NULL && (IsNot = PinText[0] == '~') != FALSE) {
    	PinText++;
	if (PinText[0] == 0) PinText = NULL;
    }

    if (TextInside) {  /* Draw the text inside, but the pin numbers outside. */
	if (x1 != x2) {				  /* Its an horizontal line. */
	    if (PinText != NULL) {
		if (x1 > x2) {
		    IGTextFormat(TEXT_ORIENT_HORIZ, 1,
				 TEXT_X_LEFT, TEXT_Y_CENTER);
		    x = x1 + TextInside;
		    PutTextInfoNoCentering(x, y1, PinText);
		    if (IsNot) {
	    	        IGDrawNotBar(
			    IGMapX(x),
			    IGMapY(y1) - IGTextHeightNoMap(PinText) / 2 - 2,
			    IGTextWidthNoMap(PinText),
		    	    0,
		    	    PinText);
		    }
		}
		else {
		    IGTextFormat(TEXT_ORIENT_HORIZ, 1,
				 TEXT_X_RIGHT, TEXT_Y_CENTER);
		    x = x1 - TextInside;
		    PutTextInfoNoCentering(x, y1, PinText);
		    if (IsNot) {
	    	        IGDrawNotBar(
			    IGMapX(x),
			    IGMapY(y1) - IGTextHeightNoMap(PinText) / 2 - 2,
			    -IGTextWidthNoMap(PinText),
		    	    0,
		    	    PinText);
		    }
		}
	    }
	    if (PinNum != 0 && DrawNums) {
		IGTextFormat(TEXT_ORIENT_HORIZ, 1,
			     TEXT_X_CENTER, TEXT_Y_BOTTOM);
		sprintf(SPinNum, "%d", PinNum);
		PutTextInfoNoCentering((x1 + x2) / 2, y1 + 1, SPinNum);
	    }
	}
	else {					     /* Its a vertical line. */
	    if (PinText != NULL) {
		if (y1 > y2) {
		    IGTextFormat(TEXT_ORIENT_VERT, 1,
				 TEXT_X_CENTER, TEXT_Y_TOP);
		    y = y1 + TextInside;
		    PutTextInfoNoCentering(x1, y, PinText);
		    if (IsNot) {
	    	        IGDrawNotBar(
			    IGMapX(x1) - IGTextHeightNoMap(PinText) / 2 - 2,
			    IGMapY(y),
			    0,
		    	    IGTextWidthNoMap(PinText),
		    	    PinText);
		    }
		}
		else {
		    IGTextFormat(TEXT_ORIENT_VERT, 1,
				 TEXT_X_CENTER, TEXT_Y_BOTTOM);
		    y = y1 - TextInside;
		    PutTextInfoNoCentering(x1, y, PinText);
		    if (IsNot) {
	    	        IGDrawNotBar(
			    IGMapX(x1) - IGTextHeightNoMap(PinText) / 2 - 2,
			    IGMapY(y),
			    0,
		    	    -IGTextWidthNoMap(PinText),
		    	    PinText);
		    }
		}
	    }
	    if (PinNum != 0 && DrawNums) {
		IGTextFormat(TEXT_ORIENT_VERT, 1, TEXT_X_RIGHT, TEXT_Y_CENTER);
		sprintf(SPinNum, "%d", PinNum);
		PutTextInfoNoCentering(x1 - 1, (y1 + y2) / 2, SPinNum);
	    }
	}
    }
    else {				       /* Draw text outside as well. */
	if (x1 != x2) {				  /* Its an horizontal line. */
	    if (PinText != NULL) {
		IGTextFormat(TEXT_ORIENT_HORIZ, 1,
			     TEXT_X_CENTER, TEXT_Y_BOTTOM);
		PutTextInfoNoCentering(x = (x1 + x2) / 2, y1 - 1, PinText);
		if (IsNot) {
	    	    IGDrawNotBar(
	    		IGMapX(x) - IGTextWidthNoMap(PinText) / 2,
			IGMapY(y1) - IGTextHeightNoMap(PinText) - 3,
	    		IGTextWidthNoMap(PinText),
			0,
		    	PinText);
		}
	    }
	    if (PinNum != 0 && DrawNums) {
		IGTextFormat(TEXT_ORIENT_HORIZ, 1, TEXT_X_CENTER, TEXT_Y_TOP);
		sprintf(SPinNum, "%d", PinNum);
		PutTextInfoNoCentering((x1 + x2) / 2, y1 + 10, SPinNum);
	    }
	}
	else {					     /* Its a vertical line. */
	    if (PinText != NULL) {
		IGTextFormat(TEXT_ORIENT_VERT, 1, TEXT_X_RIGHT, TEXT_Y_CENTER);
		PutTextInfoNoCentering(x1 - 2, y = (y1 + y2) / 2, PinText);
		if (IsNot) {
	    	    IGDrawNotBar(
		        IGMapX(x1) - 11,
			IGMapY(y) - IGTextHeightNoMap(PinText) / 2,
			0,
		        IGTextWidthNoMap(PinText),
		    	PinText);
		}
	    }
	    if (PinNum != 0 && DrawNums) {
		IGTextFormat(TEXT_ORIENT_VERT, 1, TEXT_X_LEFT, TEXT_Y_CENTER);
		sprintf(SPinNum, "%d", PinNum);
		PutTextInfoNoCentering(x1 + 10, (y1 + y2) / 2, SPinNum);
	    }
	}
    }
}
