/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Some widgets
*/

#include <sys/stat.h>
#include "widgets.h"

Window	*FileDialog::wnd;

void ListBox::draw(void)
{
	int i,j,a=fpol;

    wnd->WindowRect(x-2,y-2,onew*polx+4,oneh*poly+4,CWHITE);
    wnd->WindowBox(x,y,onew*polx,oneh*poly,wnd->GetPaper());
    if (count==0) return;
	for(i=0;i<poly;i++) for(j=0;j<polx;j++)
	{
		kresli(x+j*onew, y+i*oneh, fpol*polx+i*polx+j, 0, dataptr);
		if (count==++a)
        {
			kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
            return;
        }
    }
	kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
}

void ListBox::Up(void)
{
	if (curr>=polx)
	{
		kresli(x+cx*onew, y+cy*oneh, curr, 0, dataptr);
		if (cy>0) cy--;
		else if (fpol>0)
		{
			fpol--;
            if (poly>1) wnd->WindowScrollDown(x,y,polx*onew,(poly-1)*oneh,oneh);
			for(int i=0; i<polx; i++) kresli(x+i*onew, y, fpol*polx+i, 0, dataptr);
        }
		curr = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
	}
}

void ListBox::Down(void)
{
	if ((curr+polx)<=(count-1))
	{
		kresli(x+cx*onew, y+cy*oneh, curr, 0, dataptr);
		if (cy<poly-1) cy++;
		else
		{
			fpol++;
            if (poly>1) wnd->WindowScrollUp(x,y+oneh,polx*onew,(poly-1)*oneh,oneh);
			for(int i=0; i<polx; i++) kresli(x+i*onew, y+(poly-1)*oneh, fpol*polx+(poly-1)*polx+i, 0, dataptr);
        }
		curr = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
	}
}

void ListBox::Right(void)
{
	if (curr<(count-1))
	{
		kresli(x+cx*onew, y+cy*oneh, curr, 0, dataptr);
		if (cx<(polx-1)) cx++;
        else if (cy<(poly-1)) { cx = 0; cy++; }
		else
		{
			fpol++;
            if (poly>1) wnd->WindowScrollUp(x,y+oneh,polx*onew,(poly-1)*oneh,oneh);
			for(int i=0; i<polx; i++) kresli(x+i*onew, y+(poly-1)*oneh, fpol*polx+(poly-1)*polx+i, 0, dataptr);
			cx= 0 ;
		}
		curr = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
	}
}

void ListBox::Left(void)
{
	if (curr>0)
	{
		kresli(x+cx*onew, y+cy*oneh, curr, 0, dataptr);
		if (cx>0) cx--;
        else if (cy>0) {cy--; cx=polx-1; }
        else
        {
        	if (fpol)
        	{
        		fpol--;
	            if (poly>1) wnd->WindowScrollDown(x,y,polx*onew,(poly-1)*oneh,oneh);
				for(int i=0; i<polx; i++) kresli(x+i*onew, y, fpol*polx+i, 0, dataptr);
	        	cx=polx-1;
			}
        }
		curr = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
	}
}

void ListBox::SetToItem(int a)
{
	int komplet = 0;

	if (a==curr || a>=count || a<0) return;
	kresli(x+cx*onew, y+cy*oneh, curr, 0, dataptr);
	cx = a%polx;
	if (a<fpol || a>=(fpol+poly))
	{
		fpol = (a-cx)/polx;
		cy = 0;
		komplet = 1;
	}
	else cy = a-fpol;
	curr = (fpol+cy)*polx+cx;
	if (komplet) draw();
	else kresli(x+cx*onew, y+cy*oneh, curr, 1, dataptr);
}

void ListBox::SetToItemRel(int a)
{
	if (a==0) return;
	if (a>0) for(;a--;) Right();
	else for(;a++<0;) Left();
}

void ListBox::Resize(int kolko)
{
   	if ((count+kolko)<0) count = 0;
	else count += kolko;
	while(curr>(count-1) && curr>0)
	{
		if (cx>0) cx--;
        else if (cy>0) {cy--; cx=polx-1; }
	    else { fpol=0; cx=polx-1; }
		curr = (fpol+cy)*polx+cx;
	}
	draw();
	if (count) RedrawItem();
}

int ListBox::Test(int ccx, int ccy)
{
	int c;
	if (count<1) return -1;
	if (ccx<x || ccx>=(x+onew*polx)) return -1;
	if (ccy<y || ccy>=(y+oneh*poly)) return -1;
	c = ((ccy-y)/oneh)*polx + (ccx-x)/onew + fpol*polx;
	if (c>=count) return -1;
	return c;
}

void ListBox::SetSize(int kolko)
{
	Resize(kolko-count);
}
FileDialog *FileDialog::instance=0;
char FileDialog::path[256];
char FileDialog::tmppath[256];

int FileDialog::Selected(void)
{
	char tmp[256+64];
	char tmp2[256];
	int retval=0;
	
	strcpy(tmp,path);
#ifdef __MSDOS__
	if (strlen(tmp)>3) strcat(tmp,"\\");
#else
	if (strlen(tmp)>1) strcat(tmp,"/");
#endif
        if (filename[0]=='.' && filename[1]=='.' && filename[2]!=0)
                strcpy(filename, filename+2);
	strcat(tmp, filename);
	getcwd(tmp2, 255);
	retval = chdir(tmp);
	if (retval!=0 && (filename[0]=='/'|| filename[0]=='\\' || filename[1]==':'))
	{
		retval=chdir(filename); // try absolute path
		if (retval==0)
		strcpy(tmp,filename);
	}
	chdir(tmp2);
	if (retval==0)
	{
		Refresh(tmp);
		return FALSE;
	}
	else if (fileselect)
	{
		FILE *fp=fopen(tmp, "r");  // if exists ..
		if (fp) fclose(fp);
		if (mode&FDIALOG_OPEN)
		{
			if (fp)
			{
				fileselect(tmp);
				return TRUE;
			}
		}
		else
		{
			fileselect(tmp);
			return TRUE;
		}
	}
	return FALSE;
}

void FileDialog::Refresh(char *newpath)
{
	strcpy(path, newpath);
	int old = files;
	reload();
	list->SetToItem(0);
	list->Resize(files-old);
	list->draw();
}

void FileDialog::myproc(GuiEvent *p)
{
	switch(p->Type())
	{
		case KEYEVENT: switch(p->Key())
		{
			case ' ':
				instance->nameEBox->ClickUp(1);
				break;
			case KUP:
				instance->list->Up();
				break;
			case KDOWN:
				instance->list->Down();
				break;
			case PGUP:
				instance->list->SetToItemRel(-10);
				break;
			case PGDOWN:
				instance->list->SetToItemRel(10);
				break;
			case HOME:
				instance->list->SetToItem(0);
				instance->list->draw();
				break;
			case CR:
				if (!instance->Selected()) break;
			case ESC:
				if (wnd) delete wnd;
				break;
		}
		break;
		
		case CLICKLEFTEVENT:
		{
			int x=(p->GetX()-8)/168, y=(p->GetY()-34)/16;
			if (x==0 && y>=0 && y<=9)
			{
				instance->list->SetToItemRel(y - (instance->list->GetCurrent() - instance->list->GetFirstVisible()));
				if (!instance->Selected()) break;
				if (wnd) delete wnd;
			}
		}
		break;

		case INPUTEVENT1:
		{
			if (!instance->Selected()) break;
			if (wnd) delete wnd;
		}
		break;
		
		case BUTTONHOLDEVENT:
			if (p->Key() == instance->up->GetId()) instance->list->Up();
			if (p->Key() == instance->down->GetId()) instance->list->Down();
			break;
		case ACCELEVENT:
			if (p->Key() == instance->nameEBox->GetId()) break;
			else if (p->Key() == instance->ok->GetId())
			{
				if (ininput)
				{
					ininput->inputproc(CR);
					return;
				}
				else if (!instance->Selected()) break;
			}
			if (wnd) delete wnd;
			break;
	}
}

void FileDialog::drawone(int x, int y, int c, int flg, void *ptr)
{
	FileDialog *p = (FileDialog *) ptr;
	char name[32];
 	int fnt=set_font(2);

	sprintf(name, "%.20s",  p->filebuffer[c].d_name);
	if (!flg)
	{
		p->wnd->WindowBox(x,y,168,16,p->wnd->GetPaper());
		p->wnd->WindowText(x+4,y,name, p->wnd->GetInk(), p->wnd->GetPaper());
	}
	else
    {
		p->wnd->WindowBox(x,y,168,16,p->wnd->GetInk());
        p->wnd->WindowText(x+4,y,name, p->wnd->GetPaper(), p->wnd->GetInk());
        strcpy(p->filename, p->filebuffer[c].d_name);
        if (p->filename[0]=='.')
        {
        	p->filename[2]=0;
            p->nameEBox->ChangeItem(p->filename+2);
        }
        else
		{
			p->nameEBox->ChangeItem(p->filename);
			struct stat s;
			getcwd(p->tmppath, 255);
			chdir(p->path);
			stat(p->filename, &s);
			chdir(p->tmppath);
			set_fcolor(wnd->GetPaper());
			wnd->WindowBox(188,140,170,40);
			wnd->SetColors();
			set_font(1);
			wnd->printf(188,164,"Size: %9d bytes\n", s.st_size);
			char *ss = ctime(&s.st_atime)+4;
			ss[strlen(ss)-1] = 0;
			wnd->WindowText(188,180, ss);
		}
    }
	set_font(fnt);
}

void FileDialog::reload(void)
{
	DIR *dirp;
	struct dirent *direntp;
	int i = 0, j=0, ne=0, q=0;
	char extensions[64][10], *p=filter;

	files = 0;
	getcwd(tmppath, 255);
	chdir(path);
	getcwd(path, 255);  // reload path string in case "."
	dirp = opendir(path);

	if (dirp == NULL) return;
	else
	{	// expand filters
		if (p)
		{
			while(*p)
			{
				extensions[ne][j] = *p;
				if (*p==' ' || j==9)
				{
					extensions[ne++][j]=0;
					j=0;
					if (ne==64) break;
				}
				else j++;
				p++;
			}
			extensions[ne++][j]=0;
		}

		for (;;)
		{
			direntp = readdir(dirp);
			if (direntp == NULL) // finale
				break;
			if (strcmp(direntp->d_name, "."))
			{
				if (ne) for(q=0;q<ne;q++)
				{
					if (strstr(direntp->d_name, extensions[q])) break;
				}
				if (ne && q==ne && strcmp(direntp->d_name, ".."))
				{
					if (chdir(direntp->d_name)==0)
					{
						chdir(".."); // yes it is a dir
					}
					else continue; // no valid extension
				}
				memcpy(filebuffer+i, direntp, sizeof(struct dirent));
				if (++i == maxfiles)
				{
					maxfiles += maxfiles;
					memory = new char[maxfiles*sizeof(dirent)];
					memcpy(memory, filebuffer, i*sizeof(dirent));
					filebuffer = (struct dirent *) memory;
					delete memory;
				}
			}
		}
		closedir(dirp);
	}
	files = i;
	chdir(tmppath);
	return;
}

FileDialog::FileDialog(void (*filesel)(char *), char *dir, char *flt, char *namewnd, int m, int ink, int paper)
{
 	int fnt=set_font(2);

	if (instance)
	{
		delete instance;
	}
	instance = this;
	maxfiles = 256;
	memory = new char[maxfiles*sizeof(dirent)];
	filebuffer = (struct dirent *) memory;
	fileselect = filesel;
	if (!(m&FDIALOG_SAVEDIR && path[0]))
		if (dir) strcpy(path, dir); 
		else getcwd(path, 255);
	filter = flt;
	mode = m;
	wnd = new Window(&wnd, 100,100,373,230, namewnd, myproc, ink, paper, WCLICKABLE|WUSELAST|WSTANDARD+WMODAL*(m&FDIALOG_MODAL?1:0));
	set_font(1);
	wnd->WindowText(188,62,"press SPACE for",CGREEN);
	wnd->WindowText(188,72,"enter filename,",CGREEN);
	wnd->WindowText(188,82,"arrows and ENTER",CGREEN);
	wnd->WindowText(188,92,"to select file",CGREEN);
	reload();
	strcpy(filename, "");
	nameEBox = wnd->AddEditBox(6,6,0,172,"Name",'N',filename,0);
	list = new ListBox(8,34,1,10,168,16, files,drawone,wnd,this);
	list->Down();
	ok = wnd->AddPushButton(188,6,80,21,"OK");
	cancel = wnd->AddPushButton(276,6,80,21,"CANCEL");
	up = wnd->AddPushButton(188,32,80,21,"UP");
	down = wnd->AddPushButton(276,32,80,21,"DOWN");
	set_font(fnt);
}

void ProgressBar::draw(void)
{
	int tmp;
	char s[10];
 	int fnt=set_font(2);

	tmp = (int)((w/(float)steps)*value);
	if (tmp!=sirka) // changed
	{
		wnd->WindowBox(x,y,tmp,h,bg);
		wnd->WindowBox(x+tmp,y,w-tmp,h,fg);
		sprintf(s,"%d%%", (int)((100./steps)*value));
		set_ppop(_GNOT);
		wnd->WindowText(x+w/2-strlen(s)*4,y+h/2-8,s,bg,fg);
	}
	sirka = tmp;
	set_font(fnt);
	set_ppop(_GSET);
}

ProgressBar::ProgressBar(Window *win, int xx, int yy, int ww, int hh, int s)
{
	wnd = win;
	x   = xx;
	y   = yy;
	w   = ww;
	h   = hh;
	steps = s;
	value = 0;
	sirka = -1;
	fg = CWHITE;
	bg = CBLUELIGHT;
	wnd->WindowRect(x-2,y-2,w+4,h+4,CWHITE);
	wnd->WindowRect(x-2,y-2,w+3,h+3,CBLACK);
	wnd->WindowRect(x-1,y-1,w+1,h+1,CBLACK);
	wnd->WindowRect(x,y,w+1,h+1,CWHITE);
	draw();
}

//#define TEST
#ifdef TEST
void dummy(char *)
{
}

void dummy2(int)
{
}

int main(int argc, char **argv)
{
	App app(4,argc, argv, 0, APP_ENABLEALTX);
	Window *w; 
	new Window(&w,100,100,200,190,"");
	SlideBar(w, 10,100,180,24,1,100,100,10, dummy2);
	ProgressBar p(w,20,20,152,30,80);
	FileDialog *a = new FileDialog(dummy, ".", ".gpr","Otvor Subor", FDIALOG_SAVE|FDIALOG_MODAL);
	p.setProgress(75);
	app.Run();
	delete a;
	delete w;
	return 0;
}
#endif

// -----------------------------------------------------------------------


