/* play.c - play a fli until key is hit. */

#include "aafli.h"

main(int argc, char *argv[])
{
int ivmode;
Errval err;

if (argc != 2)		/* If command line looks wrong give a little help */
	{
	puts("Play will play a FLI file until a key is hit");
	puts("Example usage: play pretty.fli");
	}
else
	{
	ivmode = dos_get_vmode();		/* Get video mode so can restore at exit */
	dos_set_vmode(0x13);			/* Go into 320x200 256 color mode */
	if (dos_get_vmode() == 0x13)
		{
		err = fli_play(argv[1]);
		dos_set_vmode(ivmode);
		if (err < AA_SUCCESS)
			puts(fli_error_message(err) );
		}
	else
		puts("Not a vga/mcga display");
	}
}
