;======== GRAFSYS COMMAND FILE "INITOPT.CMD" =========

;-------- INITIALIZE ALL GRAFSYS OPTIONS ---------

;Copyright 1990 by Francis J. Deck.  All rights reserved.
;See copyright notice in documentation file GRAFSYS.DOC.

;Warning:  This file contains the data for initializing all of the user
;options in GRAFSYS.  When GRAFSYS starts up, it reads this initialization
;file.  You can change this file but be careful.  If you delete a line, that
;option will not be initialized, and a failure can result.  It is better to
;override these options by creating a second command file.

;A word on pathnames:  Some of the filenames below include the style bar
;e.g. FONT '|GRAFSYS.FNT'.  GRAFSYS replaces the style bar with the
;directory where GRAFSYS.EXE and the other system files are located.
;This will not interfere with any user file names, since the style bar
;is reserved by DOS for pipes anyway.

;--------Device color maps--set up for general monochrome operation.

;Each colormap entry consists of a device name, "user" color, and then
;"device" color.  The user color is used in any reference to color inside
;a command file (e.g. FITLINE command), or in a menu.  The device color
;is the actual color code sent to the output device, and varies from
;device to device.

;Screen:  Device colors are integers, and are the color codes for your screen.
;         Note that here, black and white are reversed, compared to the other
;         color maps.

COLORMAP SCRN 0 0       ;Black
COLORMAP SCRN 1 15      ;White
COLORMAP SCRN 2 1       ;Blue
COLORMAP SCRN 3 2       ;Green
COLORMAP SCRN 4 4       ;Red

;Postscript:  Device colors are "gray" scales from 0 to 1, with 0 being
;black ink, and 1 being white paper.

COLORMAP POST 0 1       ;White
COLORMAP POST 1 0       ;Black
COLORMAP POST 2 0       ;Black
COLORMAP POST 3 0       ;Black
COLORMAP POST 4 0       ;Black

;HP:  Device colors are pen numbers.  If you are using PrintGL, you can
;assign different pen numbers to different line widths.

COLORMAP HP 1 1         ;Pen 0
COLORMAP HP 2 2         ;Pen 1
COLORMAP HP 3 3         ;Pen 2
COLORMAP HP 4 4         ;Pen 3

BACKGROUND 0            ;User color, should be black on screen.
MENUCOLOR 1             ;User color, for all text (non graphics) operation.

;-------- DEVICE OUTPUT PATHS --------

;These are the names of the files to which graphics output will be
;sent.  The pathname may be any valid DOS path, or logical device name.

DEVICEPATH SCRN 'NUL'           ;Don't change this one.
DEVICEPATH DMP 'PRN'            ;Printer logical device
DEVICEPATH HP 'OUT.PLT'         ;HP Pen Plotter
DEVICEPATH POST 'OUT.PS'        ;Postscript device

;-------- SPECIAL DEVICE OPTIONS

HPPENSPEED 38.1 ;Pen speed for HP plotter in cm/s
RESOLUTION LOW  ;Could be LOW (60 X 72) or HIGH (120 X 72)

;-------- DEVICE INDEPENDENT OPTIONS ----

FONT '|GRAFSYS.FNT'     ;GRAFSYS built-in font for all devices.

PLOTTITLE ''            ;Title of plot

AXISLABEL X ''          ;X-axis label
AXISLABEL Y ''          ;Y-axis label

LABELUNITS X ''         ;X-axis units
LABELUNITS Y ''         ;Y-axis units

SCALE X LINEAR          ;linear x-axis scale
SCALE Y LINEAR          ;linear y-axis scale

LOGFLOOR X 0            ;All numbers below this value will be converted
                        ;to this value prior to log conversion.
LOGFLOOR Y 0            ;If the log floor is zero or less, then an error
                        ;will result if you select log or dB scaling
                        ;and there is a nonpositive value to convert.

REVERSEAXIS X NO        ;reverse the x-axis? no.
REVERSEAXIS Y NO

EXPLABELS X NO          ;x-axis numeric labels format
EXPLABELS Y NO

NUMLABSTYLE X NUMTICK   ;Numeric labels style:  Numbers and tick marks
NUMLABSTYLE Y NUMTICK

EBARFMT BARANDCAPS      ;Error bar format:  Bar and end caps.

ZEROAXIS X NO           :Do we draw an X=0 axis line?
ZEROAXIS Y NO

GRIDLINES X NO          ;Do we draw "grid" lines in plot area?
GRIDLINES Y NO

FULLBOX YES             ;Do axis lines form full box around plot area?
UPPERTICKS YES          ;Do we draw tick marks in upper box?

RANGING X AUTO          ;X autoranging.
RANGING Y AUTO

NLABELS X 5             ;First approximation for number of ruler numbers
NLABELS Y 5

MINORTICK X 5           ;Number of minor tick marks between ruler numbers.
MINORTICK Y 5

DISPTICKS X 0.0         ;Fraction of tick mark displaced outside plot box.
DISPTICKS Y 0.0

BORDER NO               ;Border around entire plot?

RULERENDS X LABELS      ;Force labels at ends of rulers?  Yes.
RULERENDS Y LABELS

RULERTICKSIZE 0.1       ;Length of tick mark on ruler.  Minor tick 1/2 this.
PLOTSYMBSIZE 0.075      ;Size of plot symbol.
NEEDLEBASE 0.0          ;Baseline for bottom of "needle" plot symbol.
FINESPACING 0.08        ;Small amount of space between things for readability.

;All text attributes are character height followed by user color.

AXISTEXT 0.2  1        ;Axis labels
RULERTEXT 0.15 1       ;Ruler numbers
TITLETEXT 0.25 1       ;Plot title

;Appearance of text

TEXTPENRATIO 0.13       ;Ratio of text pen width to character height
FONTLEADING 0.5         ;Ratio of space between characters to char. ht.

;All line attributes are width, pattern, then user color.

BORDERLINE 0.020 SOLID 1        ;Border around plot
AXISLINE 0.020 SOLID 1          ;Plot axis lines
PLOTSYMBLINE 0.020 SOLID 1      ;Plot symbols
PLOTLINE 0.020 NONE 1           ;Pen width for line plot
TICKLINE 0.020 SOLID 1          ;Ruler tick mark
GRIDLINE  0.010 DOTS 1          ;Grid lines on plot

ORIENTATION LANDSCAPE           ;Alternative is Portrait
ORIGIN 0.5 0.5                  ;Used to shift entire plot on page.
SCRNSIZE 8.25 5.875             ;How big is your screen's active graphics area.

;The following options take effect for any subsequent DATAFILE command.
;They can be executed multiple times.  The idea is to set up all these
;options for a particular data file, then use the DATAFILE command to read
;the file.

INCLUDE YES             ;Include subsequent data file during autoranging?
GROUPSCALING 0 1 0 1    ;Scaling constants for next data group.
PLOTSYMBOL NONE         ;Plot symbol for next data group.
FILLSYMBOL YES          ;We fill the plot symbol with color.
ERRBARSHOW YES          ;We show the error bars for the next group

END                     ;End this command file without killing GRAFSYS

;The alternative to END is QUIT, which ends the command file, and
;returns control to DOS.
