/*
 * NAME dither.h - header file for Floyd-Steinberg dithering
 *
 * DESCRIPTION See header for dither.c.
 */


/* TYPEDEFS */
typedef struct
{
  BYTE minIn;			/* minimum input value */
  BYTE maxIn;			/* maximum input value */
  BYTE minOut;			/* minimum output value */
  BYTE maxOut;			/* maximum output value */
  int numCols;			/* number of columns per row */
  ulong scale;			/* scale factor for thresholding inflated by
				 * InflateBase */
  ulong invscale;		/* inverse scale factor */
  int *oddRowErrs;		/* array holding odd row errors */
  int *evenRowErrs;		/* array holding even row errors */
} DCtrlType;
/* FUNCTION PROTOTYPES */
int
DitherInit (
	     BYTE minIn,	/* minimum input value */
	     BYTE maxIn,	/* maximum input value */
	     BYTE minOut,	/* minimum output value */
	     BYTE maxOut,	/* maximum output value */
	     int numCols,	/* number of columns in each row */
	     DCtrlType * pCtrl	/* structure with control parameters */
);
     void Dither (
		    DCtrlType * pCtrl,	/* structure with
					 * control parameters */
		    int *pIn,	/* input values */
		    int *pOut,	/* output values */
		    int OddRow	/* TRUE => current row
				 * is odd-numbered */
);
     void DitherTerm (
		        DCtrlType * pCtrl	/* structure with
						 * control parameters */
);
