# ---------------------------------------------------------------------
# icondraw.mak
#
# Microsoft C 6.00a makefile for icondraw by Bill Buckels 1999
#
# Note:
#
# The utility program PCXARRAY.EXE (C) Bill Buckels is required
#   to convert the 320 x 200 x 4 Color CGA PCX Screen Files to Source Code.
# This utility is called from this makefile and is provided with
#   the icondraw package as freeware without restrictions.
# ---------------------------------------------------------------------
all: ..\icondraw.exe

icontit.obj: icontit.pcx isorry.pcx iconbye.pcx drawmenu.pcx director.pcx
   pcxarray ICONTIT.PCX
   cl -c -AL -Zp1 icontit.c
   del icontit.c

isorry.obj: icontit.pcx isorry.pcx iconbye.pcx drawmenu.pcx director.pcx
   pcxarray ISORRY.PCX
   cl -c -AL -Zp1 isorry.c
   del isorry.c

iconbye.obj: icontit.pcx isorry.pcx iconbye.pcx drawmenu.pcx director.pcx
   pcxarray ICONBYE.PCX
   cl -c -AL -Zp1 iconbye.c
   del iconbye.c

drawmenu.obj: icontit.pcx isorry.pcx iconbye.pcx drawmenu.pcx director.pcx
   pcxarray DRAWMENU.PCX
   cl -c -AL -Zp1 drawmenu.c
   del drawmenu.c

director.obj: icontit.pcx isorry.pcx iconbye.pcx drawmenu.pcx director.pcx
   pcxarray DIRECTOR.PCX
   cl -c -AL -Zp1 director.c
   del director.c

icondraw.lib: icontit.obj isorry.obj iconbye.obj drawmenu.obj director.obj
   lib icondraw -+ icontit,,
   del icontit.obj
   lib icondraw -+ isorry,,
   del isorry.obj
   lib icondraw -+ iconbye,,
   del iconbye.obj
   lib icondraw -+ drawmenu,,
   del drawmenu.obj
   lib icondraw -+ director,icondraw.lst,
   del director.obj
   del icondraw.bak

icondraw.obj: icondraw.c
      cl -c -AL -Zp1 icondraw.c

..\icondraw.exe: icondraw.obj icondraw.c icondraw.mak icondraw.lib
     link icondraw.obj,..\icondraw.exe, NUL, /ST:8192 /NOE /NOD llibce icondraw, NUL
     del icondraw.obj
