/* 
Adapted from 
	"Essential Ray Tracing Algorithm" by Eric Haines
	in 'An Introduction to Ray Tracing' ed by Andrew Glassner.
	Academic Press 1989.
-----
s.n.pattanaik
8-April-1991
*/

#include <stdio.h>
#include <math.h>

#include "GraphicsGems.h"
#include "data_structure.h"

#define NUMDIM	3

#define RIGHT	0
#define LEFT	1
#define MIDDLE	2

int HitBoundingBox(minB,maxB, origin, dir,entrypoint,exitpoint)
/*
	Returns 1 for Ray Box intersection
		0 for no intersection.
	Ray direction need not be normalised.
*/
Point3 *minB, 		/* Box's Minimum Extent */
       *maxB;		/* Box's Maximum Extent */
Point3 *origin, *dir;	/*ray */
double *entrypoint,
       *exitpoint;	/* Ray paramters at entry and exit */
{
	int intersect_parallel_planes();

	*entrypoint = -LARGE;
	*exitpoint = LARGE;

	if (intersect_parallel_planes(minB->x,maxB->x,
				      origin->x,dir->x,
				      entrypoint,exitpoint)==0) return(0);
	if (intersect_parallel_planes(minB->y,maxB->y,
				      origin->y,dir->y,
				      entrypoint,exitpoint)==0) return(0);
	if (intersect_parallel_planes(minB->z,maxB->z,
				      origin->z,dir->z,
				      entrypoint,exitpoint)==0) return(0);
	if (*entrypoint<0)*entrypoint=0;
	return(1);
}	
int intersect_parallel_planes(L,R,O,D,tnear,tfar)
double L,R,O,D;
double *tnear,*tfar;
{
	if (D==0){
		if ((O<L)||(O>R)) return(0);
	}
	else{
		double t1=(L-O)/D,
		       t2=(R-O)/D;
		if (t1 > t2) { 
			double t=t1;
			t1 = t2; t2 = t;
		}
		if (t1 > *tnear) *tnear = t1;
		if (t2 < *tfar) *tfar = t2;
		if (*tnear > *tfar) return(0);
		if (*tfar < 0) return(0);
	}
	return(1);
}
/*
	Point3 start={0,4,2},dir={0.218,-0.436,0.873};
	Point3 L={0,0,0},H={3,3,3};
main()
{
	double t1,t2;
	printf("Give ray origin <x,y,z> : ");scanf("%lf%lf%lf",&(start.x),
		&(start.y),&(start.z));
	printf("Give ray direction <x,y,z> : ");scanf("%lf%lf%lf",&(dir.x),
		&(dir.y),&(dir.z));
	if(HitBoundingBox(&L,&H,&start,&dir,&t1,&t2))
		printf("Hitting the box at %g and %g.\n",t1,t2);
	else printf("Missed the box.\n");
}
*/
