/*
 * fbm.c
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id: fbm.c,v 4.0 91/07/17 14:42:06 kolb Exp Locker: kolb $
 *
 * $Log:	fbm.c,v $
 * Revision 4.0  91/07/17  14:42:06  kolb
 * Initial version.
 * 
 */
#include "texture.h"
#include "fbm.h"

FBm *
FBmCreate(offset, scale, h, lambda, octaves, thresh, mapname)
Float offset, scale, h, lambda;
int octaves;
Float thresh;
char *mapname;
{
	FBm *fbm;

	fbm = (FBm *)RayMalloc(sizeof(FBm));

	fbm->beta = 2.0*h + 1.0;
	fbm->lambda = lambda;
	fbm->scale = scale;
	fbm->offset = offset;
	fbm->thresh = thresh;
	fbm->octaves = octaves;
	fbm->omega = pow(lambda, (-0.5)*fbm->beta);
	if (mapname != (char *)NULL)
		fbm->colormap = ColormapRead(mapname);
	else
		fbm->colormap = (Color *)NULL;
	return fbm;
}

void
FBmApply(fbm, prim, ray, pos, norm, gnorm, surf)
FBm *fbm;
Geom *prim;
Ray *ray;
Vector *pos, *norm, *gnorm;
Surface *surf;
{
	Float val;
	int index;

	val = fBm(pos, fbm->omega, fbm->lambda, fbm->octaves);
	if (val < fbm->thresh)
		val = fbm->offset;
	else
		val = fbm->offset + fbm->scale*(val - fbm->thresh);
	if (fbm->colormap) {
		index = 255. * val;
		if (index > 255) index = 255;
		if (index < 0) index = 0;
		surf->diff.r *= fbm->colormap[index].r;
		surf->diff.g *= fbm->colormap[index].g;
		surf->diff.b *= fbm->colormap[index].b;
		surf->amb.r *= fbm->colormap[index].r;
		surf->amb.g *= fbm->colormap[index].g;
		surf->amb.b *= fbm->colormap[index].b;
	} else {
		ColorScale(val, surf->diff, &surf->diff);
		ColorScale(val, surf->amb, &surf->amb);
	}
}
