/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<sse.h>
#include<ssepal.h>
#include<ssecapt.h>

#include"mapmaker.h"

unsigned char CNumber[4];

sseSpriteHeader * MCross, * MPointer;
sseSpriteHeader * BoxTL, * BoxTR, * BoxBL, * BoxBR;

char CrossSprite[] =    // 11x11
{  0,0,0,0,0,1,0,0,0,0,0,
   0,0,0,0,1,2,1,0,0,0,0,
   0,0,0,0,1,2,1,0,0,0,0,
   0,0,0,0,1,2,1,0,0,0,0,
   0,1,1,1,0,1,0,1,1,1,0,
   1,2,2,2,1,0,1,2,2,2,1,
   0,1,1,1,0,1,0,1,1,1,0,
   0,0,0,0,1,2,1,0,0,0,0,
   0,0,0,0,1,2,1,0,0,0,0,
   0,0,0,0,1,2,1,0,0,0,0,
   0,0,0,0,0,1,0,0,0,0,0
};

char PointerSprite[] =  // 7x9
{  1,1,0,0,0,0,0,
   1,3,1,0,0,0,0,
   1,2,3,1,0,0,0,
   1,2,2,3,1,0,0,
   1,2,2,2,3,1,0,
   1,2,2,2,2,3,1,
   1,2,2,2,3,1,0,
   1,2,2,2,1,0,0,
   1,2,3,2,3,1,0,
   1,1,1,3,2,1,0,
   0,0,0,1,2,1,0,
   0,0,0,0,1,1,0
};

char TopLeft[] =     // 6x6
{  1,1,1,1,1,1,
   1,2,2,2,2,1,
   1,2,1,1,1,1,
   1,2,1,0,0,0,
   1,2,1,0,0,0,
   1,1,1,0,0,0
};

char TopRight[] =
{  1,1,1,1,1,1,
   1,2,2,2,2,1,
   1,1,1,1,2,1,
   0,0,0,1,2,1,
   0,0,0,1,2,1,
   0,0,0,1,1,1
};

char BottomLeft[] =
{  1,1,1,0,0,0,
   1,2,1,0,0,0,
   1,2,1,0,0,0,
   1,2,1,1,1,1,
   1,2,2,2,2,1,
   1,1,1,1,1,1
};

char BottomRight[] =
{
   0,0,0,1,1,1,
   0,0,0,1,2,1,
   0,0,0,1,2,1,
   1,1,1,1,2,1,
   1,2,2,2,2,1,
   1,1,1,1,1,1
};



void SetupSprites()
{
   sseSpriteHeader * CreateSprite( char* Source, int Width, int Height, short PivotX, short PivotY );

   // Find white and black in the current palette

   CNumber[1] = Black;
   CNumber[2] = White;
   CNumber[3] = Gray;

   // Find an unused number for CNumber[0] (the background)

   if( CNumber[1] != 1 && CNumber[2] != 1 )      CNumber[0] = 1;
   else if( CNumber[1] != 2 && CNumber[2] != 2 ) CNumber[0] = 2;
   else                                          CNumber[0] = 3;

   // Create all the sprites

   MCross   = CreateSprite( CrossSprite, 11, 11, 5, 5 );
   MPointer = CreateSprite( PointerSprite, 7, 12, 0, 0 );
   BoxTL    = CreateSprite( TopLeft, 6, 6, 2, 2 );
   BoxTR    = CreateSprite( TopRight, 6, 6, 4, 2 );
   BoxBL    = CreateSprite( BottomLeft, 6, 6, 2, 4 );
   BoxBR    = CreateSprite( BottomRight, 6, 6, 4, 4 );
}

void RegisterSprites()
{
   sseRegisterSprite( MCross );
   sseRegisterSprite( MPointer );
   sseRegisterSprite( BoxTL );
   sseRegisterSprite( BoxTR );
   sseRegisterSprite( BoxBL );
   sseRegisterSprite( BoxBR );
}


sseSpriteHeader * CreateSprite( char* Source, int Width, int Height, short PivotX, short PivotY )
{
   void ConvertArray( char * Dest, char * Source, char * Table, int Num );

   sseSpriteHeader * Spr;
   HiddenSpriteInfo * HSI;
   imgInfo img;
   char * Work, * ptop, * p;

   Spr = Alloc( sizeof( sseSpriteHeader ) );
   HSI = Alloc( sizeof( HiddenSpriteInfo ) + Width * Height * 10 );
   Work = TempAlloc( Width * Height );

   ConvertArray( Work, Source, CNumber, Width * Height );

   img.Width = Width;
   img.Height = Height;
   img.BytesPerRow = Width;
   img.Data = Work;

   captSetupSSPHeader( Spr, HSI, ScreenWidth );
   Spr->NumFrames = 1;

   p = ptop = (char*)( HSI+1 );

   captSetupSpriteGraphicInfo( Spr->Frame, HSI, &img, PivotX, PivotY, CNumber[0] );

   p = captSSPFrame( Spr->Frame, ptop, p, &img, CNumber[0], ScreenWidth );
   p = captEraseFrame( Spr->Frame, ptop, p, &img, CNumber[0], ScreenWidth );

   FreeFrom( p );
   return Spr;
}

void ConvertArray( char * Dest, char * Source, char * Table, int Num )
{
   while( Num-- ) *(Dest++) = *(Table+ *(Source++));
}
