/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */
/*                                                                          */
/*                            Main Header File                              */

#ifndef _SSE_H_INCLUDED

/*  C++ compatibility  */

#ifdef __cplusplus
extern "C" {
#endif

#define SSE_VERSION "1.0"

typedef struct
{
   char Red, Green, Blue;
} palRegister;

typedef struct
{
   int IDNumber;
   int NumTiles;
   short int Width, Height;
   palRegister Palette[ 256 ];
} sseTileGraphicInfo;

typedef struct
{
   int Width, Height;
} sseTileMapInfo;

typedef struct
{
   int Reserved;
   short int Width, Height;
   short int PivotX, PivotY;
   short int ActualWidth, ActualHeight;
} sseSpriteGraphicInfo;

#define SYSTEM_RAM_SPRITE   1
typedef struct
{
   int IDNumber;
   short int Type;
   short int NumFrames;
   int Flags;
   int Reserved;
   char * Data;
   sseSpriteGraphicInfo Frame[1];
} sseSpriteHeader;

typedef struct
{
   sseSpriteHeader * Header;
   int X, Y, Frame;
} sseSpriteTracking;

typedef struct
{
   int HorizontalRes, VerticalRes, MaxColors, FramesPerSecond;
} ModeInfoType;
extern ModeInfoType sseModeInfo[17];

#define MODE_ALREADY_SET   0
#define MODE_320x175x256   1
#define MODE_360x175x256   2
#define MODE_320x200x256   3
#define MODE_360x200x256   4
#define MODE_320x240x256   5
#define MODE_360x240x256   6
void sseInitEngine( char Mode, sseTileGraphicInfo * Tiles, sseTileMapInfo * Map,
                    int MaxXScroll, int MaxYScroll, int StatusBar );

void sseRegisterSprite( sseSpriteHeader * SprHdr );

sseSpriteTracking * sseInitSprite( sseSpriteHeader * SprHdr, int X, int Y, int Frame, int Priority );

void sseChangeSpritePriority( sseSpriteTracking * Spr, int Priority );

void sseDisableSprite( sseSpriteTracking * Spr );

int sseCheckCollision( sseSpriteTracking * Spr1, sseSpriteTracking * Spr2 );

void sseUpdateScreen( int X, int Y );

void sseFlagRedrawScreen( void );

void sseRestoreVideoMode( void );


#define _SSE_H_INCLUDED

/**  C++ compatibility  **/
#ifdef __cplusplus
};
#endif
#endif
