/*                        Sprite & Scrolling Engine                         */
/*           Copyright (c) Genesoft 1996.  All rights reserved.             */
/*                                                                          */
/*                    Direct Video Functions Header File                    */

#ifndef _SSEDVID_H_INCLUDED

/*  C++ compatibility  */

#ifdef __cplusplus
extern "C" {
#endif

#include"sse.h"

#define MODE_320x350x256   7
#define MODE_360x350x256   8
#define MODE_320x400x256   9
#define MODE_360x400x256   10
#define MODE_320x480x256   11
#define MODE_360x480x256   12
#define MODE_320x200x16    13
#define MODE_640x200x16    14
#define MODE_640x350x16    15
#define MODE_640x480x16    16

void dvSetDirectMode( char Mode );

void dvDrawRectangle( int X, int Y, int Width, int Height, int Color );

void dvDrawSprite( sseSpriteHeader * SprHdr, int X, int Y, int Frame );

void dvDrawTile( sseTileGraphicInfo * Tiles, int X, int Y, int Number );

void dvWaitForRetrace();

typedef struct
{
   int Width;
   int Reserved;
} dvFontCharInfo;

typedef struct
{
   int IDNumber;
   unsigned char NumChars;
   unsigned char Height;
   unsigned char XMargin;
   unsigned char YMargin;
   dvFontCharInfo Character[1];
} dvFontHeader;

extern dvFontHeader * dvFont;
extern int dvCursorX, dvCursorY;
extern unsigned char dvFontColor;
extern unsigned char dvAssignedColor[10];

void dvPrintF( char *, ... );

void dvPutS( char * );

void dvPutChar( char );

#define _SSEDVID_H_INCLUDED
#ifdef __cplusplus
};
#endif
#endif
