/* demo for embedded .BSV files in mix C */
/* RUNFIRST.c by bill buckels 1990       */
/* these files can be created in the THEDRAW or in GWBASIC, etc. */
/* graphic arrays are encoded using my utility bsaveinc.exe      */
/* sound arrays are created using my utility snd2txt.exe         */

#include <dos.h>
#include <bios.h>

/* musical array created from file HABANERA.SND */
/* array structure is frequency,duration */
int HABANERA[]={
  147,  6,32767,  0,  220,  2,32767,  0,  349,  2,32767,  2,
  220,  2,32767,  2,  147,  6,32767,  0,  220,  2,32767,  0,
  349,  2,32767,  2,  220,  2,32767,  2,  147,  6,32767,  0,
  220,  2,32767,  0,  349,  2,32767,  2,  220,  2,32767,  2,
  147,  6,32767,  0,  220,  2,32767,  0, 1175,  4,32767,  0,
 1109,  4,32767,  0, 1047,  6,32767,  0, 1047,  2,32767,  0,
  988,  4,32767,  0,  932,  4,32767,  0,  880,  6,32767,  0,
  880,  2,32767,  0,  831,  4,32767,  0,  784,  4,32767,  0,
  698,  1,32767,  0,  784,  1,32767,  0,  698,  1,32767,  0,
  659,  2,32767,  0,  698,  2,32767,  0,  784,  4,32767,  0,
  698,  4,32767,  0,  587,  0,32767,  0,  659,  8,32767,  0,
 1175,  4,32767,  0, 1109,  4,32767,  0, 1047,  6,32767,  0,
 1047,  2,32767,  0,  988,  4,32767,  0,  932,  4,32767,  0,
  880,  6,32767,  0,  880,  2,32767,  0,  784,  4,32767,  0,
  698,  4,32767,  0,  659,  1,32767,  0,  698,  1,32767,  0,
  659,  1,32767,  0,  587,  2,32767,  0,  659,  2,32767,  0,
  698,  4,32767,  0,  659,  4,32767,  0,  587,  8,32767,  0,
 1175,  4,32767,  0, 1109,  4,32767,  0, 1047,  6,32767,  0,
 1047,  2,32767,  0,  988,  4,32767,  0,  932,  4,32767,  0,
  880,  6,32767,  0,  880,  2,32767,  0,  831,  4,32767,  0,
  784,  4,32767,  0,  698,  1,32767,  0,  784,  1,32767,  0,
  698,  1,32767,  0,  659,  2,32767,  0,  698,  2,32767,  0,
  784,  4,32767,  0,  698,  4,32767,  0,  587,  0,32767,  0,
  659,  8,32767,  0, 1175,  4,32767,  0, 1109,  4,32767,  0,
 1047,  6,32767,  0, 1047,  2,32767,  0,  988,  4,32767,  0,
  932,  4,32767,  0,  880,  6,32767,  0,  880,  2,32767,  0,
  784,  4,32767,  0,  698,  4,32767,  0,  659,  1,32767,  0,
  698,  1,32767,  0,  659,  1,32767,  0,  587,  2,32767,  0,
  659,  2,32767,  0,  698,  4,32767,  0,  659,  4,32767,  0,
  587,  6,32767,  0,  880,  2,32767,  0,  587,  4,32767,  0,
  659,  4,32767,  0,  740,  6,32767,  0,  880,  2,32767,  0,
  740,  4,32767,  0,  659,  4,32767,  0,  587,  6,32767,  0,
  659,  2,32767,  0,  740,  4,32767,  0,  784,  4,32767,  0,
  740,  0,32767,  0,  880,  2,32767,  0,  740,  0,32767,  0,
  880,  2,32767,  0,  740,  0,32767,  0,  880,  2,32767,  0,
  740,  0,32767,  0,  880,  2,32767,  0,  784,  0,32767,  0,
  988,  4,32767,  0,  740,  0,32767,  0,  880,  4,32767,  0,
  659,  0,32767,  0,  784,  6,32767,  0,  988,  2,32767,  0,
  659,  4,32767,  0,  740,  4,32767,  0,  659,  0,32767,  0,
  784,  6,32767,  0,  988,  2,32767,  0,  784,  4,32767,  0,
  740,  4,32767,  0,  659,  6,32767,  0,  740,  2,32767,  0,
  784,  4,32767,  0,  880,  4,32767,  0,  784,  0,32767,  0,
  988,  2,32767,  0,  784,  0,32767,  0,  988,  2,32767,  0,
  784,  0,32767,  0,  988,  2,32767,  0,  784,  0,32767,  0,
  988,  2,32767,  0,  880,  0,32767,  0, 1109,  4,32767,  0,
  784,  0,32767,  0,  988,  4,32767,  0,  740,  0,32767,  0,
  880,  6,32767,  0,  880,  2,32767,  0, 1175,  4,32767,  0,
 1319,  4,32767,  0, 1175,  0,32767,  0, 1480,  6,32767,  0,
  880,  2,32767,  0,  740,  4,32767,  0,  659,  4,32767,  0,
  587,  6,32767,  0,  659,  2,32767,  0,  740,  4,32767,  0,
  784,  4,32767,  0,  740,  0,32767,  0,  880,  2,32767,  0,
  740,  0,32767,  0,  880,  2,32767,  0,  740,  0,32767,  0,
  880,  2,32767,  0,  740,  0,32767,  0,  880,  2,32767,  0,
  988,  0,32767,  0, 1175, 16,32767,  0, 1109,  1,32767,  0,
 1175,  1,32767,  0, 1109,  1,32767,  0,  659,  0,32767,  0,
  784,  6,32767,  0,  988,  2,32767,  0, 1319,  4,32767,  0,
 1480,  4,32767,  0, 1319,  0,32767,  0, 1568,  6,32767,  0,
  988,  2,32767,  0,  784,  4,32767,  0,  740,  4,32767,  0,
  659,  6,32767,  0,  740,  2,32767,  0,  784,  4,32767,  0,
  880,  4,32767,  0, 1109,  2,32767,  0,  988,  2,32767,  0,
  831,  2,32767,  0,  880,  2,32767,  0, 1480, 18,32767,  0,
 1319,  1,32767,  0, 1480,  1,32767,  0, 1319,  1,32767,  0,
 1175,  4,32767,  0,32767,  2, 1760,  2,32767,  0, 2349,  4,
32767,  4,-1,-1};

union REGS inregs, outregs;

void play(int *song)
{
    unsigned int status=0;
    int freq=song[0],duration,i=0;

    while(freq!=-1){
            /* if we got a keypress see what it is */
            if(kbhit())status=getch();
            switch(status)
            {
                case 27: freq=-1;break;
                default: i++;
                         duration=song[i];
                         sound(freq,duration);
                         i++;
                         freq=song[i];
                         }
                         }


}

#define SCREENSIZE 4000
unsigned int SCREENSEG= 0xb000;

/* run length encoded array created from BSAVED text screen */
unsigned char STARVE[]={
255, 32,229, 32, 45, 82,101,115,101, 97,114, 99,104, 32, 70,117,110,
100,115, 32, 97,114,101, 32, 68,101,115,112,101,114, 97,116,101,108,
121, 32, 78,194,101,100,101,100, 32,116,111, 32, 70,105,110,100, 32,
 97, 32, 67,117,114,101,220, 32, 70,111,114, 32, 80,114,111,103,114,
 97,194,109,101,114, 39,115, 32, 73,110,115,111,109,110,105, 97, 46,
231, 32, 47, 92,204, 32, 45, 69,118,101,110, 32,105,102, 32, 73, 32,
 99,111,117,108,100, 32, 97,194,102,111,114,100, 32,110,111,116, 32,
116,111, 32, 73, 32,119,111,117,108,100, 32,112,114,111, 98, 97, 98,
108,121, 32,115,116,105,194,108,204, 32,194, 47,194, 92,204, 32,114,
 97,116,104,101,114, 32,100,111, 32,112,114,111,103,114, 97,194,109,
105,110,103, 32, 97,194,108, 32,110,105,103,104,116, 32,116,104, 97,
110, 32, 67, 97,116, 99,104, 32, 90,194,101,115, 46,207, 32,195, 47,
195, 92,203, 32, 73, 32,119,111,117,108,100, 44, 32,104,111,119,101,
118,101,114, 44, 32, 97,194,112,114,101, 99,105, 97,116,101, 32,116,
104,101, 32,111,194,112,111,114,116,117,110,105,116,121, 32,116,111,
 32,112,114,111,118,101,201, 32,196, 47,196, 92,202, 32,111,114, 32,
100,105,115,112,114,111,118,101, 32,116,104,105,115, 32,116,104,101,
111,114,121, 46, 32, 73,102, 32,121,111,117, 32,119,105,115,104, 32,
116,111, 32,112, 97,114,116,105, 99,105,112, 97,116,101, 32,105,110,
199, 32,197, 47,197, 92,201, 32,116,104,105,115, 32,119,111,114,116,
104,119,104,105,108,101, 32, 83, 99,105,101,110,116,105,102,105, 99,
 32, 69,120,112,101,114,105,109,101,110,116, 32, 97,110,100, 32, 89,
111,117, 32,102,194,101,108, 32,116,104, 97,116,197, 32,195, 47, 67,
 65, 78, 65, 68, 65,195, 92,200, 32, 89,111,117, 32,104, 97,118,101,
 32,114,101, 99,101,105,118,101,100, 32,115,111,109,101, 32,118, 97,
108,117,101, 32,102,114,111,109, 32,109,121, 32, 99,114,101, 97,116,
105,111,110,115, 44, 32, 80,108,101, 97,115,101,197, 32, 47,204,223,
 92,199, 32, 70,194,101,108, 32, 70,114,194,101, 32, 84,111, 32, 67,
111,110,116,114,105, 98,117,116,101, 32, 87,104, 97,116,101,118,101,
114, 32, 89,111,117,114, 32, 67,111,110,115, 99,105,101,110, 99,101,
 32, 87,105,194,108,202, 32,193,221,193,222, 32,193,221,193,222, 32,
193,221,202, 32, 65,194,108,111,119, 46, 32, 40, 80,114,101,102,101,
114, 97, 98,108,121, 32,109,111,110,101,121, 44, 32, 98,117,116, 32,
 97,110,121,116,104,105,110,103, 32,111,102, 32,118, 97,108,117,101,
 32, 97,194, 99,101,112,116,101,100, 46, 41,197, 32,193,221,193,222,
 32,193,221,193,222, 32,193,221,255, 32,202, 32,194, 98,117, 99,107,
101,108,115, 64,101,115, 99, 97,112,101, 46, 99, 97,200, 32, 66,105,
194,108, 32, 66,117, 99,107,101,108,115, 44, 32, 83,116, 97,114,118,
105,110,103, 32, 80,114,111,103,114, 97,194,109,101,114,213, 32,195,119,
 46,101,115, 99, 97,112,101, 46, 99, 97, 47,126,194, 98,117, 99,107,
101,108,115,195, 32, 53, 56, 57, 32, 79,120,102,111,114,100, 32, 83,
116,114,194,101,116,255, 32, 87,105,194,110,105,112,101,103, 44, 32,
 77, 97,110,105,116,111, 98, 97, 44, 32, 67, 97,110, 97,100, 97,194, 32,
 82, 51, 77, 32, 51, 74, 50,255, 32,244, 32, 72,101,114,101, 32, 73,
215, 32,202, 36,233, 32,202,219,211, 32,202,219,196, 32,193,219,195,223,
193,219,197, 32,195,219,216, 32,202,219,211, 32,202,219,196, 32,193,219,
195, 32,193,219,198, 32,193,219,202, 32, 77, 97,110,105,116,111, 98,
 97,194, 32,197, 95,202,219,197, 95, 67,111,109,101,198, 32,196, 95,
202,219,196, 95,205,219,201, 32,202,219,197, 32,202,219,197, 32,202,219,
196, 32,202,219,196, 32,205,219,203, 32, 79,196, 32, 79,201, 32, 79,
196, 32, 79,201, 32, 79,196, 32, 79,200, 32, 79,196, 32, 79,201, 32,
 79,196, 32, 79,196, 32,193,219,255, 32,255, 32,229, 32, 78,111,116,
101, 58, 32, 73,116, 32,105,115, 32,111,107, 32,116,111, 32,109, 97,
105,108, 32, 99, 97,115,104, 44, 32, 98,117,116, 32,100,111, 32,110,
111,116, 32,115,101,110,100, 32, 99, 97,114,115, 32,111,114, 32,108,
105,118,101,115,116,111, 99,107, 32,116,104,114,111,117,103,104, 32,
116,104,101, 32,109, 97,105,108, 46,255, 21,255, 21,255, 21,243, 21,
204, 30,255, 21,197, 21,204, 30,255, 21,197, 21,204, 30,255, 21,197, 21,
206, 30,255, 21,195, 21,208, 30,255, 21, 21,210, 30,254, 21,210, 30,
254, 21,210, 30,254, 21,210, 30,254, 21,255, 47,255, 47,255, 47,255, 47,
255, 47,255, 47,255, 47,255, 47,255, 47,255, 47,255, 47,219, 47,255, 36,
207, 36,194, 37,255, 47,255, 47,255, 47,243, 47,
0}; /* terminator */

#define TERMINATOR 1

void showpic(int argc, unsigned char *argv)
{

    unsigned int byteoff=0,secondoff=1,packet;
    unsigned char byte,bytecount;
    int wordcount,target;
    static char far *crt;

    target = argc-TERMINATOR;
    crt = MK_FP(SCREENSEG,0x0000);

    wordcount=0;
    do {
      bytecount=1;                          /* start with a seed count */
      byte=argv[wordcount];
      wordcount++;
                                            /* check to see if its raw */
      if(0xC0 == (0xC0 &byte)) {            /* if its not, run encoded */
        bytecount= 0x3f &byte;
        byte=argv[wordcount];
        wordcount++;
      }
      for(packet=0;packet<bytecount;packet++){
        if(byteoff<SCREENSIZE){
          crt[byteoff]=byte;
          byteoff+=2;
        }
        else{
          crt[secondoff]=byte;
          secondoff+=2;
        }
      }
    } while(wordcount<target);
}


int pull_right(int row,int col)
{
  static char far *crt;
  int x,x2,y,scanlines = 24;
  col=(col*2)-1;

  while(col<159)
    {
      x2=158;
      for(x=159;x>col;x-=2)
      {
        for(y=row;y<scanlines;y++)
        {
          crt = MK_FP(SCREENSEG,(y*160));
          crt[x]= crt[x-2] ;
          crt[x2]=crt[x2-2];
        }
        x2-=2;
      }
      /* dwell cycle */
      /* make noise  */
      sound(20000,(((160-col)/30)+2));
      col+=2;
    }

}

void cls(void)
{
    inregs.h.ah = 6;
    inregs.h.al = 0;
    inregs.h.ch = 0;
    inregs.h.cl = 0;
    inregs.h.dh = 24;
    inregs.h.dl = 79;
    inregs.h.bh = 0x07;
    int86(0x10, &inregs, &outregs);
}

void main()
{
    int i;
    int86(0x11,&inregs,&outregs); /* get equipment list from the bios */
    /* get display type (bits 4 and 5 of ax) */
    if ((outregs.x.ax & 0x30) < 0x30)SCREENSEG=0xb800;

    /* clearscreen and turn cursor off */
    cls();
    inregs.h.al=0;
    inregs.h.ah=1;
    inregs.x.cx=0x2000;
    int86(0x10,&inregs,&outregs);

    /* display the beg notice and play the song */
    showpic(sizeof(STARVE),STARVE);
    play(HABANERA);

    /* make noise */
    for(i=2;i!=4;i++)
      {
        sound(32767,i);
        sound(492,(i*10));
      }

    /* fade right after a key press */
    pull_right(15,1);

    /* clear screen and turn cursor on */
    cls();
    inregs.h.al=0;
    inregs.h.ah=1;
    inregs.x.cx=0x0607;
    int86(0x10,&inregs,&outregs);
    exit(0);
}
