;
; Tiny PCX Viewer v1.13
;
; PCX Viewer in only 136 bytes!
; Displays 320x200x256 PCX files only.
;
; Syntax: PCX filename.pcx
;
; Note: Error checking is very sparse (what can you expect in 149 bytes ;-)
; ~~~~
;
; Copyright (C) 1996, Adarsh Kini and J. C. Kiran.
;	Shrinking by Terje Mathisen (The Shrink Guy decreased 13 Bytes eh !)
;
;   e-mail: adk@poboxes.com
;           jck@poboxes.com
;	    Terje.Mathisen@hda.hydro.com
;
;   BBS:  'KIRAN J C' at INFOMART BBS: +91 (80) 5598401/02, 28.8k
;         'ADARSH KINI' at INFOMART BBS
;
; This program was written as a answer to the challenge put up
;  by someone who said that his viewer was the smallest (184 bytes)
;
; Can anybody answer us ? We are listening.   ;-)
;
; This code is released into the public domain. Use as you please.
;
; This is the result of our first attempt at displaying PCX files and
; it took us only 3 hours!
;
; Compile with TASM after enabling multiple passes to filter out the
; extra NOPs. Link with Tlink
;
; Coming next: Tiny BMP!   (We think so)
;
; If you can get a smaller viewer, we would be happy to take a look.
;
; With special thanks to Devesh 'Devilish' Agarwal, SysOp, INFOMART BBS,
;  for opening up the System Programmers forum where the best brains
;  hang out. Special thanks to the Shrinker Mathisen for shrinking 13 bytes !
;
; Also thanks to Srivatsa K. Srinivasan (vatsa@poboxes.com) for letting
;  us know about the challenge.
;
;--------------------------------------------------------------------------

_TEXT	SEGMENT	'CODE'
	ASSUME cs:_TEXT,ds:_TEXT,es:_TEXT
	org	80h
cmdlen	label	byte
	org	81h
cmdline	label	byte
	org	100h
start:
	align	1
	mov 	si,offset cmdlen	       ; BEGIN The shrinker's code
	xor 	bh,bh
	mov	bl,[si]
	mov     [bx + cmdline],0
skipspace:
	inc	si
	mov	byte ptr [si+bx],bh
	cmp	byte ptr [si],20h
	je	skipspace			; END The Shrinker's Code
oknow:
	xchg	si,dx
	mov 	ax,3D00h		; Open the file
	int	21h
	jc	exit
	xchg	ax,bx			; 1 Byte only!

	mov	ax,4200h		; Skip first 128 bytes
	xor	cx,cx
	mov	dx,128
	int	21h
	jc	exit

	mov	ah,3Fh			; Read 64000 bytes
	mov	cx,64000
	mov	dx,offset loadpos
	int	21h
	jc	exit

	mov	ah,3Eh			; Close the file
	int	21h

	xor	di,di
	mov 	si,offset loadpos
	mov	ax, 0A000h
        mov     es, ax

	mov	ax,0013h		; Set 320x200x256
	int 	10h
	xor	ch,ch
	xor	bx,bx
	xor	ah,ah

pcxloop:
	lodsb				; BEGIN The Shrinker's Code
	cmp	al,11000000b
	jb	writedata
	and	al,00111111b
	mov	cl,al
	lodsb
	rep
writedata:
	stosb
	cmp	di,64000		; Test for end of data
	jb	pcxloop			; END The Shrinker's Code
exitdisp:				; Fix the palette
	mov	cx,3*256
	push	ds
	pop	es
	inc	si			; Skip the 12 decimal id byte
	mov	dx,si
	mov	di,si
paletteloop:
	lodsb
	shr	al,1
	shr	al,1
	stosb
	loop	paletteloop
					; Now set the palette
	mov	ax,1012h
	xor	bx,bx
	mov	cx,256
	int	10h

        xor     ax,ax                   ; Wait for keypress
	int	16h

exit:
        mov     ax,3                    ; Set mode 3 (80x25) text
	int	10h
        int     20h                     
loadpos label byte
_TEXT 	ends
	end	start
