;----------------------------macros.asm-----------------------------
;
; Set up the assembly language program for "C" compatability
; Calling sequence:
;   Prefix
;
Prefix MACRO
	push bp			; Save the base pointer
	mov bp, sp		; Copy the stack pointer
	push ds
	push es
	push si
	push di
ENDM

;
; Finish the assembly language program for "C" compatability
; Calling sequence:
;   Postfix
;
Postfix MACRO
	pop di
	pop si
	pop es
	pop ds
	mov sp, bp
	pop bp
	ret
ENDM