/*************************************************************************/
/*				VEINFO.CPP				                                 */
/*	Author: Don Lewis						                             */
/*	Date:   February 22, 1993					                         */
/*	Description:							                             */
/*		        Read the VESA information off the video card             */
/*	            and acknowledge available modes to the user.			 */
/*									                                     */
/*************************************************************************/

#include "stdio.h"
#include "conio.h"
#include <e:\borlandc\cprogs\vesainf.cpp>

struct info;
struct modeinfo;

void VesaInformation(void);
void ReturnSvgaMode(int);

void VesaInformation(void)
{
	unsigned int i;
	GetSvgaInfo();

	printf("\t\t******* VESA SVGA and EXTENDED mode information *******\n");
	printf("\t%s ", info.OEMStringPtr);
	for (i=0; i<=3; i++)
	printf("%c", info.VESASignature[i]);
	printf(" Version %d.%d, ", info.VESAVersion/ 0x100,
					   info.VESAVersion % 0x100);
	printf("%d kilobytes video ram\n\n",info.TotalMemory * 64);
	printf("MODE    ACTIVE?  RESOLUTION\t   DESCRIPTION\n");
	i = 0;
	while (info.VideoModePtr[i] != 0xffff)
	{
		ReturnSvgaMode(info.VideoModePtr[i]);
		if (modeinfo.ModeAttributes && 1)
			printf("%xh\tPresent ", info.VideoModePtr[i]);
		else printf("%xh \tNOT Present ", info.VideoModePtr[i]);
		printf("%dx%dx%dbpp\t",modeinfo.XResolution,modeinfo.YResolution,
				modeinfo.BitsPerPixel);

		switch (modeinfo.MemoryModel)
		{
			case 0x00: if (modeinfo.ModeAttributes && 8)printf("COLOR TEXT");
			else printf("B&W TEXT");
			break;
			case 0x01:	printf("CGA graphics");
			break;
			case 0x02:	printf("HGC graphics");
			break;
			case 0x03:	printf("16 color graphics");
			break;
			case 0x04:	printf("256 color Packed Pixel graphics");
			break;
			case 0x05:	printf("Non-Chain 4, 256 color graphics");
			break;
			case 0x06:
			printf("%ld ",(unsigned long)((long)2<<modeinfo.BitsPerPixel-1));
			printf("Direct color graphics" );
			break;
			case 0x07:  printf("YUV");
			break;
			case 0x08:
			case 0x09:
			case 0x0a:
			case 0x0b:
			case 0x0c:
			case 0x0d:
			case 0x0e:
			case 0x0f:	printf("Reserved for VESA");
			break;
			default:	printf("OEM memory model");
			break;
		}
		i = i+1;
        printf("\n");

	}
}