

;----------------------------------------------------------------------
; Module Name	:VESA.inc
; Program Name	:
; Description	:contains constants and structutres for VESA BIOS
; Date		:May 31, 1989
; Version	:1.0
; Programmer	:Rakesh K. Jain
; (C) Chips and Technologies, Inc. 1989
;----------------------------------------------------------------------


SUCCESS		equ	0		; return value on success
FAILURE		equ	1		; return value on failure
VESA_FUNCTIONS	equ	04FH		; VESA Control function
MAX_FUNCTIONS	equ	7
VERSION		equ	0100H		; Version 1.0
END_OF_MODES	equ	-1
NREG_SR		equ	4
NREG_CR		equ	19h
NREG_AR		equ	15h
NREG_GR		equ	9
SIZE_VGA_STATE		equ	1+1+1+NREG_SR+1+NREG_CR+1+NREG_AR+1+NREG_GR
SIZE_SUPERVGA_STATE	equ	20
SIZE_DAC_STATE		equ	256*3+1
SIZE_BIOS_DATA_STATE	equ	4

; Monitor type
MULTISYNC_II	equ	0
MULTISYNC_PLUS	equ	1


;
; Video state equates
;
VS_HW_STATE	equ	0000000000000001b	; Save/Restore Video H/W state
VS_BIOS_STATE	equ	0000000000000010b	; Save/Restore Video BIOS state
VS_DAC_STATE	equ	0000000000000100b	; Save/Restore Video DAC
VS_SUPERVGA_STATE equ	0000000000001000b	; Save/Restore Super VGA State
VS_GET_BUFSIZE	equ	0			; Get buffer size function
VS_SAVE_STATE	equ	1			; Save state
VS_RESTORE_STATE equ	2			; Restore state


BLOCKSIZE	equ	64			; Block size is 64 bytes


;
; Extended register to  be saved
;
defextregs	macro	x
		irp	y, <x>
		db	y
		endm
		endm



VGAInfoBlock	struc
	VESASignature	db	'VESA'
	VESAVersion	dw	VERSION
	OEMString	dd	?
	Capabilities	db	4 DUP (0)
	VideoModePtr	dd	?
VGAInfoBlock	ends


ModeInfoBlock	struc
	ModeAttributes	dw	?
	WinAAttributes	db	?
	WinBAttributes	db	?
	WinGranularity	dw	?
	WinSize		dw	?
	WinASegment	dw	?
	WinBSegment	dw	?
	WinFuncPtr	dd	?
	BytesPerScanline dw	?
; end of obligatory structure
	XResolution	dw	?
	YResolution	dw	?
	XCharCellSize	db	?
	YCharCellSize	db	?
	NumberOfPlanes	db	?
	BitsPerPixel	db	?
	NumberOfBanks	db	?
	MemoryModel	db	?
	BankSize	db	?
ModeInfoBlock	ends

OBLG_INFO_SIZE	equ	XResolution - ModeAttributes
EXT_INFO_SIZE	equ	(SIZE ModeInfoBlock) - OBLG_INFO_SIZE

;
; Video mode Attributes
;
MA_HW_SUPP	equ	0000000000000001b	; Mode is supported in H/W
MA_EXT_INFO	equ	0000000000000010b	; Extended Info is available
MA_BIOS_OUTP	equ	0000000000000100b	; BIOS Supports output functions
MA_COLOR	equ	0000000000001000b	; It is a is color mode
MA_GRAPHICS	equ	0000000000010000b	; It is a graphics mode
;**OldMA_BIOS_INIT	equ	0000000000000100b	; Mode can be initialized by BIOS

GRAPHICS_MODE	equ	MA_HW_SUPP+MA_EXT_INFO+MA_BIOS_OUTP+MA_COLOR+MA_GRAPHICS
TEXT_MODE	equ	MA_HW_SUPP+MA_EXT_INFO+MA_BIOS_OUTP+MA_COLOR

;
; Window Attributes
;
WA_WINSUPP	equ	00000001b		; Window supported
WA_WINREAD	equ	00000010b		; Window is readable
WA_WINWRITE	equ	00000100b		; Window is writable

WIN_ATTR	equ	WA_WINSUPP+WA_WINREAD+WA_WINWRITE

;
; Memory models
;
MM_TEXTMODE	equ	00			; Text modes
MM_CGAGRAPH	equ	01			; CGA Graphics modes
MM_HERCGRAPH	equ	02			; Hercules graphics mode
MM_4PLANAR	equ	03			; 4 Plane planar modes
MM_PACKEDPIX	equ	04			; Packed pixel modes
MM_NONCHAIN	equ	05			; Extended packed pixel



InitModeInfo macro	parm_list
	irp	x, <parm_list>
	ModeInfoBlock	<x>
	endm
	endm

;
;**************************** Non VESA Stuff *************************
;

;
; Constant Definitions
;
VideoInt	equ	10h			;Video Interrupt
NL		equ	<0dh, 0ah>		;New Line
EOS		equ	'$'			;End of String
TAB		equ	9			;TAB

;
;DOS Function Numbers with INT 21h
;
STDOUT		equ	9			;for Printing a String
GETINTVEC	equ	35h			;for Getting INT Vector
SETINTVEC	equ	25h			;for Setting INT Vector
TSR		equ	31h			;for Terminate & Stay Resident

;
; Macro Defintions
;
pushem	macro	x
	irp	y, <x>
	push	y
	endm
	endm

popem	macro	x
	irp	y, <x>
	pop	y
	endm
	endm


callfar	macro
	db	9ah			;;Opcode for Far Call with Label
	endm

print	macro	msg
	mov	dx, OFFSET msg
	mov	ah, STDOUT	;;INT21h Function to Display Text String
	int	21h
	endm

getvector macro	intnum
	mov	ah, GETINTVEC	;;Get Interrupt Vector Function Number
	mov	al, intnum	;;Interrupt Number
	int	21h
	endm

setvector	macro	intnum, handler
	mov	dx, OFFSET handler	;;Offset of Interrupt Handler
	mov	ah, SETINTVEC	;;Set Interrupt Vector Function Number
	mov	al, intnum	;;Interrupt Number
	int	21h
	endm
