

;----------------------------------------------------------------------
; Module Name	:VESA452.inc
; Program Name	:VESA452.com
; Description	:contains constants and structutres for VESA Modes for 452
; Date		:May 31, 1989
; Version	:1.0
; Programmer	:Rakesh K. Jain
; (C) Chips and Technologies, Inc. 1989
;----------------------------------------------------------------------



CHIPS_ID	equ	0A5H			; Chips & Tech VGA Id
EGA_BASE	equ	0300H			; EGA registers base
EXTR_ADDR	equ	0d6H			; Low byte of extended reg addr
PAGE_REG_A	equ	10H			; Index to page register A

CHIPSVGA_452	equ	10H			; Upper nibble of XR00
PL_GRANUL	equ	4			; 4KB Granularity in planar modes
PP_GRANUL	equ	16			; 16KB Granularity in packed pixel modes
NORMAL_SIZE	equ	32			; 32KB Window size (GR06 = 01)
EXT_SIZE	equ	64			; 64KB Extended size (GR06 = 00)
WINA_ADDR	equ	0a000h			; Win A start address
WINB_NADDR	equ	0a800h			; Win B normal start address
WINB_EADDR	equ	0b000h			; Win B extended start address
WIN_TADDR	equ	0b800h			; Text mode window start address
WIN_TSIZE	equ	32			; 32KB Text window size 

NORMAL_WIN	equ	<NORMAL_SIZE,WINA_ADDR,WINB_NADDR>
EXTENDED_WIN	equ	<EXT_SIZE,WINA_ADDR,WINB_EADDR>

PLANAR_WIN	equ	<WIN_ATTR,0,PL_GRANUL,EXTENDED_WIN,0>
PACK_WIN	equ	<WIN_ATTR,0,PP_GRANUL,EXTENDED_WIN,0>
TEXT_WIN	equ	<WA_WINREAD+WA_WINWRITE,0,WIN_TSIZE,WIN_TSIZE,WIN_TADDR,0,0>

Mode60 equ <TEXT_MODE,TEXT_WIN,132*2,1056,400,8,16,1,4,1,MM_TEXTMODE,0>
Mode61 equ <TEXT_MODE,TEXT_WIN,132*2,1056,400,8,8,1,4,1,MM_TEXTMODE,0>
Mode6E equ <GRAPHICS_MODE,PLANAR_WIN,090, 720,540,8,16,4,4,1,MM_4PLANAR,0>
Mode6F equ <GRAPHICS_MODE,PLANAR_WIN,096, 768,576,8,16,4,4,1,MM_4PLANAR,0>
Mode70 equ <GRAPHICS_MODE,PLANAR_WIN,100, 800,600,8,16,4,4,1,MM_4PLANAR,0>
Mode71 equ <GRAPHICS_MODE,PLANAR_WIN,120, 960,720,8,16,4,4,1,MM_4PLANAR,0>
Mode72 equ <GRAPHICS_MODE,PLANAR_WIN,128,1024,768,8,16,4,4,1,MM_4PLANAR,0>
Mode78 equ <GRAPHICS_MODE,PACK_WIN,640,640,400,8,16,1,8,1,MM_PACKEDPIX,0>
Mode79 equ <GRAPHICS_MODE,PACK_WIN,640,640,480,8,16,1,8,1,MM_PACKEDPIX,0>
Mode7A equ <GRAPHICS_MODE,PACK_WIN,720,720,540,8,16,1,8,1,MM_PACKEDPIX,0>
;Mode7B equ <GRAPHICS_MODE,PACK_WIN,768,768,576,8,16,1,8,1,MM_PACKEDPIX,0>
;Mode7C equ <GRAPHICS_MODE,PACK_WIN,800,800,600,8,16,1,8,1,MM_PACKEDPIX,0>
