/*
 *	edispall.c  --  display function for edtrans().
 *
 *	9 july 1989  Olle Olsson.
 */

#include "edtrans.h"

void edispall( dp, menu, clear, gmhide )
ifsdes *dp;		/* descriptor */
menudescr *menu;	/* menu to use */
int clear;		/* flag for clear before displaying */
int gmhide;		/* flag for gm_hide() */
{
int i;
transform *tp;

if (gmhide)
	{
	/* hide the mouse pointer */
	gm_hide();
	}

if (clear)
	{
	/* erase everything in sight */
	cleardevice();
	}

/* set up the palette */
palsetup( dp );

/* show the menu */
setcolor( dp -> textcolor );
showmenu( menu );

/* show the transforms */
for (i = 0, tp = dp -> tp; i < dp -> size; ++i, ++tp)
	{
	setcolor( (tp -> color > 0) ? tp -> color : dp -> textcolor );
	xdistrans( tp, &dp -> area );
	}

/* show the mouse pointer */
setcolor( dp -> textcolor );
gm_show();
}

