.pl 63
.LP
.TL
A Morse Code Sending and Receiving Program for the IBM-PC\(tm
.AU
Kevin Schmidt, W9CF
.AB
This is the documentation for CW.C, a program to send
and receive international morse code via the
IBM-PC\(tm serial port.
.AE
.sp 10
.nf
Copyright 1988 by Kevin Schmidt. This document may be reproduced
for any noncommercial purpose as long as credit is given to the author.
.bp
.NH
Introduction
.PP
This documentation is for CW.C a morse code sending
and receiving program written in TURBO-C\(tm 1.0 (with bug patches) for the
IBM-PC\(tm. You should receive the C source with any distribution
of this documentation.
.PP
DISCLAIMER: CW.C bypasses both the BIOS and DOS to reprogram the serial
port hardware and the timer/sound chip. The author takes no responsibility
for what running this code may do to your system. It is provided AS IS
with NO WARRANTEE whatsoever. Run it at your own risk.
.PP
The distribution should contain the files:
.RS
.IP 1.
CW.DOC -- this file
.IP 2.
CW.C -- the source program
.IP 3.
CW.INI -- an example initialization file
.IP 4.
CW.EXE -- (optional) a compiled version of the code. If not supplied or
you want to know what you are using, compile cw.c using TURBO-C\(tm.
My command line to do this is:
.nf
tcc -Lc:\turboc\lib -Ic:\turboc\include cw.c
.fi
where you need to change -L and -I options to correspond to the location
of your library and include files.
.RE
.NH
Setup and Operation
.PP
CW functions as two separate programs one for sending morse from
the keyboard and the other for receiving morse and displaying it on
the screen. The two programs are very loosely coupled. Morse is sent
by toggling the request to send line of the RS-232 serial port.
Mark is +12V and space is -12V. Similarly morse characters are 
received by looking at the clear to send line of the RS-232 port.
.PP
To get started, put CW.EXE in a subdirectory and put CW.INI in the
same subdirectory. Edit the file CW.INI and put in any commands
that you want executed at startup in this file. The example file
is:
.nf
sound off
sound 40
serial 3f8 4
b1  cq cq cq de w9cf w9cf w9cf k 
b2  r tnx for call = rst 
b3  = qth new york city ny = name kevin = hw? 
b4  de w9cf k 
.fi
These commands first turn off the speaker which normally beeps
whenever an input mark is detected. The frequency of the beep
is set to 40HZ. This will be the frequency of the beep if the
sound is turned back on. Next the serial port is set to com1.
Com1 is the default so this line is unnecessary. For com2 you
would use the command serial 2f8 3. See the serial command below
for more information. There are ten send buffers. The first
4 are set in the next 4 lines. Each of these ends with a
space so that a space is the last character sent. However, this
space does not show above. Modify the buffers to hold whatever
you like.
.PP
To test the code, you can loop back the sender to the receiver.
Do this by shorting the clear to send line of the RS-232
port to the request to send line. These should be pins 4 and 5
of a 25 pin connector. Start up CW. The top of the screen holds
help information. The middle of the screen is the receive display
and the bottom portion is the transmit display. The last line
is used as a command line and will be described later.
.PP
Type something at the keyboard. It should be displayed in the
transmit region. Now hit the f9 function key. This will tell the
computer to send the text in the transmit queue out the serial port.
Since this is looped back to the receiver, it should be displayed
in the middle portion of the screen. If you want to hear the
code on the speaker hit the f1 key. Alternatively, you can leave the sound off
line out of cw.ini or replace it with sound on. Note, the speaker is connected
to the receive section. Transmitted characters will not sound the speaker
unless it is looped back to the receiver.
.NH
Help Screen and function keys
.PP
The help screen displays the following information:
.RS
.IP 1.
auto or man -- indicating whether the receive speed is set by the program
by analyzing the incoming morse, or by the operator. Manual mode is probably
necessary if you want to hook this up to a radio.
.IP 2.
dot -- this displays the current speed in words per minute of what the code
thinks are incoming dots.
.IP 3.
dash -- this displays the current speed in words per minute of what the code
thinks are incoming dashs.
.IP 4.
el sp -- this displays the current speed in words per minute of the spaces
between dots and dashes.
.IP 5.
lt sp -- this displays the current speed in words per minute of the spaces
between letters.
.IP 6.
rcv -- this displays the approximate receive speed in words per minute if the
program is set to auto. In manual mode, it displays the manually set
receive speed.
.IP 7.
The other items are a quick reference to what the function keys do, and
how to get command line help.
.RE
.PP
The 10 function keys are set up as follows:
.RS
.IP f1.
-- toggles the speaker on and off.
.IP f2.
-- toggles the receive speed from automatic to manual.
.IP f3.
-- in manual mode decreases the receive speed.
.IP f4.
-- in manual mode increases the receive speed.
.IP f5.
-- increases the transmit speed.
.IP f6.
-- decreases the transmit speed.
.IP f7.
-- set transmit speed to current receive speed.
.IP f8.
-- enter a command in command mode.
.IP f9.
-- toggle from send mode to hold mode. In hold mode, text is entered
in the transmit queue but is not sent until send mode is toggled.
.IP f10.
-- exit from CW program.
.IP Shift-f?.
-- i.e. hold down the shift and function key,
where ? is 1 through 10 causes the corresponding numbered buffer to be
appended to the transmit queue.
.IP CTRL-f?.
-- i.e. hold down the control key and the function key. This erases the
contents of the corresponding numbered buffer and prompts for new text.
It is usually a good idea to end text with a space. A carriage return
(enter key) terminates the text.
.IP ALT-f?.
-- i.e. hold down the alt key and the function key. This displays the
current text in the corresponding numbered buffer.
.RE
.NH
Commands
.PP
The following commands are allowed in command mode. Any command listed
here may also be used in the startup file.
.RS
.IP
read filename -- reads in the filename specified and sends it.
.IP
sound on -- turns on the speaker.
.IP
sound off -- turns off the speaker.
.IP
sound nnnn -- where nnnn is a number, sets the sound frequency to nnnn.
.IP
receive automatic -- set receive speed to automatic.
.IP
receive manual -- set receive speed to manual.
.IP
receive nn -- where nn is a number, sets receive speed to nn words per minute.
.IP
serial hhhh h -- sets the serial port. hhhh is the serial port base address
in hex and h is the hardware interrupt vector used by the serial port.
Initially, this is set to 3f8 4 which is normal for com1. Com2 uses
2f8 3. For other serial ports you will have to fill in the correct values.
You should also check the interrupt handler in the source code to make
sure it does what you want.
.IP
stretch nnnn -- where nnnn is a number, reduces marks and increases spaces
by nnnn*840 nanoseconds. This can be helpful to compensate for pulse
stretching in audio filters.
.IP
bn text -- where n is a number from 1 to 10, fills corresponding buffer
with text where text is whatever is to be sent.
.IP
transmit on -- tells program to send text in transmit queue (see f9 above).
.IP
transmit off -- tells program to hold text in transmit queue (see f9 above).
.RE
.NH
Theory of Operation
.PP
Only a very brief theory of operation will be given.
.PP
The program can be divided into three parts. The first part is an interrupt
handler for the serial port. The serial port is set to interrupt on
change of the modem status. In particular, this happens when the clear
to send line is changed. The interrupt handler simply records the
status of the clear to send line in queue.mark and the time since
the clear to send line last changed in queue.mstime and increments
the queue pointer countin. The serial port stuff is fairly standard
and I used the description given by of R. Jourdain,
"Programmer's Problem Solver for the IBM PC,XT, and AT",
(Prentice Hall, 1986, NY) although he gets the interrupt numbers wrong.
The method used for timing the marks 
and spaces is adapted from B. Sheppard, "High Performance Software
Analysis on the IBM PC", BYTE, January 1987.
.PP
The second part of the code is a replacement for the IRQ0 timer
interrupt. I change the timer to interrupt SPEEDUP times faster
than original. Every SPEEDUP interrupts the old interrupt handler is
called so that disk operations and the bios date should be unaffected.
The replacement interrupt handler takes characters from a queue
and keys the request to send line of the serial port. Note if
you only want to receive morse this replacement routine is not
necessary since microsecond receive timing accuracy can be obtained without
changing this interrupt. Just change SPEEDUP to 1. Note SPEEDUP
must be a power of 2.
.PP
The last part of the code is the human interface, which looks at
the receive queue and displays the result along with some statistics,
and also fills the transmit queue.
.PP
The code has been tested on my 6MHZ ibm pc-at running dos 3.1
with CGA and serial/parallel adaptor and on a zenith z-181 portable.
Any other 80 column or greater display should work. Since the clock
chip is reprogrammed and serial port interrupts are used,
probably only hardware as well as bios level clones of the IBM PC will
run this code. If you are attempting to run this code on a particularly
slow PC, you may want to set SPEEDUP to 1 to start. After everything
is working correctly, increase speedup to get the desired set of
transmit speeds. The possible transmit speeds are given by
dot length = N*840ns*65536/(SPEEDUP) where N is an integer, ns
stands for nanoseconds, and SPEEDUP must be a power of 2 for proper
operation.
.PP
Most of the information in this section is contained in the source code
comments, which also give some additional information.
.NH
Conclusion
.PP
I originally wrote this code as a tool to help teach morse. By hooking
a code key to toggle the clear to send line, the student can see what
she is sending and get a fair idea if her spacing is correct. The
sending portion was added when I needed a cw keyboard for my transmitter.
.PP
I have connected the PC  to my receiver. It is fairly easy to receive
strong signals using machine produced
code like that from W1AW, but much more difficult to deal with noisy
signals and hand sending.
.PP
I do not plan to work on this code in the future. However, if you
have questions, I can be contacted at my address listed in the call book.
