Unit filutil4;
{ a collection of DOS file utilities }
{ Copyright 1993-1996 East Carolina University, Greenville, NC, USA. }
{ Author: David Lunney, Professor of Chemistry, ECU }

(*      ADDRESS: Department of Chemistry
                 East Carolina University
                 Greenville, NC 27858-4353
                 USA


        INQUIRIES REGARDING THIS PROGRAM SHOULD BE DIRECTED
        TO DAVID LUNNEY AT chlunney@ecuvm.cis.ecu.edu OR
        LUNNEY@DELPHI.COM                                            *)

(*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    A COPY OF THE GNU GENERAL PUBLIC SOFTWARE LICENSE HAS BEEN
    PROVIDED WITH THIS PROGRAM IN THE FILE "LICENSE.TXT"       *)

   { No Warranty.  EAST CAROLINA UNIVERSITY DISCLAIMS AND MAKES NO
   REPRESENTATIONS AND EXTENDS NO WARRANTIES, EITHER EXPRESS OR
   IMPLIED. THERE ARE NO EXPRESS OR IMPLIED WARRANTIES OF
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The User
   shall assume all liability for all damages whatsoever that may or
   do arise from the User's use, inability to use, performance, or
   storage of FILUTIL4.  East Carolina University shall not be
   liable to the User for any loss, claims, damages or demands
   whatsoever made by the User or made against the User by any other
   party, due to or arising from the performance of, use of, and/or
   inability to use FILUTIL4 by the User and/or anyone
   else. }

Interface
  Uses DOS, dosfunks, txtutil4;

Const
  COMnames: Array [1..4] Of String [4] = ('COM1', 'COM2', 'COM3', 'COM4');
  LPTnames: Array [1..3] Of String [4] = ('LPT1', 'LPT2', 'LPT3');
  { these constants are also defined in unit PortVars }

Function CheckBadFileName(filnam: String; Var drvrnam: String): Boolean;
Function CheckFileExists2(filnam: String): Boolean;
Function CheckDriveExists(drv: DirStr): Boolean;
Function CheckPathExists(dir: DirStr): Boolean;
Procedure GetCurrentDir(Var dir, drive: DirStr);
Function CheckDirExists(fullname: PathStr; Var dir: DirStr): Boolean;
Function CantOpenOutFile(fullname: PathStr): Boolean;
Procedure OpenOutFile(filename: String; Var filvar: Text);
Procedure OpenInFile(filename: String; Var filvar: Text);

{      following routines are not in filutil2    }

Procedure CheckFileAndDev2(filnam: String; Var isfile, isdev: Boolean);
Procedure CheckNameLength(OldName: PathStr; Var NewName: PathStr;
                                 Var NameTooLong: Boolean);
Function MakeDriveNum(drvltr: Char): Byte;
Function CheckFreeSpace(drvltr: Char): Real;
Function CheckDiskSize(drvltr: Char): Real;
Function CheckDriveReddy(drvltr: Char): Boolean;
Procedure GetAttributes(fnam: String; Var ReadOnlyFile, HiddenFile,
         SystemFile, VolID, DirectoryName, NormalFile, err: Boolean);
Function WritableFile(fnam: String): Boolean;
Procedure CheckPath2(fullname: String; Var drvltr: Char;
       Var DirName, FName, Ext: String; Var DriveReddy,
         IllegalName, OkayDir, InCurDir, FileExists: Boolean);

{      following routines are not in filutil3    }

Function CheckTextFile(fullname: PathStr): Boolean;


Implementation

Function CheckBadFileName(filnam: String; Var drvrnam: String): Boolean;
{ filnam = file name }

{ THE FUNCTION CheckFileExists CAN BE FOOLED BY
  FILE NAMES THAT ARE THE SAME AS DOS DEVICE DRIVERS,
  EVEN IF THE FILE NAME HAS AN EXTENSION: FOR EXAMPLE,
  THE NAME "COM1.DAT" WILL RETURN TRUE. }

 { THEREFORE, A CALL TO CheckBadFileName SHOULD BE MADE
   BEFORE CALLING CheckFileExists }

 { THIS FUNCTION MAKES A DOS FUNCTION CALL
   TO DETERMINE IF THE NAME IS A DEVICE DRIVER. }

  Var
    i: Byte;
    dir, Name, ext: String;
    devnotfile: Boolean;

  Begin
    CheckBadFileName := False;
    drvrnam := 'NONE';
    allcaps(filnam);
    FSplit(filnam, dir, Name, ext);
    { first, check for known DOS drivers }

    For i := 1 To 4 Do If Name = COMnames[i] Then
    Begin
      CheckBadFileName := True;
      drvrnam := Name;
      Exit;
    End;
    For i := 1 To 3 Do If Name = LPTnames[i] Then
    Begin
      CheckBadFileName := True;
      drvrnam := Name;
      Exit;
    End;
    { check aliases for devices and CON }
    If ((Name = 'AUX') Or (Name = 'PRN') Or (Name = 'CON')) Then
    Begin
      CheckBadFileName := True;
      drvrnam := Name;
      Exit;
    End;
    { finally, check other devices }
    If IsDevice(Name) Then
    Begin
      CheckBadFileName := True;
      drvrnam := Name;
    End;
  End; {CheckBadFileName(filnam: string)}

Function CheckFileExists2(filnam: String): Boolean;
{ filnam = file name }

{ THIS FUNCTION CAN BE FOOLED BY FILE NAMES THAT ARE
  THE SAME AS DOS DEVICE DRIVERS, EVEN IF THE FILE
  NAME HAS AN EXTENSION: FOR EXAMPLE, THE NAME "COM1.DAT"
  WILL RETURN TRUE. }
 { THEREFORE, A CALL TO CheckBadFileName SHOULD BE MADE
   BEFORE CALLING CheckFileExists }
 { FILEMODE = 0 ADDED TO ACCOMODATE READ-ONLY FILES
          dl 8-16-96 }

  Var
    tempfile: File; { temporary untyped file }
    filex: Boolean;

  Begin
    {$I-}
    Assign(tempfile, filnam);
    FileMode := 0;  { read-only }
    Reset(tempfile);
    Close(tempfile);
    {$I+}
    If IOResult = 0 Then filex := True Else filex := False;
    FileMode := 2;
    If filex Then CheckFileExists2 := True Else
      CheckFileExists2 :=  False;
    FileMode := 2;  { read-write (default) }

  End; {CheckFileExists2(filnam: string)}


Procedure CheckFileAndDev2(filnam: String; Var IsFile, IsDev: Boolean);
{ filnam = file name }

{ THE FUNCTION CheckFileExists CAN BE FOOLED BY
  FILE NAMES THAT ARE THE SAME AS DOS DEVICE DRIVERS,
  EVEN IF THE FILE NAME HAS AN EXTENSION: FOR EXAMPLE,
  THE NAME "COM1.DAT" WILL RETURN "TRUE". THEREFORE, A
  CALL TO CheckBadFileName SHOULD BE MADE BEFORE CALLING
  CheckFileExists }

 { THIS ROUTINE (CheckFileAndDev2) MAKES A DOS FUNCTION CALL
   TO DETERMINE IF THE NAME IS A DEVICE DRIVER, AND CAN'T BE
   FOOLED. IF THE NAME REFERS TO AN EXISTING FILE, THE BOOLEAN
   VARIABLE IsFile IS SET "TRUE" AND  THE BOOLEAN VARIABLE IsDev
   IS SET "FALSE." IF THE NAME REFERS TO A DEVICE DRIVER, THE
   BOOLEAN VARIABLE IsFile IS SET "FALSE" AND  THE BOOLEAN
   VARIABLE IsDev IS SET "TRUE."  OF COURSE, IF THE NAMES IS
   NEITHER A FILE NOR A DEVICE BOTH VARIABLES ARE SET "FALSE".
   YOU CAN'T LOSE. }

 { THIS ROUTINE THEREFORE REPLACES BOTH CheckFileExists
   CheckBadFileName, WHICH ARE RETAINED IN THIS UNIT ONLY
   BECAUSE THEY ARE CALLED BY SEVERAL OLDER PROGRAMS. }

  Var
    tempfile: File; { temporary untyped file }
    dnam, fnam, ext: String;

  Begin
    {$I-}
    Assign(tempfile, filnam);
    FileMode := 0;  { Set file access to read only }
    Reset(tempfile);
    Close(tempfile);
    {$I+}
    If IOResult = 0 Then IsFile := True Else IsFile := False;
    FileMode  := 2; { default = r/w }
    FSplit(filnam, dnam, fnam, ext);
    IsDev := IsDevice(fnam);
  End; {CheckFileAndDev2}

Function CheckDriveExists(drv: DirStr): Boolean;

  Var
    curdir: DirStr;
    OKdrv: Boolean;

  Begin
    GetDir(0, curdir);
    { copy drive letter and colon }
    If Length(drv) > 2 Then drv := Copy(drv, 1, 2);
    {$I-}
    ChDir(drv);
    If IOResult = 0 Then OKdrv := True Else OKdrv := False;
    {$I+}
    ChDir(curdir);
    If OKdrv Then  CheckDriveExists  := True
    Else CheckDriveExists := False;
  End; {CheckDriveExists(drv: dirstr)}


Function CheckPathExists(dir: DirStr): Boolean;

  Var
    curdir: DirStr;
    OKpath: Boolean;

  Begin
    GetDir(0, curdir);
    {$I-}
    ChDir(dir);
    If IOResult = 0 Then OKpath := True Else OKpath := False;
    {$I+}
    ChDir(curdir);
    If OKpath Then  CheckPathExists  := True
    Else CheckPathExists := False;
  End; {CheckPathExists(dir: dirstr)}

Procedure GetCurrentDir(Var dir, drive: DirStr);
  Begin
    GetDir(0, dir);
    drive := Copy(dir, 1, 2)
  End;


Function CheckDirExists(fullname: PathStr; Var dir: DirStr): Boolean;

  Var
    OKdir: Boolean;
    curdir: DirStr;
    filnam, ext: String;
    lendir: Byte;

  Begin
    GetDir(0, curdir);

    FSplit(fullname, dir, filnam, ext);
    lendir := Length(dir);
    {delete last backslash}
    If ((lendir > 1) And (dir[lendir] = '\' )) Then Delete(dir, lendir, 1);
    {$I-}
    ChDir(dir);
    If IOResult = 0 Then OKdir := True Else OKdir := False;
    ChDir(curdir);
    {$I+}
    If OKdir Then  CheckDirExists  := True
    Else CheckDirExists := False;
  End;

Function CantOpenOutFile(fullname: PathStr): Boolean;

  Var
    OKout: Boolean;
    dummyfile: File; { dummy file }

  Begin
    { prevent erasing existing files }
    If CheckFileExists2(fullname) Then
    Begin
      CantOpenOutFile := True;
      Exit;
    End;
    Assign(dummyfile, fullname);
    {$I-}
    Rewrite(dummyfile);
    If IOResult = 0 Then OKout := True Else OKout := False;
    {$I+}
    If OKout Then
    Begin
      CantOpenOutFile  := False;
      Close(dummyfile);
      Erase(dummyfile);
    End
    Else CantOpenOutFile := True;
  End;

Procedure OpenOutFile(filename: String; Var filvar: Text);

  Begin
    Assign(filvar, filename);
    Rewrite(filvar);
  End;

Procedure OpenInFile(filename: String; Var filvar: Text);

  Begin
    Assign(filvar, filename);
    Reset(filvar);
  End;

(**************************************)

Procedure CheckNameLength(OldName: PathStr; Var NewName: PathStr;
                                 Var NameTooLong: Boolean);

 { truncates file names that are too long. the procedure
  FSplit truncates file names and extensions, but NOT
  directories, so if a directory string is too long it
  stays too long. The function CheckDirExists will catch invalid
  directory strings. dl  8-10-96}

Var
  DirName: DirStr;
  FName: NameStr;
  Ext: ExtStr;

Begin
  allcaps(OldName);
  FSplit(OldName, DirName, FName, Ext);
  NewName := DirName + FName + Ext;
  If Length(NewName) < Length(OldName)
  Then NameTooLong := True Else NameTooLong := False;
End;

Function MakeDriveNum(drvltr: Char): Byte;
 { makes number for drives dl 8-11-96}
  Var
    DrvNum: Byte;
  Begin
    drvltr := UpCase(drvltr);
    Case drvltr Of
      'A' : DrvNum := 1;
      'B' : DrvNum := 2;
      'C' : DrvNum := 3;
      'D' : DrvNum := 4;
      'E' : DrvNum := 5;
      'F' : DrvNum := 6;
    End;
    MakeDriveNum := DrvNum;
  End;

Function CheckFreeSpace(drvltr: Char): Real;
 { returns free space on drive in Mbytes. Returns -1
  if drive invalid or not ready. dl  8-11-96}

  Var
    FreeBytes: LongInt;
    RFreeBytes: Real;
    
  Begin
    FreeBytes := DiskFree(MakeDriveNum(drvltr));
    { DiskFree returns -1 for invalid or not ready drive }
    RFreeBytes := 1.0*FreeBytes;
    If RFreeBytes > 0 Then
      CheckFreeSpace  := RFreeBytes/1.024E06
    Else CheckFreeSpace  := RFreeBytes;
  End;

Function CheckDiskSize(drvltr: Char): Real;
   { returns size of drive in Mbytes. Returns -1
    if drive invalid or not ready. dl  8-11-96}
  Var
    SizeInBytes: LongInt;
    RSize: Real;
    
  Begin
    SizeInBytes :=  DiskSize(MakeDriveNum(drvltr));
    { DiskSize returns -1 for invalid or not ready drive }
    RSize := 1.0*SizeInBytes;
    If RSize > 0 Then
      CheckDiskSize := RSize/1.024E06
    Else CheckDiskSize := RSize;
  End;

Function CheckDriveReddy(drvltr: Char): Boolean;
   { uses call to CheckDiskSize to see if a floppy
    drive is ready. dl  8-11-96}
  Begin
    If CheckDiskSize(drvltr) > 0 Then
      CheckDriveReddy := True
    Else CheckDriveReddy := False;
  End;

Procedure GetAttributes(fnam: String; Var ReadOnlyFile, HiddenFile,
         SystemFile, VolID, DirectoryName, NormalFile, err: Boolean);
{ Determines DOS file attributes }
{ adapted from sample code in Turbo Help dl 8-14-96 }
  Var
    dumfil: File;  { dummy untyped file }
    Attribute: Word;
  Begin
    err := False;
    Assign(dumfil, fnam);
    GetFAttr(dumfil, Attribute);
    If DosError <> 0 Then
    Begin
      err := True;
      Exit;
    End;
    If Attribute And ReadOnly <> 0 Then
      ReadOnlyFile := True
    Else ReadOnlyFile :=  False;
    If Attribute And Hidden <> 0 Then
      HiddenFile := True
    Else HiddenFile :=  False;
    If Attribute And SysFile <> 0 Then
      SystemFile := True
    Else SystemFile := False;
    If Attribute And VolumeID <> 0 Then
      VolID  := True
    Else  VolID  :=  False;
    If Attribute And Directory <> 0 Then
      DirectoryName := True
    Else  DirectoryName := False;
    If Attribute And Archive <> 0 Then
      NormalFile :=  True
    Else NormalFile :=  False;
  End;

Function WritableFile(fnam: String): Boolean;
  Var ReadOnlyFile, HiddenFile,
    SystemFile, VolID, DirectoryName,
    NormalFile, err, OKfil: Boolean;
    { Determines whether a file is writable
    from its DOS file attributes dl 8-13-96 }
  Begin
    GetAttributes(fnam, ReadOnlyFile, HiddenFile,
    SystemFile, VolID, DirectoryName, NormalFile, err);
    If err Then
    Begin
      WritableFile :=  False;
      Exit;
    End;
    OKfil := NormalFile;
    If ((ReadOnlyFile) Or (HiddenFile) Or (SystemFile)
       Or (VolID) Or (DirectoryName))  
    Then OKfil :=  False;
    WritableFile := OKfil;
  End;


Function CheckTextFile(fullname: PathStr): Boolean;
    { checks whether a file is text or binary in two
      ways: looks for bytes > 127 (indicates binary file)
      and at line lengths (always < 255 for text). }
      { dl 8-96 }
  Const
    CRbyte: Byte = 13;
    
  Var
    dummyfile: File Of Byte; { dummy file }
    numbytesread, hibytecount, linelen, maxlen: Word;
    dumbyte: Byte;
    
  Begin
    { check for non-existent files }
    If Not CheckFileExists2(fullname) Then
    Begin
      CheckTextFile := False;
      Exit;
    End;
    numbytesread := 0;
    hibytecount := 0;
    linelen := 0;
    maxlen := 0;
    Assign(dummyfile, fullname);
    FileMode := 0; { read-only mode }
    Reset(dummyfile);
    { if file size is zero, it can be appended to in text mode }
    If FileSize(dummyfile) = 0 Then
    Begin
      Close(dummyfile);
      CheckTextFile := True;
      FileMode := 2;
      Exit;
    End;
    
    { read 2048 bytes or to end of file }
    While ((Not EoF(dummyfile) And (numbytesread < 2048))) Do
    Begin
      Read(dummyfile, dumbyte);
      Inc(numbytesread);
      Inc(linelen);
      If dumbyte > 128 Then Inc(hibytecount)
      Else If dumbyte = CRbyte Then
      Begin
        If linelen > maxlen Then maxlen := linelen;
        linelen := 0;
      End;
    End;
    Close(dummyfile);
    FileMode := 2;   { read-write mode }
    CheckTextFile := True;
    If((maxlen > 255) Or (hibytecount > 0)) Then CheckTextFile := False;
  End;


Procedure CheckPath2(fullname: String; Var drvltr: Char;
       Var DirName, FName, Ext: String; Var DriveReddy,
       IllegalName, OkayDir, InCurDir, FileExists: Boolean);
(*
 arguments:

  fullname: the full path to the file, including
       [drive:] (optional), [directory] (optional),
       file name (required), [file name extension] (optional)

  drvltr: the drive letter for the file (no colon).

  DirName:  the directory, like this: C:\dir1\dir2\
              (with final backslash)

  FName: the file name

  Ext: the file name extension, including period: .EXT

  Hopeless: set TRUE if the file name is hopelessly
            ill-formed.

  DriveReddy: set TRUE if drive is ready, otherwise FALSE.

  IllegalName: set TRUE if the file name is the name of a DOS
                      device driver, otherwise FALSE.

  OkayDir: set TRUE if the directory exists, otherwise FALSE.

  InCurDir: set TRUE if the directory for the file is the
                    current directory,  otherwise FALSE.

  FileExists: set TRUE if the file exists, otherwise FALSE.
                                                            *)

 { file names should have been run through CheckNameLength
   first to cut down long names. }
 { this routine was written for the program Tlkabal1C.pas,
   which has minimal error checking during entry of the file name }
 { returns all info as variables, so final version does  no
   writing or talking dl 8-11-96. }

 { adapted from  Function GoodPath in unit GetKeysB dl 8-10-96 }

 { logicall error in check of current dir corrected dl 2-9-96 }

  Var
    curdir, tempdirnam, tempext: String;
    InCurrentDrive, IsFile, IsDevice: Boolean;
    curdrvltr: Char;
    L: Byte;
    { tempdirnam is same as DirName with final backslash }
    { tempext is same as Ext with leading period (if any) }

  Begin
    { initialize boolean vars.}
    OkayDir := False;
    FileExists := False;
    InCurDir := False;
    InCurrentDrive := False;
    allcaps(fullname);

    FSplit(fullname, tempdirnam, FName, tempext);

    CheckFileAndDev2(fullname, IsFile, IsDevice);
    IllegalName := IsDevice;
    If IllegalName Then FileExists := False
    Else  FileExists := IsFile;

    { delete last backslash }
    L := Length(tempdirnam);
    DirName :=  tempdirnam;

    If ((L > 1) And (DirName[L] = '\')) Then  Delete(DirName, L, 1);

    { get current dir and drive }
    GetDir(0, curdir);
    curdrvltr := curdir[1];
    { if drive not explicit, must be current drive }
    If Pos(':', fullname) = 2 Then drvltr := fullname[1]
    Else
    Begin
      drvltr := curdrvltr;
      DirName := drvltr + ':' + DirName;
    End;
    If drvltr = curdrvltr Then InCurrentDrive := True
    Else InCurrentDrive := False;
    If InCurrentDrive Then DriveReddy :=  True
    Else DriveReddy := CheckDriveReddy(drvltr);
    If Not DriveReddy Then Exit;
    { get rid of period in extension }
    Ext := tempext;
    If Length(Ext) > 1 Then Delete(Ext, 1, 1);
    If Not InCurrentDrive Then InCurDir := False
    Else
    begin
      If ((Pos('\', DirName) = 0) or (DirName = curdir))
            Then InCurDir := True else incurdir := False;
    end;
    If incurdir Then OkayDir := True
    Else
    Begin
      If DriveReddy Then
      Begin
        If CheckDirExists(fullname, DirName) Then OkayDir := True
        Else OkayDir := False;
      End;
    End;
  End;
End.

