/*-------------------------------------------------------------------------

  display.h - Screen display code for the moder.lst viewing program.

  Copyright (c) 1993 Rhys Weatherley

  Permission to use, copy, modify, and distribute this material
  for any purpose and without fee is hereby granted, provided
  that the above copyright notice and this permission notice
  appear in all copies, and that the name of Rhys Weatherley not be
  used in advertising or publicity pertaining to this
  material without specific, prior written permission.
  RHYS WEATHERLEY MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR
  SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
  "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

  Revision History:
  ================

   Version  DD/MM/YY  By  Description
   -------  --------  --  --------------------------------------
     1.0    08/09/93  RW  Original Version of display.h

-------------------------------------------------------------------------*/

#ifndef	__DISPLAY_H__
#define	__DISPLAY_H__

#ifdef	MSDOS
typedef	char huge *DrawPtr;
#else
typedef	char *DrawPtr;
#endif

/*
 * Define the control structure for a displayed list of items.
 */
typedef	struct	{
		  void	*param;		/* Parameter for "draw" */
		  void	(*draw) ( /* DisplayList *, void *param, int item */ );
		  int	num;		/* Number of items in the list */
		  DrawPtr title;	/* Title for the list */
		  int	titlelen;	/* Length of the title */
		  int	fileonly;	/* Only a file if non-zero */
		  int	current;	/* Current item in the list */
		  int	top;		/* Top-most displayed item */
		  int	extra;		/* Extra information for the caller */
		} DisplayList;

/*
 * Initialise the display device.
 */
extern	void	InitDisplay ();

/*
 * Clean up the display device.
 */
extern	void	TermDisplay ();

/*
 * Initialise a display list.
 */
extern	void	InitList ( /* DisplayList *list, void *param,
			      void (*draw) (DisplayList *display,
			      			void *param, int item),
			      int num, DrawPtr title, int titlelen,
			      int fileonly */ );

/*
 * Draw a list of characters.  This is called by a
 * list's "draw" function.
 */
#ifdef	MSDOS
extern	void	DrawChars (DrawPtr str, int len);
#else
extern	void	DrawChars ( /* DrawPtr str, int len */ );
#endif

/*
 * Display a list of items and wait for a selection.
 * Returns -1 if the list was exited.
 */
extern	int	SelectDisplay ( /* DisplayList *list */ );

/*
 * Set the bottom line of the screen to a certain string.
 */
extern	void	SetBottomLine ( /* char *str */ );

/*
 * Report an error to the screen and wait for a keypress.
 */
#ifdef	MSDOS
extern	void	ReportError (char *msg, DrawPtr name, int namelen);
#else
extern	void	ReportError ( /* char *msg, DrawPtr name, int namelen */ );
#endif

#endif	/* __DISPLAY_H__ */
