/*-------------------------------------------------------------------------

  uncomp.c - Uncompress a .Z, .gz, or .zip file to extract moder.lst info.

  Copyright (c) 1993 Rhys Weatherley

  Permission to use, copy, modify, and distribute this material
  for any purpose and without fee is hereby granted, provided
  that the above copyright notice and this permission notice
  appear in all copies, and that the name of Rhys Weatherley not be
  used in advertising or publicity pertaining to this
  material without specific, prior written permission.
  RHYS WEATHERLEY MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR
  SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
  "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

  Revision History:
  ================

   Version  DD/MM/YY  By  Description
   -------  --------  --  --------------------------------------
     1.0    11/09/93  RW  Original Version of uncomp.c

-------------------------------------------------------------------------*/

#include <stdio.h>

#ifdef	__TURBOC__
#ifndef	MSDOS
#define	MSDOS
#endif
  #pragma warn -pro
#endif

#ifdef	MSDOS
#include <dir.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
#define	STRCMP		stricmp
#define	TEMPFILE	"mlstXXXXXX"
#else	/* !MSDOS */
#define	STRCMP		strcmp
#define	TEMPFILE	"/tmp/mlstXXXXXX"
#endif	/* !MSDOS */

/*
 * Define the table of filename extensions and the uncompression
 * programs to use.
 */
typedef	struct	{
		  char	*extension;	/* Filename extension */
#ifdef	MSDOS
		  char	*executable;	/* Name of executable to search for */
#endif	/* MSDOS */
		  char	*commandline;	/* Command-line to execute */
		} Uncompress;
static	Uncompress uncomptable[] =
#ifdef	MSDOS
  {{"Z", "comp16.exe", "comp16 -d <%s >%s"},	/* Waffle's comp16 */
   {"Z", "uncompres.exe", "uncompres <%s >%s"},	/* Any uncompress */
   {"Z", "compress.exe", "compress -d <%s >%s"}, /* Any compress */
   {"Z", "comp12.exe", "comp12 -d <%s >%s"},	/* Waffle's comp12 */
   {"Z", "zcat.exe", "zcat %s >%s"},		/* Last try: is there a zcat? */
   {"gz", "gunzip.exe", "gunzip -c %s >%s"},	/* GNU gunzip */
   {"zip", "unzip.exe", "unzip -c %s moder.lst >%s"}, /* Info-ZIP unzip */
   {"zip", "unzip.com", "unzip -c %s moder.lst >%s"}, /* or Borland unzip */
   {"zip", "pkunzip.exe", "pkunzip -c %s moder.lst >%s"}, /* PkUnZip */
   {NULL, NULL, NULL}};
#else	/* !MSDOS */
  {{"Z", "zcat %s >%s"},			/* Unix zcat */
   {"gz", "gunzip -c %s >%s"},			/* GNU gunzip */
   {"zip", "unzip -pa %s moder.lst >%s"},	/* Info-ZIP unzip */
   {NULL, NULL}};
#endif	/* !MSDOS */

static char tempfile[BUFSIZ];

/*
 * Attempt to decompress a file and extract the moder.lst
 * information for the loading process to use.  Returns
 * NULL if something went wrong during uncompression, or
 * a pointer to the actual filename to use for loading.
 */
char	*UncModerList (filename)
char	*filename;
{
  int len, posn;
  static char cmdline[BUFSIZ];

  tempfile[0] = '\0';

  /* Find the extension on the filename */
  len = strlen (filename);
  while (len > 0 && filename[len - 1] != '.')
    --len;
  if (len == 0)
    return (filename);	/* No extension: load the file directly */

  /* Search the uncompression table for an extension match */
  posn = 0;
  while (uncomptable[posn].extension != NULL)
    {
      if (STRCMP (uncomptable[posn].extension, filename + len) == 0)
        {
#ifdef	MSDOS
	  if (searchpath (uncomptable[posn].executable) != NULL)
	    break;
#else	/* !MSDOS */
	  break;
#endif	/* !MSDOS */
	} /* if */
      ++posn;
    } /* while */
  if (uncomptable[posn].extension == NULL)
    return (filename);	/* Not found: load the file directly */

  /* We've found an uncompression program: execute it */
  printf ("Uncompressing %s ...\n", filename);
  strcpy (tempfile, TEMPFILE);
  mktemp (tempfile);
  sprintf (cmdline, uncomptable[posn].commandline, filename, tempfile);
  system (cmdline);
  if (access (tempfile, 0) < 0)
    return (NULL); /* The temporary file was not created: something's wrong */
  return (tempfile);
} /* UncModerList */

/*
 * Remove any temporary files used by the uncompression process.
 */
void	RemoveUncFiles ()
{
  if (tempfile[0] != '\0')
    unlink (tempfile);
} /* RemoveUncFiles */
