/*                                                                        */
/*                                                                        */
/* file MINIJOY.C                                                         */
/*                                                                        */
/* written in 1994 by Henning Ruch                                        */
/* ported to C by Christof Ruch                                           */
/*                                                                        */
/*                                                                        */
/* reads out status of the MULTI JOYSTICK INTERFACE                       */
/*                                                                        */
/* demo file lacking                                                      */
/*   - keyboard support                                                   */
/*   - joystick reassignment                                              */
/*   - disabling if no MULTIJOY is wanted                                 */
/*                                                                        */
/* MINIJOY uses three DOS environment variables:                          */
/*                                                                        */
/* MULTIPATH is the path where the config file is located                 */
/* MULTICFG  is the name of the config file without extension             */
/* MULTIPORT is optional and states the printer port to be used           */
/*           (port 1 is the default if MULTIPORT is empty)                */
/*                                                                        */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include <ctype.h>

#include "minijoy.h"

/* contains all joystick status information */
/* is updated by calling GetAllJoyState     */
struct TJoy JoyState[MAXPLAYER];

/* stores information about pin assignment  */
/* of the specific interface used           */
struct TDecode
{
        int  stikno1, stikno2;
        char action1, action2;
};

char           multipath[128],multicfg[128],multiport[2],multidelay[6];
unsigned char  printer_port;
unsigned int   pout, p_in;
struct TDecode decode[16];
int            invert;
unsigned int   delaycount;
struct TJoy    old[MAXPLAYER];

/* C has no sets - Grrrr */
int legalchar (char a)
{
        switch (a)
        {
                case 'L':
                case 'R':
                case 'U':
                case 'D':
                case 'F':
                case '*': return 1;
        }
        return 0;
}

/* sets MULTI JOYSTICK INTERFACE to address MJOYADDRESS */
/* reads printer port, i.e. PAPER EMPTY and BUSY bits   */
int read_port (int mjoyaddress)
{
        outport (pout, mjoyaddress);
        asm push cx
        asm mov  cx, delaycount
l:      asm nop
        asm loop l
        asm pop  cx
        return invert ? !inport(p_in) : inport(p_in);
}

/* prints a MULTIJOY error message */
void error_msg (int msg_nr, int code)
{
  printf ("MINIJOY.C error message: \n");
  switch (msg_nr)
  {
    case  1 : printf ("Config file read error\n"); break;
    case  2 : printf ("Config file syntax error: undefined action code ('%c')\n", code); break;
    case  3 : printf ("Config file read error: unexpected end of file\n"); break;
    case  4 : printf ("Config file found but not able to read it (%i)\n",code); break;
    case 12 : printf ("Config file error: illegal joystick number (%i)\n", code); break;
    case  5 : printf ("DOS environment does not contain MULTIPATH (path of config file)\n"); break;
    case  6 : printf ("DOS environment does not contain MULTICFG  (name of config file)\n"); break;
    case  7 : printf ("DOS environment variable MULTICFG must not have an extension\n"); break;
    case  8 : printf ("Invalid DOS environment variable MULTIPORT ('%c')\n", code); break;
    case  9 : printf ("MINIJOY does not support keyboard emulation mode\n"); break;
    case 10 : printf ("Config file read error: address out of range ('%i')\n", code); break;
    case 11 : printf ("Printer port %i not found\n",code); break;
    default : printf ("critical error - no appropriate error message found (error #%i)\n",code);
  }
  printf ("\n");
  printf ("MULTIPATH = %s\n", multipath);
  printf ("MULTICFG  = %s\n", multicfg );
  printf ("MULTIPORT = %s\n", multiport);
  exit(1);
}

/* find printer port number in a string */
int get_port_no (char port_no)
{
        if (port_no<'1' || port_no>'3') error_msg (8, port_no);
        return port_no-'0';
}

/* reads interface pin assignment from disk */
/* resets joystick status variables         */
void InitMultiJoy ()
{
        char cmdline[8];
        FILE *cfg;
        int  i,j;

        strncpy(multipath,getenv ("MULTIPATH"),100); /* read environment variables */
        strncpy(multicfg ,getenv ("MULTICFG" ),100);
        strncpy(multiport,getenv ("MULTIPORT"),2);
        strncpy(multidelay,getenv("MULTIDELAY"),5);

        if (*multidelay)
               delaycount = atoi(multidelay)+1;
        else
               delaycount = 1;

        if (!*multiport) printer_port = 1; else printer_port = get_port_no (*multiport);

        pout = peek (0x40, 8 + (printer_port-1)*2);

        if (!pout) error_msg(11, printer_port);
        p_in = pout + 1;

        if (!*multipath) error_msg(5, 0);          /* undefined? */
        if (!*multicfg ) error_msg(6, 0);          /* undefined? */
        if (strchr(multicfg,'.')) error_msg(7, 0); /* extension? */

        /* read config file */
        strcat(multicfg,".cfg");
        if (multipath[strlen(multipath)-1]!='\\') strcat(multipath,"\\");

        strcat(multipath,multicfg);

        if (!(cfg = fopen(multipath,"ra"))) error_msg (1, 0);

        for (i=0; i<16; i++)
        {
                if (feof(cfg)) error_msg(3,0);

                if (fscanf(cfg,"%d %d %c %d %c", &j,
                           &decode[i].stikno1, &decode[i].action1,
                           &decode[i].stikno2, &decode[i].action2)!=5)
                        error_msg (4, 0);

                if (decode[i].stikno1 < 1 || decode[i].stikno1 > MAXPLAYER)
                        error_msg(12,decode[i].stikno1);

                decode[i].action1 = toupper(decode[i].action1);
                if (!legalchar(decode[i].action1))
                        error_msg (2, decode[i].action1);

                if (decode[i].stikno2 < 1 || decode[i].stikno2 > MAXPLAYER)
                        error_msg(12,decode[i].stikno2);

                decode[i].action2 = toupper(decode[i].action2);
                if (!legalchar(decode[i].action2))
                        error_msg (2, decode[i].action2);
        }

        if (!feof(cfg))
               fgets(cmdline,7,cfg);
        else
               strcpy(cmdline,"");

        invert = (strupr(cmdline)=="INVERT");
        fclose (cfg);

        /* Initialize joystick status variables */
        memset (JoyState, 0, sizeof(JoyState));
}

/* decodes joystick status */
void decode_joystate (int joy, char decode_action)
{
  switch (decode_action)
  {
    case 'L': JoyState[joy].x = -1; JoyState[joy].lhit = old[joy].x!=-1; break;
    case 'R': JoyState[joy].x =  1; JoyState[joy].rhit = old[joy].x!= 1; break;
    case 'U': JoyState[joy].y = -1; JoyState[joy].uhit = old[joy].y!=-1; break;
    case 'D': JoyState[joy].y =  1; JoyState[joy].dhit = old[joy].y!= 1; break;
    case 'F': JoyState[joy].knopf = -1; JoyState[joy].khit = !old[joy].knopf;break;
    case '*': JoyState[joy].xtra  =  1; JoyState[joy].xhit = !old[joy].xtra; break;
  }
}

/* gets status of all joysticks */
void GetAllJoyState ()
{
        int   i;
        int  address, joy, pebu;

        memcpy(old,JoyState,sizeof(JoyState));
        memset(JoyState,0,sizeof(JoyState));

        for (address = 0; address<16; address++)
        {
                pebu = read_port (address);
                /* first bit */
                joy = decode [address].stikno1;
                if (pebu & 0x20)
                        decode_joystate (joy, (decode [address].action1));
                /* second bit */
                joy = decode [address].stikno2;
                if (!(pebu & 0x80))
                        decode_joystate (joy, decode[address].action2);
        }

}

