1000 ' BOOTREC2.BAS -- Checks Disk Boot Record (BIOS Parameter Block)
1010 '
1020 ' ͻ
1030 '  REFERENCE:                                                            
1040 '    PC Magazine DOS Power Tools (techniques, tricks, and utilities),    
1050 '    Paul Somerson, Bantam Computer Books, June 1988                     
1060 '                                                                        
1070 '    BOOTREC.BAS -- Checks Boot Record -- Paul Somerson                  
1080 '    (c) 1987 Ziff Communications Co.                                    
1090 '                                                                        
1100 '  Revised BOOTREC.BAS as follows:                                       
1110 '  .Loop after printing boot record info. to prompt for another drive.   
1120 '   Exit loop by pressing Esc at prompt and return to DOS.               
1130 '  .Allowed any drive letter from A to Z to be specified.                
1140 '  .Added comments to 'Figure things out' section to identify BPB bytes. 
1150 '  .Fixed tracks per side calculation to include hidden sectors, so      
1160 '   tps value would be correct for fixed disks.                          
1170 '  .Fixed DS# calculation to include number of reserved (boot) sectors   
1180 '   instead of defaulting to 1.                                          
1190 '  .Added calculation for number of unused sectors.  These sectors are   
1200 '   not used because of the disk allocation unit (cluster) size.         
1210 '  .Changed DEBUG script filename from SCRIPT.FIL to BOOTREC.SCR         
1220 '  .Changed DEBUG  data  filename from    RAW.FIL to BOOTREC.DAT         
1230 '  .Revised media description byte report.                               
1240 '                                                                        
1250 '  Written by:  Dennis W. Person                  Date:  August 29, 1991 
1260 '               6828 Devonshire Drive                                    
1270 '               Canton, Michigan  48187-2613                             
1280 ' ͼ
1290 '
1300 ' --- Setup ---
1310 '
1320 SCREEN 0,0,0,0:COLOR 7,1,7:KEY OFF:CLS:DIM B(30)
1330 '
1340 B$=STRING$(35,205)
1350 F$="5 inch,"
1360 T$="3 inch,"
1370 S$="Sectors"
1380 S1$="Side,"
1390 S2$="Sides,"
1400 S3$="Tracks,"
1410 '
1420 ' --- Ask which drive to check ---
1430 '
1440 LOCATE 25,1:COLOR 15,4:PRINT SPACE$(80);
1450 LOCATE 25,1:PRINT " Press ";:COLOR 14:PRINT "ESC";:COLOR 15
1460 PRINT " to exit to DOS.";:COLOR 7,1
1470 '
1480 LOCATE 24,1,1,6,7 :'turn cursor on and set scan lines for underscore
1490 PRINT " Enter letter of drive to be examined (A..Z) ? ";
1500 J$=INKEY$:IF J$="" THEN 1500 ELSE IF J$=CHR$(27) THEN 2610
1510 K=CINT(INSTR("AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz",J$)/2)
1520 IF K=0 THEN 1480 
1530 Z$=CHR$(K+64)+":":PRINT Z$;
1540 '
1550 ' --- Create DEBUG script and read disk boot record ---
1560 '
1570 OPEN "BOOTREC.SCR" FOR OUTPUT AS #1
1580 PRINT #1,"L 100";K-1;"0 1"
1590 PRINT #1,"D 100 L 20"
1600 PRINT #1,"Q"
1610 CLOSE #1
1620 SHELL "DEBUG < BOOTREC.SCR > BOOTREC.DAT"
1630 '
1640 ' --- Read raw bytes into array D$() ---
1650 '
1660 OPEN "BOOTREC.DAT" FOR INPUT AS #1:A=0
1670 WHILE NOT EOF(1)
1680   LINE INPUT #1,A$
1690   IF LEFT$(A$,4)<>"Disk" THEN 1710
1700   BEEP:CLS:PRINT "Invalid disk -- ";Z$:CLOSE:GOTO 2550
1710   IF LEN(A$)<70 THEN 1730
1720     D$(A)=MID$(A$,12,48):A=1
1730 WEND
1740 IF MID$(D$(0),38,1)="2" THEN 1760
1750 PRINT "Why are you using DOS 1.x ??  Upgrade!":CLOSE:GOTO 2550
1760 D$=D$(0)+MID$(D$(1),1,41)
1770 FOR A=0 TO 29
1780   B(A+1)=VAL("&H"+MID$(D$,3*A+1,2))
1790 NEXT
1800 CLOSE #1
1810 '
1820 ' --- Figure things out ---
1830 '
1840 BS=B(13)*256+B(12) :'number of bytes per sector
1850 SC=B(14)           :'number of sectors per cluster
1860 RS=B(16)*256+B(15) :'number of reserved (boot) sectors
1870 ' =B(17)           :'number of FAT's
1880 RD=B(19)*256+B(18) :'maximum number of root directory entries
1890 TS=B(21)*256+B(20) :'total number of sectors (w/o hidden sectors)
1900 ' =B(22)           :'media descriptor byte
1910 SF=B(24)*256+B(23) :'number of sectors per FAT
1920 ST=B(26)*256+B(25) :'number of sectors per track
1930 NS=B(28)*256+B(27) :'number of heads (sides)
1940 HS=B(30)*256+B(29) :'number of hidden sectors
1950 '
1960 ' --- Calculate totals ---
1970 '
1980 TF=SF*B(17)         :'total number of sectors allocated to FATs
1990 SD=RD*32/BS         :'total number of sectors allocated to root directory
2000 SS=TS-SD-TF-RS      :'total number of sectors available to data area
2010 US=SS-INT(SS/SC)*SC :'total number of unused (not allocated) sectors
2020 TB#=TS*BS           :'total number of bytes available on disk
2030 DS#=(SS-US)*BS      :'total number of bytes available on disk for data
2040 '
2050 TD=FIX((TS+HS)/NS/ST) :'tracks per side on disk
2060 '
2070 ' --- And print report ---
2080 '
2090 CLS:PRINT B$;" Drive ";Z$;" ";B$
2100 PRINT " OEM Name and version:";TAB(38);
2110 FOR A=4 TO 11:PRINT CHR$(B(A));:NEXT:PRINT
2120 PRINT " Total sectors:";TAB(37);TS
2130 PRINT " Bytes per sector:";TAB(37);BS
2140 PRINT " Sectors per cluster:";TAB(37);SC
2150 PRINT " Bytes per cluster:";TAB(37);SC*BS
2160 PRINT " Reserved (boot record) sectors:";TAB(37);RS
2170 PRINT " Sectors per track:";TAB(37);ST
2180 PRINT " Number of hidden sectors:";TAB(37);HS
2190 PRINT " Number of heads (sides):";TAB(37);NS
2200 PRINT " Tracks per side:";TAB(37);TD
2210 PRINT " Number of File Allocation Tables:";TAB(37);B(17)
2220 PRINT " Sectors per File Allocation Table:";TAB(37);SF
2230 PRINT " Total sectors used by FATs:";TAB(37);TF
2240 PRINT " Maximum root directory entries:";TAB(37);RD
2250 PRINT " Sectors used by root directory:";TAB(37);SD
2260 PRINT " Sectors not used (unallocated):";TAB(37);US
2270 PRINT " Total number of clusters:";TAB(37);INT(SS/SC)
2280 PRINT " Total bytes available on disk:";TAB(37);TB#;"";TB#/1024;CHR$(29);"K"
2290 PRINT " Total bytes available for data:";TAB(37);DS#;"";DS#/1024;CHR$(29);"K"
2300 PRINT " Media descriptor byte [";HEX$(B(22));"]:";TAB(38);
2310 '
2320 ' media descriptor bytes defined by DOS:
2330 ' --------------------------------------
2340 '   F8 -- Fixed Disk or RAM disk
2350 '
2360 '   EF -- 3 inch, 2 sides, 80 tracks, 36 sectors per track -- 2.88M
2370 '   F0 -- 3 inch, 2 sides, 80 tracks, 18 sectors per track -- 1.44M
2380 '   F9 -- 3 inch, 2 sides, 80 tracks,  9 sectors per track -- 720K
2390 '
2400 '   F9 -- 5 inch, 2 sides, 80 tracks, 15 sectors per track -- 1.2M
2410 '   FC -- 5 inch, 1 side,  40 tracks,  9 sectors per track -- 180K
2420 '   FD -- 5 inch, 2 sides, 40 tracks,  9 sectors per track -- 360K
2430 '   FE -- 5 inch, 1 side,  40 tracks,  8 sectors per track -- 160K
2440 '   FF -- 5 inch, 2 sides, 40 tracks,  8 sectors per track -- 320K
2450 '
2460 IF B(22)=248 THEN PRINT "Fixed Disk or RAM disk":GOTO 2550
2470 IF B(22)<>249 GOTO 2500
2480   IF ST=15 THEN PRINT F$;NS;S2$;:GOTO 2540
2490   IF ST=9  THEN PRINT T$;NS;S2$;:GOTO 2540
2500 IF B(22)=240 OR B(22)=239 THEN PRINT T$;NS;S2$;:GOTO 2540
2510 IF B(22)=252 OR B(22)=254 THEN PRINT F$;NS;S1$;:GOTO 2540
2520 IF B(22)=253 OR B(22)=255 THEN PRINT F$;NS;S2$;:GOTO 2540
2530 PRINT "(Unknown Disk Descriptor Byte)":GOTO 2550
2540 PRINT TD;S3$;ST;S$
2550 KILL "BOOTREC.SCR"
2560 KILL "BOOTREC.DAT"
2570 GOTO 1420 :' loop and prompt for another drive
2580 '
2590 ' --- Restore screen and exit to DOS ---
2600 '
2610 COLOR 7,0,0:CLS
2620 SYSTEM
